/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean;

import java.util.Objects;
import org.apache.commons.geometry.core.Embedding;
import org.apache.commons.geometry.euclidean.EuclideanVector;
import org.apache.commons.geometry.euclidean.oned.Vector1D;

public abstract class AbstractLinecastPoint<P extends EuclideanVector<P>, U extends P, L extends Embedding<P, Vector1D>> {
    private final P point;
    private final U normal;
    private final L line;
    private final double abscissa;

    protected AbstractLinecastPoint(P point, U normal, L line) {
        this.point = point;
        this.normal = normal;
        this.line = line;
        this.abscissa = ((Vector1D)line.toSubspace(point)).getX();
    }

    public P getPoint() {
        return this.point;
    }

    public U getNormal() {
        return this.normal;
    }

    public L getLine() {
        return this.line;
    }

    public double getAbscissa() {
        return this.abscissa;
    }

    public int hashCode() {
        return Objects.hash(this.point, this.normal, this.line);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractLinecastPoint other = (AbstractLinecastPoint)obj;
        return Objects.equals(this.point, other.point) && Objects.equals(this.normal, other.normal) && Objects.equals(this.line, other.line);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[point= ").append(this.getPoint()).append(", normal= ").append(this.getNormal()).append(", abscissa= ").append(this.getAbscissa()).append(", line= ").append(this.getLine()).append(']');
        return sb.toString();
    }
}

