/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean;

import org.apache.commons.geometry.core.partitioning.HyperplaneBoundedRegion;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.EuclideanVector;

public abstract class AbstractBounds<P extends EuclideanVector<P>, B extends AbstractBounds<P, B>> {
    private final P min;
    private final P max;

    protected AbstractBounds(P min, P max) {
        this.min = min;
        this.max = max;
    }

    public P getMin() {
        return this.min;
    }

    public P getMax() {
        return this.max;
    }

    public P getDiagonal() {
        return ((EuclideanVector)this.min).vectorTo(this.max);
    }

    public P getCentroid() {
        return ((EuclideanVector)this.min).lerp(this.max, 0.5);
    }

    public abstract boolean hasSize(DoublePrecisionContext var1);

    public abstract boolean contains(P var1);

    public abstract boolean contains(P var1, DoublePrecisionContext var2);

    public abstract boolean intersects(B var1);

    public abstract B intersection(B var1);

    public abstract HyperplaneBoundedRegion<P> toRegion(DoublePrecisionContext var1);

    public boolean eq(B other, DoublePrecisionContext precision) {
        return ((EuclideanVector)this.min).eq(((AbstractBounds)other).getMin(), precision) && ((EuclideanVector)this.max).eq(((AbstractBounds)other).getMax(), precision);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[min= ").append(this.min).append(", max= ").append(this.max).append(']');
        return sb.toString();
    }
}

