/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.precision;

import java.io.Serializable;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.numbers.core.Precision;

public class EpsilonDoublePrecisionContext
extends DoublePrecisionContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double epsilon;

    public EpsilonDoublePrecisionContext(double eps) {
        if (!Double.isFinite(eps) || eps < 0.0) {
            throw new IllegalArgumentException("Invalid epsilon value: " + eps);
        }
        this.epsilon = eps;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    @Override
    public double getMaxZero() {
        return this.getEpsilon();
    }

    @Override
    public int compare(double a, double b) {
        return Precision.compareTo((double)a, (double)b, (double)this.epsilon);
    }

    public int hashCode() {
        int result = 31;
        return result += 17 * Double.hashCode(this.epsilon);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EpsilonDoublePrecisionContext)) {
            return false;
        }
        EpsilonDoublePrecisionContext other = (EpsilonDoublePrecisionContext)obj;
        return Double.compare(this.epsilon, other.epsilon) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[").append("epsilon= ").append(this.epsilon).append("]");
        return sb.toString();
    }
}

