/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.precision;

import java.util.Comparator;

public abstract class DoublePrecisionContext
implements Comparator<Double> {
    public boolean eq(double a, double b) {
        return this.compare(a, b) == 0;
    }

    public boolean eqZero(double n) {
        return this.eq(n, 0.0);
    }

    public boolean lt(double a, double b) {
        return this.compare(a, b) < 0;
    }

    public boolean lte(double a, double b) {
        return this.compare(a, b) <= 0;
    }

    public boolean gt(double a, double b) {
        return this.compare(a, b) > 0;
    }

    public boolean gte(double a, double b) {
        return this.compare(a, b) >= 0;
    }

    public int sign(double a) {
        int cmp = this.compare(a, 0.0);
        if (cmp < 0) {
            return -1;
        }
        if (cmp > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compare(Double a, Double b) {
        return this.compare((double)a, (double)b);
    }

    @Override
    public abstract int compare(double var1, double var3);

    public abstract double getMaxZero();
}

