/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.partitioning.bsp;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.Sized;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;

public final class RegionCutBoundary<P extends Point<P>>
implements Sized {
    private final List<HyperplaneConvexSubset<P>> insideFacing;
    private final List<HyperplaneConvexSubset<P>> outsideFacing;

    RegionCutBoundary(List<HyperplaneConvexSubset<P>> insideFacing, List<HyperplaneConvexSubset<P>> outsideFacing) {
        this.insideFacing = insideFacing != null ? Collections.unmodifiableList(insideFacing) : Collections.emptyList();
        this.outsideFacing = outsideFacing != null ? Collections.unmodifiableList(outsideFacing) : Collections.emptyList();
    }

    public List<HyperplaneConvexSubset<P>> getInsideFacing() {
        return this.insideFacing;
    }

    public List<HyperplaneConvexSubset<P>> getOutsideFacing() {
        return this.outsideFacing;
    }

    @Override
    public double getSize() {
        return this.getTotalSize(this.insideFacing) + this.getTotalSize(this.outsideFacing);
    }

    private double getTotalSize(List<HyperplaneConvexSubset<P>> boundaries) {
        double total = 0.0;
        for (HyperplaneConvexSubset<P> boundary : boundaries) {
            if (!Double.isInfinite(total += boundary.getSize())) continue;
            return total;
        }
        return total;
    }

    public P closest(P pt) {
        P closest = null;
        double closestDist = Double.POSITIVE_INFINITY;
        Iterator<HyperplaneConvexSubset<P>> insideIt = this.insideFacing.iterator();
        Iterator<HyperplaneConvexSubset<P>> outsideIt = this.outsideFacing.iterator();
        while (insideIt.hasNext() || outsideIt.hasNext()) {
            HyperplaneConvexSubset<P> boundary = insideIt.hasNext() ? insideIt.next() : outsideIt.next();
            P testPt = boundary.closest(pt);
            double dist = pt.distance(testPt);
            if (closest != null && !(dist < closestDist)) continue;
            closest = testPt;
            closestDist = dist;
        }
        return closest;
    }

    public boolean contains(P pt) {
        return this.containsInsideFacing(pt) || this.containsOutsideFacing(pt);
    }

    public boolean containsInsideFacing(P pt) {
        return this.anyContains(pt, this.insideFacing);
    }

    public boolean containsOutsideFacing(P pt) {
        return this.anyContains(pt, this.outsideFacing);
    }

    private boolean anyContains(P pt, List<HyperplaneConvexSubset<P>> boundaries) {
        for (HyperplaneConvexSubset<P> boundary : boundaries) {
            if (!boundary.contains(pt)) continue;
            return true;
        }
        return false;
    }
}

