/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.partitioning.bsp;

import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTree;

@FunctionalInterface
public interface BSPTreeVisitor<P extends Point<P>, N extends BSPTree.Node<P, N>> {
    public Result visit(N var1);

    default public Order visitOrder(N internalNode) {
        return Order.NODE_MINUS_PLUS;
    }

    public static abstract class FarthestFirstVisitor<P extends Point<P>, N extends BSPTree.Node<P, N>>
    extends TargetPointVisitor<P, N> {
        public FarthestFirstVisitor(P target) {
            super(target);
        }

        @Override
        public Order visitOrder(N node) {
            if (node.getCutHyperplane().offset(this.getTarget()) < 0.0) {
                return Order.PLUS_NODE_MINUS;
            }
            return Order.MINUS_NODE_PLUS;
        }
    }

    public static abstract class ClosestFirstVisitor<P extends Point<P>, N extends BSPTree.Node<P, N>>
    extends TargetPointVisitor<P, N> {
        public ClosestFirstVisitor(P target) {
            super(target);
        }

        @Override
        public Order visitOrder(N node) {
            if (node.getCutHyperplane().offset(this.getTarget()) > 0.0) {
                return Order.PLUS_NODE_MINUS;
            }
            return Order.MINUS_NODE_PLUS;
        }
    }

    public static abstract class TargetPointVisitor<P extends Point<P>, N extends BSPTree.Node<P, N>>
    implements BSPTreeVisitor<P, N> {
        private final P target;

        public TargetPointVisitor(P target) {
            this.target = target;
        }

        public P getTarget() {
            return this.target;
        }
    }

    public static enum Result {
        CONTINUE,
        TERMINATE;

    }

    public static enum Order {
        PLUS_MINUS_NODE,
        PLUS_NODE_MINUS,
        MINUS_PLUS_NODE,
        MINUS_NODE_PLUS,
        NODE_PLUS_MINUS,
        NODE_MINUS_PLUS,
        NONE;

    }
}

