/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.partitioning.bsp;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractRegionBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.RegionCutRule;

public abstract class AbstractPartitionedRegionBuilder<P extends Point<P>, N extends AbstractRegionBSPTree.AbstractRegionNode<P, N>> {
    private static final Comparator<BSPTree.Node<?, ?>> DEEPEST_FIRST_ORDER = (a, b) -> Integer.compare(b.depth(), a.depth());
    private final AbstractRegionBSPTree<P, N> tree;
    private final AbstractBSPTree.SubtreeInitializer<N> subtreeInit;
    private boolean insertingPartitions = true;
    private final Set<N> partitionNodes = new HashSet<N>();

    protected AbstractPartitionedRegionBuilder(AbstractRegionBSPTree<P, N> tree) {
        if (!tree.isEmpty()) {
            throw new IllegalArgumentException("Tree must be empty");
        }
        this.tree = tree;
        this.subtreeInit = tree.getSubtreeInitializer(RegionCutRule.MINUS_INSIDE);
    }

    protected AbstractRegionBSPTree<P, N> buildInternal() {
        this.tree.condense();
        if (this.propagateRegionInterior()) {
            this.tree.condense();
        }
        return this.tree;
    }

    protected void insertPartitionInternal(HyperplaneConvexSubset<P> partition) {
        this.ensureInsertingPartitions();
        this.tree.insert(partition, RegionCutRule.INHERIT);
    }

    protected void insertBoundaryInternal(HyperplaneConvexSubset<P> boundary) {
        if (this.insertingPartitions) {
            for (AbstractRegionBSPTree.AbstractRegionNode node : this.tree.nodes()) {
                if (!node.isInternal()) continue;
                this.partitionNodes.add(node);
            }
            this.insertingPartitions = false;
        }
        this.insertBoundaryRecursive((AbstractRegionBSPTree.AbstractRegionNode)this.tree.getRoot(), boundary, boundary.getHyperplane().span(), (leaf, cut) -> this.tree.setNodeCut((AbstractRegionBSPTree.AbstractRegionNode)leaf, (HyperplaneConvexSubset<P>)cut, (AbstractBSPTree.SubtreeInitializer<AbstractRegionBSPTree.AbstractRegionNode>)this.subtreeInit));
    }

    private void insertBoundaryRecursive(N node, HyperplaneConvexSubset<P> insert, HyperplaneConvexSubset<P> trimmed, BiConsumer<N, HyperplaneConvexSubset<P>> leafFn) {
        if (((AbstractBSPTree.AbstractNode)node).isLeaf()) {
            leafFn.accept(node, trimmed);
        } else {
            Split<HyperplaneConvexSubset<P>> insertSplit = insert.split(((AbstractBSPTree.AbstractNode)node).getCutHyperplane());
            HyperplaneConvexSubset<P> minus = insertSplit.getMinus();
            HyperplaneConvexSubset<P> plus = insertSplit.getPlus();
            if (minus == null && plus == null && this.isPartitionNode(node)) {
                this.partitionNodes.remove(node);
                boolean sameOrientation = ((AbstractBSPTree.AbstractNode)node).getCutHyperplane().similarOrientation(insert.getHyperplane());
                AbstractRegionBSPTree.AbstractRegionNode insertMinus = sameOrientation ? (AbstractRegionBSPTree.AbstractRegionNode)((AbstractBSPTree.AbstractNode)node).getMinus() : (AbstractRegionBSPTree.AbstractRegionNode)((AbstractBSPTree.AbstractNode)node).getPlus();
                AbstractRegionBSPTree.AbstractRegionNode insertPlus = sameOrientation ? (AbstractRegionBSPTree.AbstractRegionNode)((AbstractBSPTree.AbstractNode)node).getPlus() : (AbstractRegionBSPTree.AbstractRegionNode)((AbstractBSPTree.AbstractNode)node).getMinus();
                this.insertBoundaryRecursive(insertMinus, insert, trimmed, (leaf, cut) -> leaf.setLocation(RegionLocation.INSIDE));
                this.insertBoundaryRecursive(insertPlus, insert, trimmed, (leaf, cut) -> leaf.setLocation(RegionLocation.OUTSIDE));
            } else if (minus != null || plus != null) {
                Split<HyperplaneConvexSubset<P>> trimmedSplit = trimmed.split(((AbstractBSPTree.AbstractNode)node).getCutHyperplane());
                HyperplaneConvexSubset<P> trimmedMinus = trimmedSplit.getMinus();
                HyperplaneConvexSubset<P> trimmedPlus = trimmedSplit.getPlus();
                if (minus != null) {
                    this.insertBoundaryRecursive((AbstractRegionBSPTree.AbstractRegionNode)((AbstractBSPTree.AbstractNode)node).getMinus(), minus, trimmedMinus, leafFn);
                }
                if (plus != null) {
                    this.insertBoundaryRecursive((AbstractRegionBSPTree.AbstractRegionNode)((AbstractBSPTree.AbstractNode)node).getPlus(), plus, trimmedPlus, leafFn);
                }
            }
        }
    }

    private boolean propagateRegionInterior() {
        List<N> outsidePartitionedLeaves = this.getOutsidePartitionedLeaves();
        outsidePartitionedLeaves.sort(DEEPEST_FIRST_ORDER);
        int changeCount = 0;
        for (AbstractRegionBSPTree.AbstractRegionNode leaf : outsidePartitionedLeaves) {
            AbstractRegionBSPTree.AbstractRegionNode sibling;
            AbstractRegionBSPTree.AbstractRegionNode parent = (AbstractRegionBSPTree.AbstractRegionNode)leaf.getParent();
            AbstractRegionBSPTree.AbstractRegionNode abstractRegionNode = sibling = leaf.isMinus() ? (AbstractRegionBSPTree.AbstractRegionNode)parent.getPlus() : (AbstractRegionBSPTree.AbstractRegionNode)parent.getMinus();
            if (!this.touchesInside(parent.getCut(), sibling)) continue;
            leaf.setLocation(RegionLocation.INSIDE);
            ++changeCount;
        }
        return changeCount > 0;
    }

    private List<N> getOutsidePartitionedLeaves() {
        ArrayList result = new ArrayList();
        AbstractRegionBSPTree.AbstractRegionNode root = (AbstractRegionBSPTree.AbstractRegionNode)this.tree.getRoot();
        this.collectOutsidePartitionedLeavesRecursive(root, false, result);
        return result;
    }

    private void collectOutsidePartitionedLeavesRecursive(N node, boolean parentIsPartitionNode, List<N> result) {
        if (node != null) {
            if (parentIsPartitionNode && ((AbstractRegionBSPTree.AbstractRegionNode)node).isOutside()) {
                result.add(node);
            }
            boolean partitionNode = this.isPartitionNode(node);
            this.collectOutsidePartitionedLeavesRecursive((AbstractRegionBSPTree.AbstractRegionNode)((AbstractBSPTree.AbstractNode)node).getMinus(), partitionNode, result);
            this.collectOutsidePartitionedLeavesRecursive((AbstractRegionBSPTree.AbstractRegionNode)((AbstractBSPTree.AbstractNode)node).getPlus(), partitionNode, result);
        }
    }

    private boolean touchesInside(HyperplaneConvexSubset<P> sub, N node) {
        if (sub != null) {
            if (((AbstractBSPTree.AbstractNode)node).isLeaf()) {
                return ((AbstractRegionBSPTree.AbstractRegionNode)node).isInside();
            }
            Split<HyperplaneConvexSubset<P>> split = sub.split(((AbstractBSPTree.AbstractNode)node).getCutHyperplane());
            return this.touchesInside(split.getMinus(), (AbstractRegionBSPTree.AbstractRegionNode)((AbstractBSPTree.AbstractNode)node).getMinus()) || this.touchesInside(split.getPlus(), (AbstractRegionBSPTree.AbstractRegionNode)((AbstractBSPTree.AbstractNode)node).getPlus());
        }
        return false;
    }

    private boolean isPartitionNode(N node) {
        return this.partitionNodes.contains(node);
    }

    private void ensureInsertingPartitions() {
        if (!this.insertingPartitions) {
            throw new IllegalStateException("Cannot insert partitions after boundaries have been inserted");
        }
    }
}

