/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.partitioning.bsp;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.HyperplaneLocation;
import org.apache.commons.geometry.core.partitioning.HyperplaneSubset;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.partitioning.SplitLocation;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTreePrinter;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTreeVisitor;

public abstract class AbstractBSPTree<P extends Point<P>, N extends AbstractNode<P, N>>
implements BSPTree<P, N> {
    private static final int DEFAULT_TREE_STRING_MAX_DEPTH = 8;
    private static final int UNKNOWN_VALUE = -1;
    private N root;
    private int version;

    @Override
    public N getRoot() {
        if (this.root == null) {
            this.setRoot(this.createNode());
        }
        return this.root;
    }

    protected void setRoot(N root) {
        this.root = root;
        ((AbstractNode)this.root).makeRoot();
        this.invalidate();
    }

    @Override
    public int count() {
        return ((AbstractNode)this.getRoot()).count();
    }

    @Override
    public int height() {
        return ((AbstractNode)this.getRoot()).height();
    }

    @Override
    public void accept(BSPTreeVisitor<P, N> visitor) {
        this.accept(this.getRoot(), visitor);
    }

    @Override
    public N findNode(P pt, BSPTree.FindNodeCutRule cutBehavior) {
        return (N)this.findNode(this.getRoot(), pt, cutBehavior);
    }

    @Override
    public Iterable<N> nodes() {
        return () -> new NodeIterator(this.getRoot());
    }

    @Override
    public void copy(BSPTree<P, N> src) {
        this.copySubtree((AbstractNode)src.getRoot(), this.getRoot());
    }

    @Override
    public void extract(N node) {
        N extracted = this.importSubtree(node);
        N newRoot = this.extractParentPath(node, extracted);
        this.setRoot(newRoot);
    }

    @Override
    public void transform(Transform<P> transform) {
        boolean swapChildren = this.swapsInsideOutside(transform);
        this.transformRecursive(this.getRoot(), transform, swapChildren);
        this.invalidate();
    }

    public String treeString() {
        return this.treeString(8);
    }

    public String treeString(int maxDepth) {
        BSPTreePrinter printer = new BSPTreePrinter(maxDepth);
        this.accept(printer);
        return printer.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[count= " + this.count() + ", height= " + this.height() + "]";
    }

    protected abstract N createNode();

    protected abstract void copyNodeProperties(N var1, N var2);

    protected N copyNode(N src) {
        N copy = this.createNode();
        this.copyNodeProperties(src, copy);
        return copy;
    }

    protected N copySubtree(N src, N dst) {
        if (src != dst) {
            this.copyNodeProperties(src, dst);
            HyperplaneConvexSubset cut = null;
            BSPTree.Node minus = null;
            BSPTree.Node plus = null;
            if (!((AbstractNode)src).isLeaf()) {
                BSPTree dstTree = ((AbstractNode)dst).getTree();
                cut = ((AbstractNode)src).getCut();
                minus = this.copySubtree(((AbstractNode)src).getMinus(), ((AbstractBSPTree)dstTree).createNode());
                plus = this.copySubtree(((AbstractNode)src).getPlus(), ((AbstractBSPTree)dstTree).createNode());
            }
            ((AbstractNode)dst).setSubtree(cut, minus, plus);
        }
        return (N)dst;
    }

    protected N importSubtree(N src) {
        if (((AbstractNode)src).getTree() != this) {
            return this.copySubtree(src, this.createNode());
        }
        return src;
    }

    protected N extractParentPath(N src, N dst) {
        Object dstParent = dst;
        Object srcChild = src;
        BSPTree.Node srcParent = ((AbstractNode)srcChild).getParent();
        while (srcParent != null) {
            N dstChild = dstParent;
            dstParent = this.copyNode(srcParent);
            if (((AbstractNode)srcChild).isMinus()) {
                ((AbstractNode)dstParent).setSubtree(((AbstractNode)srcParent).getCut(), dstChild, (BSPTree.Node)this.copyNode(((AbstractNode)srcParent).getPlus()));
            } else {
                ((AbstractNode)dstParent).setSubtree(((AbstractNode)srcParent).getCut(), this.copyNode(((AbstractNode)srcParent).getMinus()), dstChild);
            }
            srcChild = srcParent;
            srcParent = ((AbstractNode)srcChild).getParent();
        }
        return (N)dstParent;
    }

    protected N findNode(N start, P pt, BSPTree.FindNodeCutRule cutRule) {
        Hyperplane<P> cutHyper = ((AbstractNode)start).getCutHyperplane();
        if (cutHyper != null) {
            boolean onCut;
            HyperplaneLocation cutLoc = cutHyper.classify(pt);
            boolean onPlusSide = cutLoc == HyperplaneLocation.PLUS;
            boolean onMinusSide = cutLoc == HyperplaneLocation.MINUS;
            boolean bl = onCut = !onPlusSide && !onMinusSide;
            if (onMinusSide || onCut && cutRule == BSPTree.FindNodeCutRule.MINUS) {
                return (N)this.findNode(((AbstractNode)start).getMinus(), pt, cutRule);
            }
            if (onPlusSide || cutRule == BSPTree.FindNodeCutRule.PLUS) {
                return (N)this.findNode(((AbstractNode)start).getPlus(), pt, cutRule);
            }
        }
        return start;
    }

    protected void accept(N node, BSPTreeVisitor<P, N> visitor) {
        this.acceptRecursive(node, visitor);
    }

    private boolean acceptRecursive(N node, BSPTreeVisitor<P, N> visitor) {
        if (((AbstractNode)node).isLeaf()) {
            return this.shouldContinueVisit(visitor.visit(node));
        }
        BSPTreeVisitor.Order order = visitor.visitOrder(node);
        if (order != null) {
            switch (order) {
                case PLUS_MINUS_NODE: {
                    return this.acceptRecursive(((AbstractNode)node).getPlus(), visitor) && this.acceptRecursive(((AbstractNode)node).getMinus(), visitor) && this.shouldContinueVisit(visitor.visit(node));
                }
                case PLUS_NODE_MINUS: {
                    return this.acceptRecursive(((AbstractNode)node).getPlus(), visitor) && this.shouldContinueVisit(visitor.visit(node)) && this.acceptRecursive(((AbstractNode)node).getMinus(), visitor);
                }
                case MINUS_PLUS_NODE: {
                    return this.acceptRecursive(((AbstractNode)node).getMinus(), visitor) && this.acceptRecursive(((AbstractNode)node).getPlus(), visitor) && this.shouldContinueVisit(visitor.visit(node));
                }
                case MINUS_NODE_PLUS: {
                    return this.acceptRecursive(((AbstractNode)node).getMinus(), visitor) && this.shouldContinueVisit(visitor.visit(node)) && this.acceptRecursive(((AbstractNode)node).getPlus(), visitor);
                }
                case NODE_PLUS_MINUS: {
                    return this.shouldContinueVisit(visitor.visit(node)) && this.acceptRecursive(((AbstractNode)node).getPlus(), visitor) && this.acceptRecursive(((AbstractNode)node).getMinus(), visitor);
                }
                case NODE_MINUS_PLUS: {
                    return this.shouldContinueVisit(visitor.visit(node)) && this.acceptRecursive(((AbstractNode)node).getMinus(), visitor) && this.acceptRecursive(((AbstractNode)node).getPlus(), visitor);
                }
            }
        }
        return true;
    }

    private boolean shouldContinueVisit(BSPTreeVisitor.Result result) {
        return result == BSPTreeVisitor.Result.CONTINUE;
    }

    protected boolean cutNode(N node, Hyperplane<P> cutter, SubtreeInitializer<N> subtreeInitializer) {
        HyperplaneConvexSubset<P> cut = this.trimToNode(node, cutter.span());
        if (cut == null || cut.isEmpty()) {
            this.removeNodeCut(node);
            return false;
        }
        this.setNodeCut(node, cut, subtreeInitializer);
        return true;
    }

    protected HyperplaneConvexSubset<P> trimToNode(N node, HyperplaneConvexSubset<P> sub) {
        HyperplaneConvexSubset result = sub;
        Object currentNode = node;
        for (BSPTree.Node parentNode = ((AbstractNode)node).getParent(); parentNode != null && result != null; parentNode = ((AbstractNode)parentNode).getParent()) {
            Split<HyperplaneConvexSubset<P>> split = result.split(((AbstractNode)parentNode).getCutHyperplane());
            if (split.getLocation() == SplitLocation.NEITHER) {
                if (result.getHyperplane().similarOrientation(((AbstractNode)parentNode).getCutHyperplane())) {
                    result = null;
                }
            } else {
                result = ((AbstractNode)currentNode).isPlus() ? split.getPlus() : split.getMinus();
            }
            currentNode = parentNode;
        }
        return result;
    }

    protected boolean removeNodeCut(N node) {
        if (((AbstractNode)node).getCut() != null) {
            ((AbstractNode)node).setSubtree(null, null, null);
            this.invalidate();
            return true;
        }
        return false;
    }

    protected void setNodeCut(N node, HyperplaneConvexSubset<P> cut, SubtreeInitializer<N> subtreeInitializer) {
        ((AbstractNode)node).setSubtree(cut, this.createNode(), this.createNode());
        subtreeInitializer.initSubtree(node);
        this.invalidate();
    }

    protected void insert(HyperplaneConvexSubset<P> convexSub, SubtreeInitializer<N> subtreeInit) {
        this.insertRecursive(this.getRoot(), convexSub, convexSub.getHyperplane().span(), subtreeInit);
    }

    private void insertRecursive(N node, HyperplaneConvexSubset<P> insert, HyperplaneConvexSubset<P> trimmed, SubtreeInitializer<N> subtreeInit) {
        if (((AbstractNode)node).isLeaf()) {
            this.setNodeCut(node, trimmed, subtreeInit);
        } else {
            Split<HyperplaneConvexSubset<P>> insertSplit = insert.split(((AbstractNode)node).getCutHyperplane());
            HyperplaneConvexSubset<P> minus = insertSplit.getMinus();
            HyperplaneConvexSubset<P> plus = insertSplit.getPlus();
            if (minus != null || plus != null) {
                Split<HyperplaneConvexSubset<P>> trimmedSplit = trimmed.split(((AbstractNode)node).getCutHyperplane());
                if (minus != null) {
                    this.insertRecursive(((AbstractNode)node).getMinus(), minus, trimmedSplit.getMinus(), subtreeInit);
                }
                if (plus != null) {
                    this.insertRecursive(((AbstractNode)node).getPlus(), plus, trimmedSplit.getPlus(), subtreeInit);
                }
            }
        }
    }

    protected boolean swapsInsideOutside(Transform<P> transform) {
        return !transform.preservesOrientation();
    }

    private void transformRecursive(N node, Transform<P> t, boolean swapChildren) {
        if (((AbstractNode)node).isInternal()) {
            HyperplaneSubset transformedCut = ((AbstractNode)node).getCut().transform((Transform)t);
            this.transformRecursive(((AbstractNode)node).getMinus(), t, swapChildren);
            this.transformRecursive(((AbstractNode)node).getPlus(), t, swapChildren);
            BSPTree.Node transformedMinus = swapChildren ? ((AbstractNode)node).getPlus() : ((AbstractNode)node).getMinus();
            BSPTree.Node transformedPlus = swapChildren ? ((AbstractNode)node).getMinus() : ((AbstractNode)node).getPlus();
            ((AbstractNode)node).setSubtree(transformedCut, (BSPTree.Node)transformedMinus, (BSPTree.Node)transformedPlus);
        }
    }

    protected void splitIntoTrees(Hyperplane<P> splitter, AbstractBSPTree<P, N> minus, AbstractBSPTree<P, N> plus) {
        AbstractBSPTree<P, BSPTree.Node> temp = minus != null ? minus : plus;
        BSPTree.Node splitRoot = temp.splitSubtree(this.getRoot(), splitter.span());
        if (minus != null) {
            if (plus != null) {
                plus.extract(((AbstractNode)splitRoot).getPlus());
            }
            minus.extract(((AbstractNode)splitRoot).getMinus());
        } else {
            plus.extract(((AbstractNode)splitRoot).getPlus());
        }
    }

    protected N splitSubtree(N node, HyperplaneConvexSubset<P> partitioner) {
        if (((AbstractNode)node).isLeaf()) {
            return this.splitLeafNode(node, partitioner);
        }
        return this.splitInternalNode(node, partitioner);
    }

    private N splitLeafNode(N node, HyperplaneConvexSubset<P> partitioner) {
        N parent = this.createNode();
        ((AbstractNode)parent).setSubtree(partitioner, this.copyNode(node), this.copyNode(node));
        return parent;
    }

    private N splitInternalNode(N node, HyperplaneConvexSubset<P> partitioner) {
        Object resultPlus;
        BSPTree.Node resultMinus;
        Split<HyperplaneConvexSubset<P>> partitionerSplit = partitioner.split(((AbstractNode)node).getCutHyperplane());
        Split nodeCutSplit = ((AbstractNode)node).getCut().split(partitioner.getHyperplane());
        SplitLocation partitionerSplitSide = partitionerSplit.getLocation();
        SplitLocation nodeCutSplitSide = nodeCutSplit.getLocation();
        Object result = this.createNode();
        if (partitionerSplitSide == SplitLocation.PLUS) {
            if (nodeCutSplitSide == SplitLocation.PLUS) {
                BSPTree.Node nodePlusSplit = this.splitSubtree(((AbstractNode)node).getPlus(), partitioner);
                resultMinus = ((AbstractNode)nodePlusSplit).getMinus();
                resultPlus = this.copyNode(node);
                ((AbstractNode)resultPlus).setSubtree(((AbstractNode)node).getCut(), (BSPTree.Node)this.importSubtree(((AbstractNode)node).getMinus()), (BSPTree.Node)((AbstractNode)nodePlusSplit).getPlus());
            } else {
                BSPTree.Node nodePlusSplit = this.splitSubtree(((AbstractNode)node).getPlus(), partitioner);
                resultMinus = this.copyNode(node);
                ((AbstractNode)resultMinus).setSubtree(((AbstractNode)node).getCut(), this.importSubtree(((AbstractNode)node).getMinus()), ((AbstractNode)nodePlusSplit).getMinus());
                resultPlus = ((AbstractNode)nodePlusSplit).getPlus();
            }
        } else if (partitionerSplitSide == SplitLocation.MINUS) {
            if (nodeCutSplitSide == SplitLocation.MINUS) {
                BSPTree.Node nodeMinusSplit = this.splitSubtree(((AbstractNode)node).getMinus(), partitioner);
                resultMinus = this.copyNode(node);
                ((AbstractNode)resultMinus).setSubtree(((AbstractNode)node).getCut(), ((AbstractNode)nodeMinusSplit).getMinus(), this.importSubtree(((AbstractNode)node).getPlus()));
                resultPlus = ((AbstractNode)nodeMinusSplit).getPlus();
            } else {
                BSPTree.Node nodeMinusSplit = this.splitSubtree(((AbstractNode)node).getMinus(), partitioner);
                resultMinus = ((AbstractNode)nodeMinusSplit).getMinus();
                resultPlus = this.copyNode(node);
                ((AbstractNode)resultPlus).setSubtree(((AbstractNode)node).getCut(), (BSPTree.Node)((AbstractNode)nodeMinusSplit).getPlus(), (BSPTree.Node)this.importSubtree(((AbstractNode)node).getPlus()));
            }
        } else if (partitionerSplitSide == SplitLocation.BOTH) {
            BSPTree.Node nodeMinusSplit = this.splitSubtree(((AbstractNode)node).getMinus(), partitionerSplit.getMinus());
            BSPTree.Node nodePlusSplit = this.splitSubtree(((AbstractNode)node).getPlus(), partitionerSplit.getPlus());
            resultMinus = this.copyNode(node);
            ((AbstractNode)resultMinus).setSubtree(nodeCutSplit.getMinus(), ((AbstractNode)nodeMinusSplit).getMinus(), ((AbstractNode)nodePlusSplit).getMinus());
            resultPlus = this.copyNode(node);
            ((AbstractNode)resultPlus).setSubtree(nodeCutSplit.getPlus(), (BSPTree.Node)((AbstractNode)nodeMinusSplit).getPlus(), (BSPTree.Node)((AbstractNode)nodePlusSplit).getPlus());
        } else {
            boolean sameOrientation = partitioner.getHyperplane().similarOrientation(((AbstractNode)node).getCutHyperplane());
            resultMinus = this.importSubtree(sameOrientation ? ((AbstractNode)node).getMinus() : ((AbstractNode)node).getPlus());
            resultPlus = this.importSubtree(sameOrientation ? ((AbstractNode)node).getPlus() : ((AbstractNode)node).getMinus());
        }
        ((AbstractNode)result).setSubtree(partitioner, (BSPTree.Node)resultMinus, resultPlus);
        return (N)result;
    }

    protected void invalidate() {
        this.version = Math.max(0, this.version + 1);
    }

    protected int getVersion() {
        return this.version;
    }

    private static final class NodeIterator<P extends Point<P>, N extends AbstractNode<P, N>>
    implements Iterator<N> {
        private final Deque<N> stack = new LinkedList<N>();

        NodeIterator(N subtreeRoot) {
            this.stack.push(subtreeRoot);
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public N next() {
            if (this.stack.isEmpty()) {
                throw new NoSuchElementException();
            }
            AbstractNode result = (AbstractNode)this.stack.pop();
            if (result != null && !result.isLeaf()) {
                this.stack.push(result.getPlus());
                this.stack.push(result.getMinus());
            }
            return (N)result;
        }
    }

    public static abstract class AbstractNode<P extends Point<P>, N extends AbstractNode<P, N>>
    implements BSPTree.Node<P, N> {
        private final AbstractBSPTree<P, N> tree;
        private N parent;
        private HyperplaneConvexSubset<P> cut;
        private N minus;
        private N plus;
        private int nodeVersion = -1;
        private int depth = -1;
        private int count = -1;
        private int height = -1;

        protected AbstractNode(AbstractBSPTree<P, N> tree) {
            this.tree = tree;
        }

        @Override
        public AbstractBSPTree<P, N> getTree() {
            return this.tree;
        }

        @Override
        public int depth() {
            int parentDepth;
            if (this.depth == -1 && this.parent != null && (parentDepth = ((AbstractNode)this.parent).depth()) != -1) {
                this.depth = parentDepth + 1;
            }
            return this.depth;
        }

        @Override
        public int height() {
            this.checkValid();
            if (this.height == -1) {
                this.height = this.isLeaf() ? 0 : Math.max(((AbstractNode)this.getMinus()).height(), ((AbstractNode)this.getPlus()).height()) + 1;
            }
            return this.height;
        }

        @Override
        public int count() {
            this.checkValid();
            if (this.count == -1) {
                this.count = 1;
                if (!this.isLeaf()) {
                    this.count += ((AbstractNode)this.minus).count() + ((AbstractNode)this.plus).count();
                }
            }
            return this.count;
        }

        @Override
        public Iterable<N> nodes() {
            return () -> new NodeIterator(this.getSelf());
        }

        @Override
        public void accept(BSPTreeVisitor<P, N> visitor) {
            this.tree.accept(this.getSelf(), visitor);
        }

        @Override
        public N getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return this.cut == null;
        }

        @Override
        public boolean isInternal() {
            return this.cut != null;
        }

        @Override
        public boolean isPlus() {
            return this.parent != null && ((AbstractNode)this.parent).getPlus() == this;
        }

        @Override
        public boolean isMinus() {
            return this.parent != null && ((AbstractNode)this.parent).getMinus() == this;
        }

        @Override
        public HyperplaneConvexSubset<P> getCut() {
            return this.cut;
        }

        @Override
        public Hyperplane<P> getCutHyperplane() {
            return this.cut != null ? this.cut.getHyperplane() : null;
        }

        @Override
        public N getPlus() {
            return this.plus;
        }

        @Override
        public N getMinus() {
            return this.minus;
        }

        @Override
        public HyperplaneConvexSubset<P> trim(HyperplaneConvexSubset<P> sub) {
            return ((AbstractBSPTree)this.getTree()).trimToNode(this.getSelf(), sub);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName()).append("[cut= ").append(this.getCut()).append(']');
            return sb.toString();
        }

        protected void setSubtree(HyperplaneConvexSubset<P> newCut, N newMinus, N newPlus) {
            int childDepth;
            this.cut = newCut;
            N self = this.getSelf();
            N minusNode = newMinus;
            N plusNode = newPlus;
            int n = childDepth = this.depth != -1 ? this.depth + 1 : -1;
            if (newMinus != null) {
                ((AbstractNode)minusNode).parent = self;
                ((AbstractNode)minusNode).depth = childDepth;
            }
            this.minus = newMinus;
            if (newPlus != null) {
                ((AbstractNode)plusNode).parent = self;
                ((AbstractNode)plusNode).depth = childDepth;
            }
            this.plus = newPlus;
        }

        protected void makeRoot() {
            this.parent = null;
            this.depth = 0;
        }

        protected void checkValid() {
            int treeVersion = this.tree.getVersion();
            if (this.nodeVersion != treeVersion) {
                this.nodeInvalidated();
                this.nodeVersion = treeVersion;
            }
        }

        protected void nodeInvalidated() {
            this.count = -1;
            this.height = -1;
        }

        protected abstract N getSelf();
    }

    @FunctionalInterface
    public static interface SubtreeInitializer<N extends AbstractNode<?, ?>> {
        public void initSubtree(N var1);
    }
}

