/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.partitioning;

import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneLocation;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;

public abstract class AbstractHyperplane<P extends Point<P>>
implements Hyperplane<P> {
    private final DoublePrecisionContext precision;

    protected AbstractHyperplane(DoublePrecisionContext precision) {
        this.precision = precision;
    }

    @Override
    public HyperplaneLocation classify(P point) {
        double offsetValue = this.offset(point);
        int cmp = this.precision.sign(offsetValue);
        if (cmp > 0) {
            return HyperplaneLocation.PLUS;
        }
        if (cmp < 0) {
            return HyperplaneLocation.MINUS;
        }
        return HyperplaneLocation.ON;
    }

    @Override
    public boolean contains(P point) {
        HyperplaneLocation loc = this.classify(point);
        return loc == HyperplaneLocation.ON;
    }

    public DoublePrecisionContext getPrecision() {
        return this.precision;
    }
}

