/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.internal;

import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public abstract class IteratorTransform<I, T>
implements Iterator<T> {
    private final Iterator<I> inputIterator;
    private final Deque<T> outputQueue = new LinkedList<T>();

    public IteratorTransform(Iterator<I> inputIterator) {
        this.inputIterator = inputIterator;
    }

    @Override
    public boolean hasNext() {
        return this.loadNextOutput();
    }

    @Override
    public T next() {
        if (this.outputQueue.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.outputQueue.removeFirst();
    }

    private boolean loadNextOutput() {
        while (this.outputQueue.isEmpty() && this.inputIterator.hasNext()) {
            this.acceptInput(this.inputIterator.next());
        }
        return !this.outputQueue.isEmpty();
    }

    protected void addOutput(T value) {
        this.outputQueue.add(value);
    }

    protected void addAllOutput(Collection<T> values) {
        this.outputQueue.addAll(values);
    }

    protected abstract void acceptInput(I var1);
}

