/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.jmh.euclidean;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.UnaryOperator;
import org.apache.commons.geometry.core.Vector;
import org.apache.commons.geometry.euclidean.oned.Vector1D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;
import org.apache.commons.rng.simple.RandomSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=1, jvmArgs={"-server", "-Xms512M", "-Xmx512M"})
public class VectorPerformance {
    private static final double[] EDGE_NUMBERS = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.MAX_VALUE, -1.7976931348623157E308, Double.MIN_VALUE, -4.9E-324, 0.0, -0.0, Double.NaN};
    private static final String RANDOM = "random";
    private static final String NORMALIZABLE = "normalizable";
    private static final String EDGE = "edge";

    private static double createRandomDouble(UniformRandomProvider rng) {
        long mask = -9218868437227405313L;
        long bits = rng.nextLong() & 0x800FFFFFFFFFFFFFL;
        long exp = rng.nextInt(129) - 64 + 1023;
        return Double.longBitsToDouble(bits | exp << 52);
    }

    private static <V extends Vector<V>> void testToDouble(VectorInputBase<V> input, Blackhole bh, ToDoubleFunction<V> fn) {
        for (Vector vec : input.getVectors()) {
            bh.consume(fn.applyAsDouble(vec));
        }
    }

    private static <V extends Vector<V>> void testUnary(VectorInputBase<V> input, Blackhole bh, UnaryOperator<V> fn) {
        for (Vector vec : input.getVectors()) {
            bh.consume(fn.apply(vec));
        }
    }

    @Benchmark
    public void baseline(VectorInput1D input, Blackhole bh) {
        VectorPerformance.testUnary(input, bh, UnaryOperator.identity());
    }

    @Benchmark
    public void norm1D(VectorInput1D input, Blackhole bh) {
        VectorPerformance.testToDouble(input, bh, Vector1D::norm);
    }

    @Benchmark
    public void norm2D(VectorInput2D input, Blackhole bh) {
        VectorPerformance.testToDouble(input, bh, Vector2D::norm);
    }

    @Benchmark
    public void norm3D(VectorInput3D input, Blackhole bh) {
        VectorPerformance.testToDouble(input, bh, Vector3D::norm);
    }

    @Benchmark
    public void normalize1D(NormalizableVectorInput1D input, Blackhole bh) {
        VectorPerformance.testUnary(input, bh, Vector1D::normalize);
    }

    @Benchmark
    public void normalize2D(NormalizableVectorInput2D input, Blackhole bh) {
        VectorPerformance.testUnary(input, bh, Vector2D::normalize);
    }

    @Benchmark
    public void normalize3D(NormalizableVectorInput3D input, Blackhole bh) {
        VectorPerformance.testUnary(input, bh, Vector3D::normalize);
    }

    @State(value=Scope.Thread)
    public static class NormalizableVectorInput3D
    extends VectorInputBase<Vector3D> {
        public NormalizableVectorInput3D() {
            super(3, Vector3D::of);
        }

        @Override
        public String getType() {
            return VectorPerformance.NORMALIZABLE;
        }
    }

    @State(value=Scope.Thread)
    public static class VectorInput3D
    extends VectorInputBase<Vector3D> {
        @Param(value={"random", "edge"})
        private String type;

        public VectorInput3D() {
            super(3, Vector3D::of);
        }

        @Override
        public String getType() {
            return this.type;
        }
    }

    @State(value=Scope.Thread)
    public static class NormalizableVectorInput2D
    extends VectorInputBase<Vector2D> {
        public NormalizableVectorInput2D() {
            super(2, Vector2D::of);
        }

        @Override
        public String getType() {
            return VectorPerformance.NORMALIZABLE;
        }
    }

    @State(value=Scope.Thread)
    public static class VectorInput2D
    extends VectorInputBase<Vector2D> {
        @Param(value={"random", "edge"})
        private String type;

        public VectorInput2D() {
            super(2, Vector2D::of);
        }

        @Override
        public String getType() {
            return this.type;
        }
    }

    @State(value=Scope.Thread)
    public static class NormalizableVectorInput1D
    extends VectorInputBase<Vector1D> {
        public NormalizableVectorInput1D() {
            super(1, arr -> Vector1D.of((double)arr[0]));
        }

        @Override
        public String getType() {
            return VectorPerformance.NORMALIZABLE;
        }
    }

    @State(value=Scope.Thread)
    public static class VectorInput1D
    extends VectorInputBase<Vector1D> {
        @Param(value={"random", "edge"})
        private String type;

        public VectorInput1D() {
            super(1, arr -> Vector1D.of((double)arr[0]));
        }

        @Override
        public String getType() {
            return this.type;
        }
    }

    @State(value=Scope.Thread)
    public static abstract class VectorInputBase<V extends Vector<V>> {
        private final int dimension;
        private final Function<double[], V> vectorFactory;
        @Param(value={"100", "10000"})
        private int size;
        private List<V> vectors;

        VectorInputBase(int dimension, Function<double[], V> vectorFactory) {
            this.dimension = dimension;
            this.vectorFactory = vectorFactory;
        }

        @Setup(value=Level.Iteration)
        public void setup() {
            this.vectors = new ArrayList<V>(this.size);
            double[] values = new double[this.dimension];
            DoubleSupplier doubleSupplier = this.createDoubleSupplier(this.getType(), (UniformRandomProvider)RandomSource.create((RandomSource)RandomSource.XO_RO_SHI_RO_128_PP));
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.dimension; ++j) {
                    values[j] = doubleSupplier.getAsDouble();
                }
                this.vectors.add(this.vectorFactory.apply(values));
            }
        }

        public List<V> getVectors() {
            return this.vectors;
        }

        public abstract String getType();

        private DoubleSupplier createDoubleSupplier(String type, UniformRandomProvider rng) {
            switch (type) {
                case "random": {
                    return () -> VectorPerformance.createRandomDouble(rng);
                }
                case "normalizable": {
                    ZigguratNormalizedGaussianSampler sampler = (ZigguratNormalizedGaussianSampler)ZigguratNormalizedGaussianSampler.of((UniformRandomProvider)rng);
                    return () -> {
                        double n = sampler.sample();
                        return n == 0.0 ? 0.1 : n;
                    };
                }
                case "edge": {
                    return () -> EDGE_NUMBERS[rng.nextInt(EDGE_NUMBERS.length)];
                }
            }
            throw new IllegalStateException("Invalid input type: " + type);
        }
    }
}

