/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.jmh.euclidean;

import java.util.concurrent.TimeUnit;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.core.precision.EpsilonDoublePrecisionContext;
import org.apache.commons.geometry.euclidean.threed.RegionBSPTree3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.shape.Sphere;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=1, jvmArgs={"-server", "-Xms512M", "-Xmx512M"})
public class SpherePerformance {
    private static final double EPS = 1.0E-10;
    private static final double MIN_VALUE = 0.1;
    private static final double MAX_VALUE = 100.0;

    private static Sphere randomSphere(UniformRandomProvider rand) {
        Vector3D center = Vector3D.of((double)SpherePerformance.nextDouble(rand), (double)SpherePerformance.nextDouble(rand), (double)SpherePerformance.nextDouble(rand));
        double radius = SpherePerformance.nextDouble(rand);
        return Sphere.from((Vector3D)center, (double)radius, (DoublePrecisionContext)new EpsilonDoublePrecisionContext(1.0E-10));
    }

    private static double nextDouble(UniformRandomProvider rand) {
        return rand.nextDouble() * 99.9 + 0.1;
    }

    @Benchmark
    public RegionBSPTree3D toTreeCreation(RandomSphere randomSphere, ToTreeInput toTreeInput) {
        Sphere sphere = randomSphere.getSphere();
        int subdivisions = toTreeInput.getSubdivisions();
        return sphere.toTree(subdivisions);
    }

    @Benchmark
    public double toTreeSize(ToTreeInstance toTreeInstance) {
        RegionBSPTree3D tree = toTreeInstance.getTree();
        return tree.getSize();
    }

    @State(value=Scope.Thread)
    public static class ToTreeInstance
    extends ToTreeInput {
        private RegionBSPTree3D tree;

        @Setup(value=Level.Iteration)
        public void setup() {
            Sphere sphere = SpherePerformance.randomSphere((UniformRandomProvider)RandomSource.create((RandomSource)RandomSource.XO_RO_SHI_RO_128_PP));
            this.tree = sphere.toTree(this.getSubdivisions());
        }

        public RegionBSPTree3D getTree() {
            return this.tree;
        }
    }

    @State(value=Scope.Thread)
    public static class ToTreeInput {
        @Param(value={"3", "4", "5"})
        private int subdivisions;

        public int getSubdivisions() {
            return this.subdivisions;
        }
    }

    @State(value=Scope.Thread)
    public static class RandomSphere {
        private Sphere sphere;

        @Setup(value=Level.Iteration)
        public void setup() {
            this.sphere = SpherePerformance.randomSphere((UniformRandomProvider)RandomSource.create((RandomSource)RandomSource.XO_RO_SHI_RO_128_PP));
        }

        public Sphere getSphere() {
            return this.sphere;
        }
    }
}

