/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.jmh.euclidean;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.core.precision.EpsilonDoublePrecisionContext;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.RegionBSPTree3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.shape.Sphere;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=1, jvmArgs={"-server", "-Xms512M", "-Xmx512M"})
public class RegionBSPTree3DPerformance {
    @Benchmark
    public RegionBSPTree3D insertConvexWorstCase(SphericalBoundaryInput input) {
        RegionBSPTree3D tree = RegionBSPTree3D.empty();
        for (PlaneConvexSubset boundary : input.getBoundaries()) {
            tree.insert((HyperplaneConvexSubset)boundary);
        }
        return tree;
    }

    @Benchmark
    public List<PlaneConvexSubset> boundaryConvexWorstCase(WorstCaseSphericalRegionInput input) {
        return input.getTree().getBoundaries();
    }

    @State(value=Scope.Thread)
    public static class WorstCaseSphericalRegionInput
    extends SphericalBoundaryInputBase {
        private RegionBSPTree3D tree;

        @Setup(value=Level.Iteration)
        public void setup() {
            this.tree = RegionBSPTree3D.empty();
            this.tree.insert(this.computeBoundaries());
        }

        public RegionBSPTree3D getTree() {
            return this.tree;
        }
    }

    @State(value=Scope.Thread)
    public static class SphericalBoundaryInput
    extends SphericalBoundaryInputBase {
        private List<PlaneConvexSubset> boundaries;

        @Setup(value=Level.Iteration)
        public void setup() {
            this.boundaries = this.computeBoundaries();
        }

        public List<PlaneConvexSubset> getBoundaries() {
            return this.boundaries;
        }
    }

    @State(value=Scope.Thread)
    public static class SphericalBoundaryInputBase {
        @Param(value={"2", "3", "4"})
        private int subdivisions;

        protected List<PlaneConvexSubset> computeBoundaries() {
            Sphere sphere = Sphere.from((Vector3D)Vector3D.ZERO, (double)1.0, (DoublePrecisionContext)new EpsilonDoublePrecisionContext(1.0E-10));
            return sphere.toTree(this.subdivisions).getBoundaries();
        }
    }
}

