/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.jmh.euclidean;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.core.precision.EpsilonDoublePrecisionContext;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.RegionBSPTree2D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.euclidean.twod.shape.Circle;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=1, jvmArgs={"-server", "-Xms512M", "-Xmx512M"})
public class RegionBSPTree2DPerformance {
    @Benchmark
    public RegionBSPTree2D insertConvexWorstCase(CircularBoundaryInput input) {
        RegionBSPTree2D tree = RegionBSPTree2D.empty();
        for (LineConvexSubset boundary : input.getBoundaries()) {
            tree.insert((HyperplaneConvexSubset)boundary);
        }
        return tree;
    }

    @Benchmark
    public List<LineConvexSubset> boundaryConvexWorstCase(WorstCaseCircularRegionInput input) {
        return input.getTree().getBoundaries();
    }

    @State(value=Scope.Thread)
    public static class WorstCaseCircularRegionInput
    extends CircularBoundaryInputBase {
        private RegionBSPTree2D tree;

        @Setup(value=Level.Iteration)
        public void setup() {
            this.tree = RegionBSPTree2D.empty();
            this.tree.insert(this.computeBoundaries());
        }

        public RegionBSPTree2D getTree() {
            return this.tree;
        }
    }

    @State(value=Scope.Thread)
    public static class CircularBoundaryInput
    extends CircularBoundaryInputBase {
        private List<LineConvexSubset> boundaries;

        @Setup(value=Level.Iteration)
        public void setup() {
            this.boundaries = this.computeBoundaries();
        }

        public List<LineConvexSubset> getBoundaries() {
            return this.boundaries;
        }
    }

    @State(value=Scope.Thread)
    public static class CircularBoundaryInputBase {
        @Param(value={"10", "20", "50"})
        private int segments;

        protected List<LineConvexSubset> computeBoundaries() {
            Circle circle = Circle.from((Vector2D)Vector2D.ZERO, (double)1.0, (DoublePrecisionContext)new EpsilonDoublePrecisionContext(1.0E-10));
            return circle.toTree(this.segments).getBoundaries();
        }
    }
}

