/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.jmh.euclidean;

import java.util.concurrent.TimeUnit;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.core.precision.EpsilonDoublePrecisionContext;
import org.apache.commons.geometry.euclidean.twod.RegionBSPTree2D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.euclidean.twod.shape.Circle;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Fork(value=1, jvmArgs={"-server", "-Xms512M", "-Xmx512M"})
public class CirclePerformance {
    private static final double EPS = 1.0E-10;
    private static final double MIN_VALUE = 0.1;
    private static final double MAX_VALUE = 1.0E-100;

    private static Circle randomCircle(UniformRandomProvider rand) {
        Vector2D center = Vector2D.of((double)CirclePerformance.nextDouble(rand), (double)CirclePerformance.nextDouble(rand));
        double radius = CirclePerformance.nextDouble(rand);
        return Circle.from((Vector2D)center, (double)radius, (DoublePrecisionContext)new EpsilonDoublePrecisionContext(1.0E-10));
    }

    private static double nextDouble(UniformRandomProvider rand) {
        return rand.nextDouble() * -0.1 + 0.1;
    }

    @Benchmark
    public RegionBSPTree2D toTreeCreation(RandomCircle randomCircle, ToTreeInput toTreeInput) {
        Circle circle = randomCircle.getCircle();
        int segments = toTreeInput.getSegments();
        return circle.toTree(segments);
    }

    @Benchmark
    public double toTreeSize(ToTreeInstance toTreeInstance) {
        RegionBSPTree2D tree = toTreeInstance.getTree();
        return tree.getSize();
    }

    @State(value=Scope.Thread)
    public static class ToTreeInstance
    extends ToTreeInput {
        private RegionBSPTree2D tree;

        @Setup(value=Level.Iteration)
        public void setup() {
            Circle circle = CirclePerformance.randomCircle((UniformRandomProvider)RandomSource.create((RandomSource)RandomSource.XO_RO_SHI_RO_128_PP));
            this.tree = circle.toTree(this.getSegments());
        }

        public RegionBSPTree2D getTree() {
            return this.tree;
        }
    }

    @State(value=Scope.Thread)
    public static class ToTreeInput {
        @Param(value={"10", "100", "1000"})
        private int segments;

        public int getSegments() {
            return this.segments;
        }
    }

    @State(value=Scope.Thread)
    public static class RandomCircle {
        private Circle circle;

        @Setup(value=Level.Iteration)
        public void setup() {
            this.circle = CirclePerformance.randomCircle((UniformRandomProvider)RandomSource.create((RandomSource)RandomSource.XO_RO_SHI_RO_128_PP));
        }

        public Circle getCircle() {
            return this.circle;
        }
    }
}

