/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.tutorials.bsp;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.geometry.core.partitioning.BoundarySource;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.bsp.RegionCutRule;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.core.precision.EpsilonDoublePrecisionContext;
import org.apache.commons.geometry.euclidean.twod.Bounds2D;
import org.apache.commons.geometry.euclidean.twod.Lines;
import org.apache.commons.geometry.euclidean.twod.RegionBSPTree2D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.euclidean.twod.path.LinePath;
import org.apache.commons.geometry.examples.tutorials.bsp.BSPTreeSVGWriter;

public final class HexagonStructuralCut {
    private HexagonStructuralCut() {
    }

    public static void main(String[] args) {
        File outputFolder = new File(args.length > 0 ? args[0] : ".");
        BSPTreeSVGWriter svgWriter = new BSPTreeSVGWriter(Bounds2D.from((Vector2D)Vector2D.of((double)-8.0, (double)-8.0), (Vector2D[])new Vector2D[]{Vector2D.of((double)8.0, (double)8.0)}));
        EpsilonDoublePrecisionContext precision = new EpsilonDoublePrecisionContext(1.0E-6);
        RegionBSPTree2D tree = RegionBSPTree2D.empty();
        tree.insert((HyperplaneConvexSubset)Lines.fromPointAndDirection((Vector2D)Vector2D.ZERO, (Vector2D)Vector2D.Unit.PLUS_X, (DoublePrecisionContext)precision).span(), RegionCutRule.INHERIT);
        svgWriter.write(tree, new File(outputFolder, "hex-struct-0.svg"));
        LinePath path = LinePath.fromVertexLoop(Arrays.asList(Vector2D.of((double)-4.0, (double)0.0), Vector2D.of((double)-2.0, (double)-3.0), Vector2D.of((double)2.0, (double)-3.0), Vector2D.of((double)4.0, (double)0.0), Vector2D.of((double)2.0, (double)3.0), Vector2D.of((double)-2.0, (double)3.0)), (DoublePrecisionContext)precision);
        tree.insert((BoundarySource)path);
        svgWriter.write(tree, new File(outputFolder, "hex-struct-1.svg"));
    }
}

