/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.tutorials.bsp;

import java.io.File;
import java.util.HashMap;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.core.precision.EpsilonDoublePrecisionContext;
import org.apache.commons.geometry.euclidean.twod.Bounds2D;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.Lines;
import org.apache.commons.geometry.euclidean.twod.RegionBSPTree2D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.examples.tutorials.bsp.BSPTreeSVGWriter;

public final class BottomUpBSPTreeConstruction {
    private static final String OUTPUT_FILE_FORMAT = "bu-cut-%d.svg";

    private BottomUpBSPTreeConstruction() {
    }

    public static void main(String[] args) {
        File outputFolder = new File(args.length > 0 ? args[0] : ".");
        BSPTreeSVGWriter svgWriter = new BSPTreeSVGWriter(Bounds2D.from((Vector2D)Vector2D.of((double)-8.0, (double)-8.0), (Vector2D[])new Vector2D[]{Vector2D.of((double)8.0, (double)8.0)}));
        HashMap<RegionBSPTree2D.RegionNode2D, String> nodeNames = new HashMap<RegionBSPTree2D.RegionNode2D, String>();
        int cutCount = -1;
        EpsilonDoublePrecisionContext precision = new EpsilonDoublePrecisionContext(1.0E-6);
        RegionBSPTree2D tree = RegionBSPTree2D.empty();
        Line rootCut = Lines.fromPointAndDirection((Vector2D)Vector2D.ZERO, (Vector2D)Vector2D.Unit.PLUS_X, (DoublePrecisionContext)precision);
        RegionBSPTree2D.RegionNode2D a = (RegionBSPTree2D.RegionNode2D)tree.getRoot();
        nodeNames.put(a, "a");
        svgWriter.write(tree, nodeNames, new File(outputFolder, String.format(OUTPUT_FILE_FORMAT, ++cutCount)));
        a.cut((Hyperplane)rootCut);
        RegionBSPTree2D.RegionNode2D b = (RegionBSPTree2D.RegionNode2D)a.getMinus();
        RegionBSPTree2D.RegionNode2D c = (RegionBSPTree2D.RegionNode2D)a.getPlus();
        nodeNames.put(b, "b");
        nodeNames.put(c, "c");
        svgWriter.write(tree, nodeNames, new File(outputFolder, String.format(OUTPUT_FILE_FORMAT, ++cutCount)));
        b.insertCut((Hyperplane)Lines.fromPoints((Vector2D)Vector2D.of((double)1.0, (double)0.0), (Vector2D)Vector2D.of((double)-1.0, (double)1.0), (DoublePrecisionContext)precision));
        RegionBSPTree2D.RegionNode2D d = (RegionBSPTree2D.RegionNode2D)b.getMinus();
        RegionBSPTree2D.RegionNode2D e = (RegionBSPTree2D.RegionNode2D)b.getPlus();
        nodeNames.put(d, "d");
        nodeNames.put(e, "e");
        svgWriter.write(tree, nodeNames, new File(outputFolder, String.format(OUTPUT_FILE_FORMAT, ++cutCount)));
        d.insertCut((Hyperplane)Lines.fromPointAndDirection((Vector2D)Vector2D.of((double)-5.0, (double)1.0), (Vector2D)Vector2D.Unit.MINUS_Y, (DoublePrecisionContext)precision));
        RegionBSPTree2D.RegionNode2D f = (RegionBSPTree2D.RegionNode2D)d.getMinus();
        RegionBSPTree2D.RegionNode2D g = (RegionBSPTree2D.RegionNode2D)d.getPlus();
        nodeNames.put(f, "f");
        nodeNames.put(g, "g");
        svgWriter.write(tree, nodeNames, new File(outputFolder, String.format(OUTPUT_FILE_FORMAT, ++cutCount)));
        c.insertCut((Hyperplane)Lines.fromPoints((Vector2D)Vector2D.of((double)-1.0, (double)0.0), (Vector2D)Vector2D.of((double)1.0, (double)-1.0), (DoublePrecisionContext)precision));
        RegionBSPTree2D.RegionNode2D h = (RegionBSPTree2D.RegionNode2D)c.getMinus();
        RegionBSPTree2D.RegionNode2D i = (RegionBSPTree2D.RegionNode2D)c.getPlus();
        nodeNames.put(h, "h");
        nodeNames.put(i, "i");
        svgWriter.write(tree, nodeNames, new File(outputFolder, String.format(OUTPUT_FILE_FORMAT, ++cutCount)));
        h.insertCut((Hyperplane)Lines.fromPointAndDirection((Vector2D)Vector2D.of((double)5.0, (double)-1.0), (Vector2D)Vector2D.Unit.PLUS_Y, (DoublePrecisionContext)precision));
        RegionBSPTree2D.RegionNode2D j = (RegionBSPTree2D.RegionNode2D)h.getMinus();
        RegionBSPTree2D.RegionNode2D k = (RegionBSPTree2D.RegionNode2D)h.getPlus();
        nodeNames.put(j, "j");
        nodeNames.put(k, "k");
        svgWriter.write(tree, nodeNames, new File(outputFolder, String.format(OUTPUT_FILE_FORMAT, ++cutCount)));
    }
}

