/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.tutorials.bsp;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.AbstractRegionBSPTree;
import org.apache.commons.geometry.core.partitioning.bsp.BSPTreeVisitor;
import org.apache.commons.geometry.core.partitioning.bsp.RegionCutBoundary;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.core.precision.EpsilonDoublePrecisionContext;
import org.apache.commons.geometry.euclidean.twod.AffineTransformMatrix2D;
import org.apache.commons.geometry.euclidean.twod.Bounds2D;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.PolarCoordinates;
import org.apache.commons.geometry.euclidean.twod.RegionBSPTree2D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.euclidean.twod.path.LinePath;
import org.apache.commons.geometry.euclidean.twod.shape.Parallelogram;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BSPTreeSVGWriter {
    private static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private static final String SVG_VERSION = "1.1";
    private static final String INDENT_AMOUNT_KEY = "{http://xml.apache.org/xslt}indent-amount";
    private static final int INDENT_AMOUNT = 4;
    private static final String DEFAULT_NODE_NAMES = "abcdefghijklmnopqrstuvwxyz";
    private static final String GEOMETRY_AREA_CLIP_PATH_ID = "geometry-area";
    private static final char PATH_MOVE_TO = 'M';
    private static final char PATH_LINE_TO = 'L';
    private static final char SPACE = ' ';
    private static final String RECT_ELEMENT = "rect";
    private static final String PATH_ELEMENT = "path";
    private static final String CLASS_ATTR = "class";
    private static final String WIDTH_ATTR = "width";
    private static final String HEIGHT_ATTR = "height";
    private static final String X_ATTR = "x";
    private static final String Y_ATTR = "y";
    private static final String STYLE = "text { font-size: 14px; } .node-name { text-anchor: middle; font-family: \"Courier New\", Courier, monospace; } .geometry-border { fill: none; stroke: gray; stroke-width: 1; } .arrow { fill: none; stroke: blue; stroke-width: 1; } .cut { fill: none; stroke: blue; stroke-width: 1; stroke-dasharray: 5,3; } .region-boundary { stroke: orange; stroke-width: 2; } .inside { fill: #aaa; opacity: 0.2; } .tree-path { fill: none; stroke: gray; stroke-width: 1; } .inside-node { font-weight: bold; }";
    private final Bounds2D bounds;
    private int width = 750;
    private int height = 375;
    private int margin = 5;
    private double geometryAreaWidthFactor = 0.5;
    private double treeAreaWidthFactor = 1.0 - this.geometryAreaWidthFactor;
    private double arrowAngle = 2.5132741228718345;
    private double arrowLength = 8.0;
    private double treeVerticalSpacing = 45.0;
    private double treeLineMargin = 10.0;
    private double treeParentOffsetFactor = 0.25;
    private double treeParentXOffsetMin = 0.0;
    private DoublePrecisionContext precision = new EpsilonDoublePrecisionContext(1.0E-6);

    public BSPTreeSVGWriter(Bounds2D bounds) {
        this.bounds = bounds;
    }

    public void setTreeParentOffsetFactor(double treeParentOffsetFactor) {
        this.treeParentOffsetFactor = treeParentOffsetFactor;
    }

    public void setTreeParentXOffsetMin(double treeParentXOffsetMin) {
        this.treeParentXOffsetMin = treeParentXOffsetMin;
    }

    public void write(RegionBSPTree2D tree, File file) {
        LinkedList<AbstractBSPTree.AbstractNode> nodeQueue = new LinkedList<AbstractBSPTree.AbstractNode>();
        nodeQueue.add(tree.getRoot());
        HashMap<RegionBSPTree2D.RegionNode2D, String> nodeNames = new HashMap<RegionBSPTree2D.RegionNode2D, String>();
        String names = DEFAULT_NODE_NAMES;
        for (int i = 0; i < DEFAULT_NODE_NAMES.length() && !nodeQueue.isEmpty(); ++i) {
            RegionBSPTree2D.RegionNode2D node = (RegionBSPTree2D.RegionNode2D)nodeQueue.removeFirst();
            nodeNames.put(node, DEFAULT_NODE_NAMES.substring(i, i + 1));
            if (!node.isInternal()) continue;
            nodeQueue.add(node.getMinus());
            nodeQueue.add(node.getPlus());
        }
        this.write(tree, nodeNames, file);
    }

    public void write(RegionBSPTree2D tree, Map<RegionBSPTree2D.RegionNode2D, String> nodeNames, File file) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = BSPTreeSVGWriter.svgElement("svg", doc);
            doc.appendChild(root);
            root.setAttribute("version", SVG_VERSION);
            root.setAttribute(WIDTH_ATTR, String.valueOf(this.width));
            root.setAttribute(HEIGHT_ATTR, String.valueOf(this.height));
            Element defs = BSPTreeSVGWriter.svgElement("defs", doc);
            root.appendChild(defs);
            Element style = BSPTreeSVGWriter.svgElement("style", doc);
            root.appendChild(style);
            style.setTextContent(STYLE);
            this.writeTreeGeometryArea(tree, nodeNames, root, defs, doc);
            this.writeTreeStructureArea(tree, nodeNames, root, doc);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty(INDENT_AMOUNT_KEY, String.valueOf(4));
            DOMSource source = new DOMSource(doc);
            StreamResult target = new StreamResult(file);
            transformer.transform(source, target);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new RuntimeException("Failed to create SVG", e);
        }
    }

    private void writeTreeGeometryArea(RegionBSPTree2D tree, Map<RegionBSPTree2D.RegionNode2D, String> nodeNames, Element root, Element defs, Document doc) {
        double geometrySvgX = this.margin;
        double geometrySvgY = this.margin;
        double geometrySvgWidth = this.geometryAreaWidthFactor * (double)this.width - (double)(2 * this.margin);
        double geometrySvgHeight = this.height - 2 * this.margin;
        this.defineClipRect(GEOMETRY_AREA_CLIP_PATH_ID, geometrySvgX, geometrySvgY, geometrySvgWidth, geometrySvgHeight, defs, doc);
        Element geometryGroup = BSPTreeSVGWriter.svgElement("g", doc);
        root.appendChild(geometryGroup);
        geometryGroup.setAttribute(CLASS_ATTR, "geometry");
        geometryGroup.setAttribute("clip-path", "url(#geometry-area)");
        AffineTransformMatrix2D transform = BSPTreeSVGWriter.computeGeometryTransform(this.bounds, geometrySvgX, geometrySvgY, geometrySvgWidth, geometrySvgHeight);
        tree.accept((BSPTreeVisitor)new TreeGeometryVisitor(transform, nodeNames, geometryGroup, doc));
        Element border = BSPTreeSVGWriter.svgElement(RECT_ELEMENT, doc);
        border.setAttribute(CLASS_ATTR, "geometry-border");
        BSPTreeSVGWriter.floatAttr(border, X_ATTR, geometrySvgX);
        BSPTreeSVGWriter.floatAttr(border, Y_ATTR, geometrySvgY);
        BSPTreeSVGWriter.floatAttr(border, WIDTH_ATTR, geometrySvgWidth);
        BSPTreeSVGWriter.floatAttr(border, HEIGHT_ATTR, geometrySvgHeight);
        root.appendChild(border);
    }

    private void writeTreeStructureArea(RegionBSPTree2D tree, Map<RegionBSPTree2D.RegionNode2D, String> nodeNames, Element root, Document doc) {
        Element treeGroup = BSPTreeSVGWriter.svgElement("g", doc);
        root.appendChild(treeGroup);
        treeGroup.setAttribute(CLASS_ATTR, "tree");
        double offsetX = (1.0 - this.treeAreaWidthFactor) * (double)this.width + (double)this.margin;
        double offsetY = this.margin;
        double svgWidth = this.treeAreaWidthFactor * (double)this.width - (double)(2 * this.margin);
        double svgHeight = this.height - 2 * this.margin;
        treeGroup.setAttribute("transform", "translate(" + offsetX + " " + offsetY + ")");
        tree.accept((BSPTreeVisitor)new TreeStructureVisitor(tree.height(), svgWidth, svgHeight, nodeNames, treeGroup, doc));
    }

    private static AffineTransformMatrix2D computeGeometryTransform(Bounds2D bounds, double svgX, double svgY, double svgWidth, double svgHeight) {
        Vector2D boundsDiagonal = (Vector2D)bounds.getDiagonal();
        return AffineTransformMatrix2D.createTranslation((Vector2D)((Vector2D)bounds.getMin()).negate()).scale(svgWidth / boundsDiagonal.getX(), -svgHeight / boundsDiagonal.getY()).translate(svgX, svgY + svgHeight);
    }

    private void defineClipRect(String id, double x, double y, double svgWidth, double svgHeight, Element defs, Document doc) {
        Element clipPath = BSPTreeSVGWriter.svgElement("clipPath", doc);
        clipPath.setAttribute("id", id);
        defs.appendChild(clipPath);
        Element rect = BSPTreeSVGWriter.svgElement(RECT_ELEMENT, doc);
        BSPTreeSVGWriter.floatAttr(rect, X_ATTR, x);
        BSPTreeSVGWriter.floatAttr(rect, Y_ATTR, y);
        BSPTreeSVGWriter.floatAttr(rect, WIDTH_ATTR, svgWidth);
        BSPTreeSVGWriter.floatAttr(rect, HEIGHT_ATTR, svgHeight);
        clipPath.appendChild(rect);
    }

    private static void floatAttr(Element element, String name, double value) {
        element.setAttribute(name, String.valueOf(value));
    }

    private static Element svgElement(String name, Document doc) {
        return doc.createElementNS(SVG_NAMESPACE, name);
    }

    private final class TreeStructureVisitor
    extends AbstractSVGTreeVisitor {
        private final double svgTop;
        private final double svgWidth;
        private final Map<RegionBSPTree2D.RegionNode2D, Vector2D> nodeLocations;

        TreeStructureVisitor(int treeNodeHeight, double svgWidth, double svgHeight, Map<RegionBSPTree2D.RegionNode2D, String> nodeNames, Element parent, Document doc) {
            super(nodeNames, parent, doc);
            this.nodeLocations = new HashMap<RegionBSPTree2D.RegionNode2D, Vector2D>();
            double requiredSvgHeight = (double)treeNodeHeight * BSPTreeSVGWriter.this.treeVerticalSpacing;
            double svgMid = 0.5 * svgHeight;
            this.svgTop = svgMid - 0.5 * requiredSvgHeight;
            this.svgWidth = svgWidth;
        }

        @Override
        protected void visitNode(String name, RegionBSPTree2D.RegionNode2D node) {
            Vector2D loc = this.getNodeLocation(node);
            this.nodeLocations.put(node, loc);
            Element nodeGroup = this.createChild("g");
            nodeGroup.setAttribute(BSPTreeSVGWriter.CLASS_ATTR, this.getNodeClassNames(name, node));
            nodeGroup.appendChild(this.createNodeNameElement(name, loc));
            Vector2D parentLoc = this.nodeLocations.get(node.getParent());
            if (parentLoc != null) {
                Vector2D offset = loc.vectorTo(parentLoc).withNorm(BSPTreeSVGWriter.this.treeLineMargin);
                nodeGroup.appendChild(this.createPathElement("tree-path", loc.add(offset), parentLoc.subtract(offset)));
            }
        }

        private String getNodeClassNames(String name, RegionBSPTree2D.RegionNode2D node) {
            StringBuilder sb = new StringBuilder();
            sb.append("node-" + name);
            if (node.isLeaf()) {
                sb.append(' ').append(node.isInside() ? "inside-node" : "outside-node");
            }
            return sb.toString();
        }

        private Vector2D getNodeLocation(RegionBSPTree2D.RegionNode2D node) {
            RegionBSPTree2D.RegionNode2D parent = (RegionBSPTree2D.RegionNode2D)node.getParent();
            Vector2D parentLoc = this.nodeLocations.get(parent);
            if (parentLoc == null) {
                return Vector2D.of((double)(0.5 * this.svgWidth), (double)this.svgTop);
            }
            double parentXOffset = Math.max(BSPTreeSVGWriter.this.treeParentOffsetFactor * (this.svgWidth / (double)(1 << parent.depth())), BSPTreeSVGWriter.this.treeParentXOffsetMin);
            if (node.isMinus()) {
                parentXOffset = -parentXOffset;
            }
            return Vector2D.of((double)(parentLoc.getX() + parentXOffset), (double)(parentLoc.getY() + BSPTreeSVGWriter.this.treeVerticalSpacing));
        }
    }

    private final class TreeGeometryVisitor
    extends AbstractSVGTreeVisitor {
        private final Parallelogram boundsRegion;
        private final AffineTransformMatrix2D transform;
        private final Element pathGroup;
        private final Element labelGroup;

        TreeGeometryVisitor(AffineTransformMatrix2D transform, Map<RegionBSPTree2D.RegionNode2D, String> nodeNames, Element parent, Document doc) {
            super(nodeNames, parent, doc);
            this.boundsRegion = BSPTreeSVGWriter.this.bounds.toRegion(BSPTreeSVGWriter.this.precision);
            this.transform = transform;
            this.pathGroup = BSPTreeSVGWriter.svgElement("g", doc);
            this.pathGroup.setAttribute(BSPTreeSVGWriter.CLASS_ATTR, "paths");
            parent.appendChild(this.pathGroup);
            this.labelGroup = BSPTreeSVGWriter.svgElement("g", doc);
            this.labelGroup.setAttribute(BSPTreeSVGWriter.CLASS_ATTR, "labels");
            parent.appendChild(this.labelGroup);
        }

        @Override
        protected void visitNode(String name, RegionBSPTree2D.RegionNode2D node) {
            if (node.isLeaf()) {
                this.visitLeafNode(name, node);
            } else {
                this.visitInternalNode(name, node);
            }
        }

        private void visitLeafNode(String name, RegionBSPTree2D.RegionNode2D node) {
            RegionBSPTree2D tree = node.getNodeRegion().toTree();
            tree.intersection((AbstractRegionBSPTree)this.boundsRegion.toTree());
            Vector2D svgCentroid = this.toSvgSpace((Vector2D)tree.getCentroid());
            this.labelGroup.appendChild(this.createNodeNameElement(name, svgCentroid));
            if (node.isInside()) {
                for (LinePath linePath : tree.getBoundaryPaths()) {
                    Element path = this.createElement(BSPTreeSVGWriter.PATH_ELEMENT);
                    this.pathGroup.appendChild(path);
                    path.setAttribute(BSPTreeSVGWriter.CLASS_ATTR, "inside");
                    StringBuilder sb = new StringBuilder();
                    for (Vector2D pt : linePath.getVertexSequence()) {
                        if (sb.length() < 1) {
                            sb.append('M');
                        } else {
                            sb.append(' ').append('L');
                        }
                        sb.append(this.pointString(this.toSvgSpace(pt)));
                    }
                    path.setAttribute("d", sb.toString());
                }
            }
        }

        private void visitInternalNode(String name, RegionBSPTree2D.RegionNode2D node) {
            RegionCutBoundary boundary;
            LineConvexSubset trimmedCut = this.boundsRegion.trim(node.getCut());
            Vector2D svgStart = this.toSvgSpace(trimmedCut.getStartPoint());
            Vector2D svgEnd = this.toSvgSpace(trimmedCut.getEndPoint());
            Vector2D svgMid = svgStart.lerp(svgEnd, 0.5);
            this.labelGroup.appendChild(this.createNodeNameElement(name, svgMid));
            this.pathGroup.appendChild(this.createPathElement("cut", svgStart, svgEnd));
            String arrowPathString = this.createCutArrowPathString(svgStart, svgEnd);
            if (arrowPathString != null) {
                Element arrowPath = this.createElement(BSPTreeSVGWriter.PATH_ELEMENT);
                this.pathGroup.appendChild(arrowPath);
                arrowPath.setAttribute(BSPTreeSVGWriter.CLASS_ATTR, "arrow");
                arrowPath.setAttribute("d", arrowPathString);
            }
            if ((boundary = node.getCutBoundary()) != null) {
                this.addRegionBoundaries(boundary.getInsideFacing());
                this.addRegionBoundaries(boundary.getOutsideFacing());
            }
        }

        private void addRegionBoundaries(List<HyperplaneConvexSubset<Vector2D>> boundaries) {
            for (HyperplaneConvexSubset<Vector2D> boundary : boundaries) {
                LineConvexSubset trimmed = this.boundsRegion.trim(boundary);
                if (trimmed == null) continue;
                this.pathGroup.appendChild(this.createPathElement("region-boundary", this.toSvgSpace(trimmed.getStartPoint()), this.toSvgSpace(trimmed.getEndPoint())));
            }
        }

        private String createCutArrowPathString(Vector2D svgStart, Vector2D svgEnd) {
            Vector2D dir = svgStart.vectorTo(svgEnd);
            if (!dir.eq(Vector2D.ZERO, BSPTreeSVGWriter.this.precision)) {
                double az = Math.atan2(dir.getY(), dir.getX());
                Vector2D upperArrowPt = PolarCoordinates.toCartesian((double)BSPTreeSVGWriter.this.arrowLength, (double)(az + BSPTreeSVGWriter.this.arrowAngle)).add(svgEnd);
                Vector2D lowerArrowPt = PolarCoordinates.toCartesian((double)BSPTreeSVGWriter.this.arrowLength, (double)(az - BSPTreeSVGWriter.this.arrowAngle)).add(svgEnd);
                StringBuilder sb = new StringBuilder();
                sb.append('M').append(this.pointString(upperArrowPt)).append(' ').append('L').append(this.pointString(svgEnd)).append(' ').append('L').append(this.pointString(lowerArrowPt));
                return sb.toString();
            }
            return null;
        }

        private Vector2D toSvgSpace(Vector2D pt) {
            return this.transform.apply(pt);
        }
    }

    private abstract class AbstractSVGTreeVisitor
    implements BSPTreeVisitor<Vector2D, RegionBSPTree2D.RegionNode2D> {
        private final Map<RegionBSPTree2D.RegionNode2D, String> nodeNames;
        private final Element parent;
        private final Document doc;
        private int count = 0;

        AbstractSVGTreeVisitor(Map<RegionBSPTree2D.RegionNode2D, String> nodeNames, Element parent, Document doc) {
            this.nodeNames = nodeNames;
            this.parent = parent;
            this.doc = doc;
        }

        public BSPTreeVisitor.Order visitOrder(RegionBSPTree2D.RegionNode2D internalNode) {
            return BSPTreeVisitor.Order.NODE_MINUS_PLUS;
        }

        public BSPTreeVisitor.Result visit(RegionBSPTree2D.RegionNode2D node) {
            ++this.count;
            String name = this.nodeNames != null && this.nodeNames.containsKey(node) ? this.nodeNames.get(node) : String.valueOf(this.count);
            this.visitNode(name, node);
            return BSPTreeVisitor.Result.CONTINUE;
        }

        protected Element createChild(String name) {
            Element child = this.createElement(name);
            this.parent.appendChild(child);
            return child;
        }

        protected Element createElement(String name) {
            return BSPTreeSVGWriter.svgElement(name, this.doc);
        }

        protected Element createNodeNameElement(String name, Vector2D svgPt) {
            Element text = this.createElement("text");
            text.setAttribute(BSPTreeSVGWriter.CLASS_ATTR, "node-name");
            text.setAttribute("dominant-baseline", "middle");
            BSPTreeSVGWriter.floatAttr(text, BSPTreeSVGWriter.X_ATTR, svgPt.getX());
            BSPTreeSVGWriter.floatAttr(text, BSPTreeSVGWriter.Y_ATTR, svgPt.getY());
            text.setTextContent(name);
            return text;
        }

        protected Element createPathElement(String className, Vector2D svgStart, Vector2D svgEnd) {
            Element path = this.createElement(BSPTreeSVGWriter.PATH_ELEMENT);
            path.setAttribute(BSPTreeSVGWriter.CLASS_ATTR, className);
            StringBuilder pathStr = new StringBuilder();
            pathStr.append('M').append(this.pointString(svgStart)).append(' ').append('L').append(this.pointString(svgEnd));
            path.setAttribute("d", pathStr.toString());
            return path;
        }

        protected String pointString(Vector2D pt) {
            return pt.getX() + " " + pt.getY();
        }

        protected abstract void visitNode(String var1, RegionBSPTree2D.RegionNode2D var2);
    }
}

