/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.io.threed.obj;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.mesh.Mesh;
import org.apache.commons.geometry.examples.io.threed.obj.OBJConstants;

public final class OBJWriter
implements AutoCloseable {
    private static final char SPACE = ' ';
    private static final int DEFAULT_MAXIMUM_FRACTION_DIGITS = 6;
    private static final String DEFAULT_LINE_SEPARATOR = "\n";
    private Writer writer;
    private String lineSeparator = "\n";
    private DecimalFormat decimalFormat;
    private int vertexCount = 0;

    public OBJWriter(File file) throws IOException {
        this(Files.newBufferedWriter(file.toPath(), OBJConstants.DEFAULT_CHARSET, new OpenOption[0]));
    }

    public OBJWriter(Writer writer) {
        this.writer = writer;
        this.decimalFormat = new DecimalFormat();
        this.decimalFormat.setMaximumFractionDigits(6);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public void writeComment(String comment) throws IOException {
        for (String line : comment.split("\r?\n")) {
            this.writer.write(35);
            this.writer.write(32);
            this.writer.write(line);
            this.writer.write(this.lineSeparator);
        }
    }

    public void writeObjectName(String objectName) throws IOException {
        this.writer.write("o");
        this.writer.write(32);
        this.writer.write(objectName);
        this.writer.write(this.lineSeparator);
    }

    public void writeGroupName(String groupName) throws IOException {
        this.writer.write("g");
        this.writer.write(32);
        this.writer.write(groupName);
        this.writer.write(this.lineSeparator);
    }

    public int writeVertex(Vector3D vertex) throws IOException {
        this.writer.write("v");
        this.writer.write(32);
        this.writer.write(this.decimalFormat.format(vertex.getX()));
        this.writer.write(32);
        this.writer.write(this.decimalFormat.format(vertex.getY()));
        this.writer.write(32);
        this.writer.write(this.decimalFormat.format(vertex.getZ()));
        this.writer.write(this.lineSeparator);
        return ++this.vertexCount;
    }

    public void writeFace(int ... vertexIndices) throws IOException {
        this.writeFaceWithVertexOffset(0, vertexIndices);
    }

    public void writeBoundaries(BoundarySource3D boundarySource) throws IOException {
        if (boundarySource instanceof Mesh) {
            this.writeMesh((Mesh)boundarySource);
        } else {
            try (Stream stream = boundarySource.boundaryStream();){
                this.writeBoundaries(stream.iterator());
            }
        }
    }

    private void writeBoundaries(Iterator<PlaneConvexSubset> it) throws IOException {
        while (it.hasNext()) {
            PlaneConvexSubset boundary = it.next();
            if (boundary.isInfinite()) {
                throw new IllegalArgumentException("OBJ input geometry cannot be infinite: " + boundary);
            }
            List vertices = boundary.getVertices();
            int[] vertexIndices = new int[vertices.size()];
            for (int i = 0; i < vertexIndices.length; ++i) {
                vertexIndices[i] = this.writeVertex((Vector3D)vertices.get(i));
            }
            this.writeFace(vertexIndices);
        }
    }

    public void writeMesh(Mesh<?> mesh) throws IOException {
        int vertexOffset = this.vertexCount + 1;
        for (Vector3D vertex : mesh.vertices()) {
            this.writeVertex(vertex);
        }
        for (Mesh.Face face : mesh.faces()) {
            this.writeFaceWithVertexOffset(vertexOffset, face.getVertexIndices());
        }
    }

    private void writeFaceWithVertexOffset(int vertexOffset, int ... vertexIndices) throws IOException {
        if (vertexIndices.length < 3) {
            throw new IllegalArgumentException("Face must have more than 3 vertices; found " + vertexIndices.length);
        }
        this.writer.write("f");
        for (int vertexIndex : vertexIndices) {
            this.writer.write(32);
            this.writer.write(String.valueOf(vertexIndex + vertexOffset));
        }
        this.writer.write(this.lineSeparator);
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        this.writer = null;
    }
}

