/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.io.threed;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.examples.io.threed.DefaultModelIOHandlerRegistry;
import org.apache.commons.geometry.examples.io.threed.ModelIOHandlerRegistry;

public final class ModelIO {
    public static final String OBJ = "obj";
    private static final ModelIOHandlerRegistry HANDLER_REGISTRY = new DefaultModelIOHandlerRegistry();

    private ModelIO() {
    }

    public static ModelIOHandlerRegistry getModelIOHandlerRegistry() {
        return HANDLER_REGISTRY;
    }

    public static BoundarySource3D read(File in, DoublePrecisionContext precision) {
        return HANDLER_REGISTRY.read(in, precision);
    }

    public static BoundarySource3D read(String type, File in, DoublePrecisionContext precision) {
        return HANDLER_REGISTRY.read(type, in, precision);
    }

    public static BoundarySource3D read(String type, InputStream in, DoublePrecisionContext precision) {
        return HANDLER_REGISTRY.read(type, in, precision);
    }

    public static void write(BoundarySource3D model, File out) {
        HANDLER_REGISTRY.write(model, out);
    }

    public static void write(BoundarySource3D model, String type, File out) {
        HANDLER_REGISTRY.write(model, type, out);
    }

    public static void write(BoundarySource3D model, String type, OutputStream out) {
        HANDLER_REGISTRY.write(model, type, out);
    }
}

