/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.examples.io.threed;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.geometry.core.precision.DoublePrecisionContext;
import org.apache.commons.geometry.euclidean.threed.BoundarySource3D;
import org.apache.commons.geometry.examples.io.threed.ModelIOHandler;

public abstract class AbstractModelIOHandler
implements ModelIOHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BoundarySource3D read(String type, File in, DoublePrecisionContext precision) {
        this.ensureTypeSupported(type);
        try (InputStream is = Files.newInputStream(in.toPath(), new OpenOption[0]);){
            BoundarySource3D boundarySource3D = this.readInternal(type, is, precision);
            return boundarySource3D;
        }
        catch (IOException exc) {
            throw this.createUnchecked(exc);
        }
    }

    @Override
    public BoundarySource3D read(String type, InputStream in, DoublePrecisionContext precision) {
        this.ensureTypeSupported(type);
        try {
            return this.readInternal(type, in, precision);
        }
        catch (IOException exc) {
            throw this.createUnchecked(exc);
        }
    }

    @Override
    public void write(BoundarySource3D model, String type, File out) {
        this.ensureTypeSupported(type);
        try (OutputStream os = Files.newOutputStream(out.toPath(), new OpenOption[0]);){
            this.writeInternal(model, type, os);
        }
        catch (IOException exc) {
            throw this.createUnchecked(exc);
        }
    }

    @Override
    public void write(BoundarySource3D model, String type, OutputStream out) {
        this.ensureTypeSupported(type);
        try {
            this.writeInternal(model, type, out);
        }
        catch (IOException exc) {
            throw this.createUnchecked(exc);
        }
    }

    private void ensureTypeSupported(String type) {
        if (!this.handlesType(type)) {
            throw new IllegalArgumentException("File type is not supported by this handler: " + type);
        }
    }

    private UncheckedIOException createUnchecked(IOException exc) {
        String msg = exc.getClass().getSimpleName() + ": " + exc.getMessage();
        return new UncheckedIOException(msg, exc);
    }

    protected abstract BoundarySource3D readInternal(String var1, InputStream var2, DoublePrecisionContext var3) throws IOException;

    protected abstract void writeInternal(BoundarySource3D var1, String var2, OutputStream var3) throws IOException;
}

