/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.environment;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EnvironmentUtilsTest {
    @Test
    public void testCaseInsensitiveVariableLookup() throws Exception {
        Map procEnvironment = EnvironmentUtils.getProcEnvironment();
        EnvironmentUtils.addVariableToEnvironment((Map)procEnvironment, (String)"foo=bAr");
        Assertions.assertEquals((Object)"bAr", procEnvironment.get("foo"));
    }

    @Test
    public void testGetProcEnvironment() throws IOException {
        Map procEnvironment = EnvironmentUtils.getProcEnvironment();
        Assertions.assertFalse((boolean)procEnvironment.isEmpty(), (String)"Expecting non-zero environment size");
        String[] envArgs = EnvironmentUtils.toStrings((Map)procEnvironment);
        for (int i = 0; i < envArgs.length; ++i) {
            Assertions.assertNotNull((Object)envArgs[i], (String)("Entry " + i + " should not be null"));
            Assertions.assertFalse((boolean)envArgs[i].isEmpty(), (String)("Entry " + i + " should not be empty"));
        }
    }

    @Test
    public void testGetProcEnvironmentCaseInsensitiveLookup() throws IOException {
        if (!OS.isFamilyWindows()) {
            return;
        }
        Map procEnvironment = EnvironmentUtils.getProcEnvironment();
        for (Map.Entry entry : procEnvironment.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Assertions.assertEquals((Object)value, procEnvironment.get(key.toLowerCase(Locale.ENGLISH)));
            Assertions.assertEquals((Object)value, procEnvironment.get(key.toUpperCase(Locale.ENGLISH)));
        }
        EnvironmentUtils.addVariableToEnvironment((Map)procEnvironment, (String)"foo=bar");
        Assertions.assertEquals((Object)"bar", procEnvironment.get("FOO"));
        Assertions.assertEquals((Object)"bar", procEnvironment.get("Foo"));
        Assertions.assertEquals((Object)"bar", procEnvironment.get("foo"));
    }

    @Test
    public void testToStrings() {
        Assertions.assertNull((Object)EnvironmentUtils.toStrings(null));
        HashMap<String, String> env = new HashMap<String, String>();
        Assertions.assertArrayEquals((Object[])new String[0], (Object[])EnvironmentUtils.toStrings(env));
        env.put("foo2", "bar2");
        env.put("foo", "bar");
        Object[] envStrings = EnvironmentUtils.toStrings(env);
        Object[] expected = new String[]{"foo2=bar2", "foo=bar"};
        Arrays.sort(expected);
        Arrays.sort(envStrings);
        Assertions.assertArrayEquals((Object[])expected, (Object[])envStrings);
    }

    @Test
    public void testToStringWithNullKey() {
        HashMap<Object, String> env = new HashMap<Object, String>();
        env.put(null, "TheNullKey");
        String[] strings = EnvironmentUtils.toStrings(env);
        Assertions.assertEquals((int)1, (int)strings.length);
        Assertions.assertEquals((Object)"=TheNullKey", (Object)strings[0]);
    }

    @Test
    public void testToStringWithNullValue() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("key", null);
        String[] strings = EnvironmentUtils.toStrings(env);
        Assertions.assertEquals((int)1, (int)strings.length);
        Assertions.assertEquals((Object)"key=", (Object)strings[0]);
    }
}

