/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class LogOutputStreamTest {
    private final Executor exec = new DefaultExecutor();
    private final File testDir = new File("src/test/scripts");
    private OutputStream systemOut;
    private final File environmentScript = TestUtil.resolveScriptForOS(this.testDir + "/environment");

    @BeforeClass
    public static void classSetUp() {
        System.setProperty("org.apache.commons.exec.lenient", "false");
        System.setProperty("org.apache.commons.exec.debug", "true");
    }

    @Before
    public void setUp() throws Exception {
        this.systemOut = new SystemLogOutputStream(1);
        this.exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(this.systemOut, this.systemOut));
    }

    @After
    public void tearDown() throws Exception {
        this.systemOut.close();
    }

    @Test
    public void testStdout() throws Exception {
        CommandLine cl = new CommandLine(this.environmentScript);
        int exitValue = this.exec.execute(cl);
        Assert.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    private class SystemLogOutputStream
    extends LogOutputStream {
        private SystemLogOutputStream(int level) {
            super(level);
        }

        protected void processLine(String line, int level) {
            System.out.println(line);
        }
    }
}

