/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.convert.ValueTransformer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDisabledListDelimiterHandler {
    private static final Object[] VALUES = new Object[]{20130630213801L, "A test value", 5};
    private static final String STR_VALUE = "  A test, string; value! ";
    private DisabledListDelimiterHandler handler;

    @Before
    public void setUp() throws Exception {
        this.handler = new DisabledListDelimiterHandler();
    }

    private static void checkIterator(Iterable<?> container) {
        Iterator<?> it = container.iterator();
        for (Object o : VALUES) {
            Assert.assertEquals((String)"Wrong value", (Object)o, it.next());
        }
        Assert.assertFalse((String)"Iterator has too many objects", (boolean)it.hasNext());
    }

    @Test
    public void testParseArray() {
        TestDisabledListDelimiterHandler.checkIterator(this.handler.parse((Object)VALUES));
    }

    @Test
    public void testParseIterable() {
        TestDisabledListDelimiterHandler.checkIterator(this.handler.parse(Arrays.asList(VALUES)));
    }

    @Test
    public void testParseIterator() {
        TestDisabledListDelimiterHandler.checkIterator(this.handler.parse(Arrays.asList(VALUES).iterator()));
    }

    @Test
    public void testParseSimpleValue() {
        Iterator it = this.handler.parse((Object)STR_VALUE).iterator();
        Assert.assertEquals((String)"Wrong value", (Object)STR_VALUE, it.next());
        Assert.assertFalse((String)"Too many values", (boolean)it.hasNext());
    }

    @Test
    public void testParseNull() {
        Assert.assertFalse((String)"Got a value", (boolean)this.handler.parse(null).iterator().hasNext());
    }

    @Test
    public void testEscapeStringValue() {
        Assert.assertEquals((String)"Wrong escaped string", (Object)STR_VALUE, (Object)this.handler.escape((Object)STR_VALUE, ListDelimiterHandler.NOOP_TRANSFORMER));
    }

    @Test
    public void testEscapeStringValueTransformer() {
        ValueTransformer trans = (ValueTransformer)EasyMock.createMock(ValueTransformer.class);
        String testStr = "Some other string";
        EasyMock.expect((Object)trans.transformValue((Object)"Some other string")).andReturn((Object)STR_VALUE);
        EasyMock.replay((Object[])new Object[]{trans});
        Assert.assertEquals((String)"Wrong escaped string", (Object)STR_VALUE, (Object)this.handler.escape((Object)"Some other string", trans));
        EasyMock.verify((Object[])new Object[]{trans});
    }

    @Test
    public void testEscapeNonStringValue() {
        Integer value = 42;
        Assert.assertEquals((String)"Wrong escaped object", (Object)value, (Object)this.handler.escape((Object)value, ListDelimiterHandler.NOOP_TRANSFORMER));
    }

    @Test
    public void testEscapeNonStringValueTransformer() {
        ValueTransformer trans = (ValueTransformer)EasyMock.createMock(ValueTransformer.class);
        Integer value = 42;
        EasyMock.expect((Object)trans.transformValue((Object)value)).andReturn((Object)STR_VALUE);
        EasyMock.replay((Object[])new Object[]{trans});
        Assert.assertEquals((String)"Wrong escaped object", (Object)STR_VALUE, (Object)this.handler.escape((Object)value, trans));
        EasyMock.verify((Object[])new Object[]{trans});
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testEscapeList() {
        this.handler.escapeList(Arrays.asList(VALUES), ListDelimiterHandler.NOOP_TRANSFORMER);
    }

    @Test
    public void testFlattenArrayWithLimit() {
        Collection res = this.handler.flatten((Object)VALUES, 1);
        Assert.assertEquals((String)"Wrong collection size", (long)1L, (long)res.size());
        Assert.assertEquals((String)"Wrong element", (Object)VALUES[0], res.iterator().next());
    }

    @Test
    public void testFlattenCollectionWithLimit() {
        List<Object> src = Arrays.asList(VALUES);
        Collection res = this.handler.flatten(src, 1);
        Assert.assertEquals((String)"Wrong collection size", (long)1L, (long)res.size());
        Assert.assertEquals((String)"Wrong element", (Object)VALUES[0], res.iterator().next());
    }

    @Test
    public void testFlattenCollectionWithArrayWithLimit() {
        ArrayList<Object> src = new ArrayList<Object>(2);
        src.add(STR_VALUE);
        src.add(VALUES);
        Collection res = this.handler.flatten(src, 2);
        Assert.assertEquals((String)"Wrong collection size", (long)2L, (long)res.size());
        Iterator it = res.iterator();
        Assert.assertEquals((String)"Wrong element (1)", (Object)STR_VALUE, it.next());
        Assert.assertEquals((String)"Wrong element (2)", (Object)VALUES[0], it.next());
    }
}

