/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.fluent;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.configuration2.ConfigurationConsumer;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.BasicBuilderProperties;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.DefaultParametersHandler;
import org.apache.commons.configuration2.builder.DefaultParametersManager;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.CombinedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.MultiFileBuilderParametersImpl;
import org.apache.commons.configuration2.builder.fluent.CombinedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.DatabaseBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.HierarchicalBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.JndiBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.MultiFileBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestParameters {
    private static final String DEF_ENCODING = "UTF-8";
    private static ListDelimiterHandler listHandler;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        listHandler = (ListDelimiterHandler)EasyMock.createMock(ListDelimiterHandler.class);
    }

    @Test
    public void testDefaultParametersManager() {
        Parameters parameters = new Parameters();
        Assert.assertNotNull((String)"No default manager", (Object)parameters.getDefaultParametersManager());
    }

    @Test
    public void testBasic() {
        BasicBuilderParameters basic = new Parameters().basic();
        Assert.assertNotNull((String)"No result object", (Object)basic);
    }

    private static void checkBasicProperties(Map<String, Object> map) {
        Assert.assertEquals((String)"Wrong delimiter handler", (Object)listHandler, (Object)map.get("listDelimiterHandler"));
        Assert.assertEquals((String)"Wrong exception flag value", (Object)Boolean.TRUE, (Object)map.get("throwExceptionOnMissing"));
    }

    @Test
    public void testFileBased() {
        Map map = ((FileBasedBuilderParameters)((FileBasedBuilderParameters)((FileBasedBuilderParameters)((FileBasedBuilderParameters)new Parameters().fileBased().setThrowExceptionOnMissing(true)).setEncoding(DEF_ENCODING)).setListDelimiterHandler(listHandler)).setFileName("test.xml")).getParameters();
        FileBasedBuilderParametersImpl fbparams = FileBasedBuilderParametersImpl.fromParameters((Map)map);
        Assert.assertEquals((String)"Wrong file name", (Object)"test.xml", (Object)fbparams.getFileHandler().getFileName());
        Assert.assertEquals((String)"Wrong encoding", (Object)DEF_ENCODING, (Object)fbparams.getFileHandler().getEncoding());
        TestParameters.checkBasicProperties(map);
    }

    private static void checkInstanceOf(Object obj, Class<?> cls) {
        Assert.assertTrue((String)(obj + " is not an instance of " + cls), (boolean)cls.isInstance(obj));
    }

    private static void checkInheritance(Object params, Class<?> ... ifcClasses) {
        TestParameters.checkInstanceOf(params, BasicBuilderProperties.class);
        for (Class<?> c : ifcClasses) {
            TestParameters.checkInstanceOf(params, c);
        }
    }

    @Test
    public void testFileBasedInheritance() {
        TestParameters.checkInheritance(new Parameters().fileBased(), new Class[0]);
    }

    @Test
    public void testProxyObjectMethods() {
        FileBasedBuilderParameters params = new Parameters().fileBased();
        String s = params.toString();
        Assert.assertTrue((String)("Wrong string: " + s), (s.indexOf(FileBasedBuilderParametersImpl.class.getSimpleName()) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"No hash code", (params.hashCode() != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCombined() {
        Map map = ((CombinedBuilderParameters)((CombinedBuilderParameters)((CombinedBuilderParameters)new Parameters().combined().setThrowExceptionOnMissing(true)).setBasePath("test")).setListDelimiterHandler(listHandler)).getParameters();
        CombinedBuilderParametersImpl cparams = CombinedBuilderParametersImpl.fromParameters((Map)map);
        Assert.assertEquals((String)"Wrong base path", (Object)"test", (Object)cparams.getBasePath());
        TestParameters.checkBasicProperties(map);
    }

    @Test
    public void testJndi() {
        Map map = ((JndiBuilderParameters)((JndiBuilderParameters)((JndiBuilderParameters)new Parameters().jndi().setThrowExceptionOnMissing(true)).setPrefix("test")).setListDelimiterHandler(listHandler)).getParameters();
        Assert.assertEquals((String)"Wrong prefix", (Object)"test", map.get("prefix"));
        TestParameters.checkBasicProperties(map);
    }

    @Test
    public void testHierarchical() {
        ExpressionEngine engine = (ExpressionEngine)EasyMock.createMock(ExpressionEngine.class);
        Map map = ((HierarchicalBuilderParameters)((HierarchicalBuilderParameters)((HierarchicalBuilderParameters)((HierarchicalBuilderParameters)new Parameters().hierarchical().setThrowExceptionOnMissing(true)).setExpressionEngine(engine)).setFileName("test.xml")).setListDelimiterHandler(listHandler)).getParameters();
        TestParameters.checkBasicProperties(map);
        FileBasedBuilderParametersImpl fbp = FileBasedBuilderParametersImpl.fromParameters((Map)map);
        Assert.assertEquals((String)"Wrong file name", (Object)"test.xml", (Object)fbp.getFileHandler().getFileName());
        Assert.assertEquals((String)"Wrong expression engine", (Object)engine, map.get("expressionEngine"));
    }

    @Test
    public void testHierarchicalInheritance() {
        TestParameters.checkInheritance(new Parameters().hierarchical(), FileBasedBuilderParameters.class);
    }

    @Test
    public void testXml() {
        ExpressionEngine engine = (ExpressionEngine)EasyMock.createMock(ExpressionEngine.class);
        Map map = ((XMLBuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)((XMLBuilderParameters)new Parameters().xml().setThrowExceptionOnMissing(true)).setFileName("test.xml")).setValidating(true)).setExpressionEngine(engine)).setListDelimiterHandler(listHandler)).setSchemaValidation(true)).getParameters();
        TestParameters.checkBasicProperties(map);
        FileBasedBuilderParametersImpl fbp = FileBasedBuilderParametersImpl.fromParameters((Map)map);
        Assert.assertEquals((String)"Wrong file name", (Object)"test.xml", (Object)fbp.getFileHandler().getFileName());
        Assert.assertEquals((String)"Wrong validation flag", (Object)Boolean.TRUE, map.get("validating"));
        Assert.assertEquals((String)"Wrong schema flag", (Object)Boolean.TRUE, map.get("schemaValidation"));
        Assert.assertEquals((String)"Wrong expression engine", (Object)engine, map.get("expressionEngine"));
    }

    @Test
    public void testXmlInheritance() {
        TestParameters.checkInheritance(new Parameters().xml(), HierarchicalBuilderParameters.class, FileBasedBuilderParameters.class);
    }

    @Test
    public void testProperties() {
        PropertiesConfiguration.IOFactory factory = (PropertiesConfiguration.IOFactory)EasyMock.createMock(PropertiesConfiguration.IOFactory.class);
        ConfigurationConsumer includeListener = (ConfigurationConsumer)EasyMock.createMock(ConfigurationConsumer.class);
        Map map = ((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setThrowExceptionOnMissing(true)).setFileName("test.properties")).setIncludeListener(includeListener)).setIOFactory(factory)).setListDelimiterHandler(listHandler)).setIncludesAllowed(false)).getParameters();
        TestParameters.checkBasicProperties(map);
        FileBasedBuilderParametersImpl fbp = FileBasedBuilderParametersImpl.fromParameters((Map)map);
        Assert.assertEquals((String)"Wrong file name", (Object)"test.properties", (Object)fbp.getFileHandler().getFileName());
        Assert.assertEquals((String)"Wrong includes flag", (Object)Boolean.FALSE, map.get("includesAllowed"));
        Assert.assertSame((String)"Wrong include listener", (Object)includeListener, map.get("includeListener"));
        Assert.assertSame((String)"Wrong factory", (Object)factory, map.get("IOFactory"));
    }

    @Test
    public void testPropertiesInheritance() {
        TestParameters.checkInheritance(new Parameters().properties(), FileBasedBuilderParameters.class);
    }

    @Test
    public void testMultiFile() {
        BuilderParameters bp = (BuilderParameters)EasyMock.createMock(BuilderParameters.class);
        String pattern = "a pattern";
        Map map = ((MultiFileBuilderParameters)((MultiFileBuilderParameters)((MultiFileBuilderParameters)((MultiFileBuilderParameters)new Parameters().multiFile().setThrowExceptionOnMissing(true)).setFilePattern("a pattern")).setListDelimiterHandler(listHandler)).setManagedBuilderParameters(bp)).getParameters();
        TestParameters.checkBasicProperties(map);
        MultiFileBuilderParametersImpl params = MultiFileBuilderParametersImpl.fromParameters((Map)map);
        Assert.assertSame((String)"Wrong builder parameters", (Object)bp, (Object)params.getManagedBuilderParameters());
        Assert.assertEquals((String)"Wrong pattern", (Object)"a pattern", (Object)params.getFilePattern());
    }

    @Test
    public void testDatabase() {
        Map map = ((DatabaseBuilderParameters)((DatabaseBuilderParameters)((DatabaseBuilderParameters)((DatabaseBuilderParameters)((DatabaseBuilderParameters)new Parameters().database().setThrowExceptionOnMissing(true)).setAutoCommit(true)).setTable("table")).setListDelimiterHandler(listHandler)).setKeyColumn("keyColumn")).getParameters();
        TestParameters.checkBasicProperties(map);
        Assert.assertEquals((String)"Wrong table name", (Object)"table", map.get("table"));
        Assert.assertEquals((String)"Wrong key column name", (Object)"keyColumn", map.get("keyColumn"));
        Assert.assertEquals((String)"Wrong auto commit flag", (Object)Boolean.TRUE, map.get("autoCommit"));
    }

    @Test
    public void testInheritance() {
        XMLBuilderParameters params = new Parameters().xml();
        Assert.assertTrue((String)"No instance of base interface", (boolean)(params instanceof FileBasedBuilderParameters));
        Assert.assertTrue((String)"No instance of base interface (dynamic)", (boolean)FileBasedBuilderParameters.class.isInstance(params));
        FileBasedBuilderParameters fbParams = (FileBasedBuilderParameters)params;
        ((FileBasedBuilderParameters)((FileBasedBuilderParameters)fbParams.setListDelimiterHandler(listHandler)).setFileName("test.xml")).setThrowExceptionOnMissing(true);
        ExpressionEngine engine = (ExpressionEngine)EasyMock.createMock(ExpressionEngine.class);
        ((HierarchicalBuilderParameters)params).setExpressionEngine(engine);
        Map map = fbParams.getParameters();
        TestParameters.checkBasicProperties(map);
        Assert.assertSame((String)"Wrong expression engine", (Object)engine, map.get("expressionEngine"));
    }

    @Test
    public void testApplyDefaults() {
        DefaultParametersManager manager = (DefaultParametersManager)EasyMock.createMock(DefaultParametersManager.class);
        ArrayList initializedParams = new ArrayList(1);
        manager.initializeParameters((BuilderParameters)EasyMock.anyObject(BuilderParameters.class));
        EasyMock.expectLastCall().andAnswer(() -> {
            initializedParams.add(EasyMock.getCurrentArguments()[0]);
            return null;
        });
        EasyMock.replay((Object[])new Object[]{manager});
        Parameters params = new Parameters(manager);
        XMLBuilderParameters xmlParams = params.xml();
        Assert.assertEquals((String)"Wrong number of initializations", (long)1L, (long)initializedParams.size());
        Assert.assertSame((String)"Wrong initialized object", (Object)xmlParams, initializedParams.get(0));
    }

    private static DefaultParametersHandler<XMLBuilderParameters> createHandlerMock() {
        DefaultParametersHandler handler = (DefaultParametersHandler)EasyMock.createMock(DefaultParametersHandler.class);
        return handler;
    }

    @Test
    public void testRegisterDefaultsHandlerWithStartClass() {
        DefaultParametersManager manager = (DefaultParametersManager)EasyMock.createMock(DefaultParametersManager.class);
        DefaultParametersHandler<XMLBuilderParameters> handler = TestParameters.createHandlerMock();
        manager.registerDefaultsHandler(XMLBuilderParameters.class, handler, FileBasedBuilderParameters.class);
        EasyMock.replay((Object[])new Object[]{manager, handler});
        Parameters params = new Parameters(manager);
        params.registerDefaultsHandler(XMLBuilderParameters.class, handler, FileBasedBuilderParameters.class);
        EasyMock.verify((Object[])new Object[]{manager});
    }

    @Test
    public void testRegisterDefaultsHandlerNoStartClass() {
        DefaultParametersManager manager = (DefaultParametersManager)EasyMock.createMock(DefaultParametersManager.class);
        DefaultParametersHandler<XMLBuilderParameters> handler = TestParameters.createHandlerMock();
        manager.registerDefaultsHandler(XMLBuilderParameters.class, handler);
        EasyMock.replay((Object[])new Object[]{manager, handler});
        Parameters params = new Parameters(manager);
        params.registerDefaultsHandler(XMLBuilderParameters.class, handler);
        EasyMock.verify((Object[])new Object[]{manager});
    }
}

