/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.builder.combined.ConfigurationDeclaration;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurationDeclaration {
    private static ConfigurationDeclaration createDeclaration(HierarchicalConfiguration<?> conf) {
        BaseHierarchicalConfiguration config = conf != null ? conf : new BaseHierarchicalConfiguration();
        return new ConfigurationDeclaration(null, (HierarchicalConfiguration)config);
    }

    @Test
    public void testConfigurationDeclarationIsReserved() {
        ConfigurationDeclaration decl = TestConfigurationDeclaration.createDeclaration(null);
        Assert.assertTrue((String)"Attribute at not recognized", (boolean)decl.isReservedAttributeName("at"));
        Assert.assertTrue((String)"Attribute optional not recognized", (boolean)decl.isReservedAttributeName("optional"));
        Assert.assertTrue((String)"Inherited attribute not recognized", (boolean)decl.isReservedAttributeName("config-class"));
        Assert.assertFalse((String)"Wrong reserved attribute", (boolean)decl.isReservedAttributeName("different"));
    }

    @Test
    public void testConfigurationDeclarationIsReservedAt() {
        this.checkOldReservedAttribute("at");
    }

    @Test
    public void testConfigurationDeclarationIsReservedOptional() {
        this.checkOldReservedAttribute("optional");
    }

    private void checkOldReservedAttribute(String name) {
        String prefixName = "config-" + name;
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty(String.format("[@%s]", prefixName), (Object)Boolean.TRUE);
        ConfigurationDeclaration decl = TestConfigurationDeclaration.createDeclaration(config);
        Assert.assertTrue((String)(prefixName + " attribute not recognized"), (boolean)decl.isReservedAttributeName(prefixName));
        config.addProperty(String.format("[@%s]", name), (Object)Boolean.TRUE);
        Assert.assertFalse((String)(name + " is reserved though config- exists"), (boolean)decl.isReservedAttributeName(name));
        Assert.assertTrue((String)("config- attribute not recognized when " + name + " exists"), (boolean)decl.isReservedAttributeName(prefixName));
    }

    @Test
    public void testConfigurationDeclarationGetAttributes() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty("xml.fileName", (Object)"test.xml");
        ConfigurationDeclaration decl = TestConfigurationDeclaration.createDeclaration(config.configurationAt("xml"));
        Assert.assertNull((String)"Found an at attribute", (Object)decl.getAt());
        Assert.assertFalse((String)"Found an optional attribute", (boolean)decl.isOptional());
        config.addProperty("xml[@config-at]", (Object)"test1");
        decl = TestConfigurationDeclaration.createDeclaration(config.configurationAt("xml"));
        Assert.assertEquals((String)"Wrong value of at attribute", (Object)"test1", (Object)decl.getAt());
        config.addProperty("xml[@at]", (Object)"test2");
        decl = TestConfigurationDeclaration.createDeclaration(config.configurationAt("xml"));
        Assert.assertEquals((String)"Wrong value of config-at attribute", (Object)"test1", (Object)decl.getAt());
        config.clearProperty("xml[@config-at]");
        decl = TestConfigurationDeclaration.createDeclaration(config.configurationAt("xml"));
        Assert.assertEquals((String)"Old at attribute not detected", (Object)"test2", (Object)decl.getAt());
        config.addProperty("xml[@config-optional]", (Object)"true");
        decl = TestConfigurationDeclaration.createDeclaration(config.configurationAt("xml"));
        Assert.assertTrue((String)"Wrong value of optional attribute", (boolean)decl.isOptional());
        config.addProperty("xml[@optional]", (Object)"false");
        decl = TestConfigurationDeclaration.createDeclaration(config.configurationAt("xml"));
        Assert.assertTrue((String)"Wrong value of config-optional attribute", (boolean)decl.isOptional());
        config.clearProperty("xml[@config-optional]");
        config.setProperty("xml[@optional]", (Object)Boolean.TRUE);
        decl = TestConfigurationDeclaration.createDeclaration(config.configurationAt("xml"));
        Assert.assertTrue((String)"Old optional attribute not detected", (boolean)decl.isOptional());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testConfigurationDeclarationOptionalAttributeInvalid() {
        BaseHierarchicalConfiguration factory = new BaseHierarchicalConfiguration();
        factory.addProperty("xml.fileName", (Object)"test.xml");
        factory.setProperty("xml[@optional]", (Object)"invalid value");
        ConfigurationDeclaration decl = TestConfigurationDeclaration.createDeclaration(factory.configurationAt("xml"));
        decl.isOptional();
    }
}

