/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.sync.ReadWriteSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeMatcher;
import org.apache.commons.configuration2.tree.NodeNameMatchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestINIConfiguration {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String INI_DATA = "[section1]" + LINE_SEPARATOR + "var1 = foo" + LINE_SEPARATOR + "var2 = 451" + LINE_SEPARATOR + LINE_SEPARATOR + "[section2]" + LINE_SEPARATOR + "var1 = 123.45" + LINE_SEPARATOR + "var2 = bar" + LINE_SEPARATOR + LINE_SEPARATOR + "[section3]" + LINE_SEPARATOR + "var1 = true" + LINE_SEPARATOR + "interpolated = ${section3.var1}" + LINE_SEPARATOR + "multi = foo" + LINE_SEPARATOR + "multi = bar" + LINE_SEPARATOR + LINE_SEPARATOR;
    private static final String INI_DATA2 = "[section4]" + LINE_SEPARATOR + "var1 = \"quoted value\"" + LINE_SEPARATOR + "var2 = \"quoted value\\nwith \\\"quotes\\\"\"" + LINE_SEPARATOR + "var3 = 123 ; comment" + LINE_SEPARATOR + "var4 = \"1;2;3\" ; comment" + LINE_SEPARATOR + "var5 = '\\'quoted\\' \"value\"' ; comment" + LINE_SEPARATOR + "var6 = \"\"" + LINE_SEPARATOR;
    private static final String INI_DATA3 = "[section5]" + LINE_SEPARATOR + "multiLine = one \\" + LINE_SEPARATOR + "    two      \\" + LINE_SEPARATOR + " three" + LINE_SEPARATOR + "singleLine = C:\\Temp\\" + LINE_SEPARATOR + "multiQuoted = one \\" + LINE_SEPARATOR + "\"  two  \" \\" + LINE_SEPARATOR + "  three" + LINE_SEPARATOR + "multiComment = one \\ ; a comment" + LINE_SEPARATOR + "two" + LINE_SEPARATOR + "multiQuotedComment = \" one \" \\ ; comment" + LINE_SEPARATOR + "two" + LINE_SEPARATOR + "noFirstLine = \\" + LINE_SEPARATOR + "  line 2" + LINE_SEPARATOR + "continueNoLine = one \\" + LINE_SEPARATOR;
    private static final String INI_DATA4 = "[section6]" + LINE_SEPARATOR + "key1{0}value1" + LINE_SEPARATOR + "key2{0}value2" + LINE_SEPARATOR + LINE_SEPARATOR + "[section7]" + LINE_SEPARATOR + "key3{0}value3" + LINE_SEPARATOR;
    private static final String INI_DATA_SEPARATORS = "[section]" + LINE_SEPARATOR + "var1 = value1" + LINE_SEPARATOR + "var2 : value2" + LINE_SEPARATOR + "var3=value3" + LINE_SEPARATOR + "var4:value4" + LINE_SEPARATOR + "var5 : value=5" + LINE_SEPARATOR + "var:6=value" + LINE_SEPARATOR + "var:7=\"value7\"" + LINE_SEPARATOR + "var:8 =  \"value8\"" + LINE_SEPARATOR;
    private static final String INI_DATA_GLOBAL_ONLY = "globalVar = testGlobal" + LINE_SEPARATOR + LINE_SEPARATOR;
    private static final String INI_DATA_GLOBAL = INI_DATA_GLOBAL_ONLY + INI_DATA;
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    private static INIConfiguration setUpConfig(String data) throws ConfigurationException {
        INIConfiguration instance = new INIConfiguration();
        instance.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        TestINIConfiguration.load(instance, data);
        return instance;
    }

    private static void load(INIConfiguration instance, String data) throws ConfigurationException {
        StringReader reader = new StringReader(data);
        try {
            instance.read((Reader)reader);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
        reader.close();
    }

    private static String saveToString(INIConfiguration config) throws ConfigurationException {
        StringWriter writer = new StringWriter();
        try {
            config.write((Writer)writer);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeTestFile(String content) throws IOException {
        File file = this.folder.newFile();
        try (PrintWriter out = new PrintWriter(new FileWriter(file));){
            out.println(content);
        }
        return file;
    }

    @Test
    public void testSave() throws Exception {
        StringWriter writer = new StringWriter();
        INIConfiguration instance = new INIConfiguration();
        instance.addProperty("section1.var1", (Object)"foo");
        instance.addProperty("section1.var2", (Object)"451");
        instance.addProperty("section2.var1", (Object)"123.45");
        instance.addProperty("section2.var2", (Object)"bar");
        instance.addProperty("section3.var1", (Object)"true");
        instance.addProperty("section3.interpolated", (Object)"${section3.var1}");
        instance.addProperty("section3.multi", (Object)"foo");
        instance.addProperty("section3.multi", (Object)"bar");
        instance.write((Writer)writer);
        Assert.assertEquals((String)"Wrong content of ini file", (Object)INI_DATA, (Object)((Object)writer).toString());
    }

    @Test
    public void testSeparatorUsedInINIOutput() throws Exception {
        String outputSeparator = ": ";
        String input = MessageFormat.format(INI_DATA4, "=").trim();
        String expectedOutput = MessageFormat.format(INI_DATA4, ": ").trim();
        INIConfiguration instance = (INIConfiguration)new FileBasedConfigurationBuilder(INIConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().ini().setSeparatorUsedInOutput(": ")}).getConfiguration();
        TestINIConfiguration.load(instance, input);
        StringWriter writer = new StringWriter();
        instance.write((Writer)writer);
        String result = ((Object)writer).toString().trim();
        Assert.assertEquals((String)"Wrong content of ini file", (Object)expectedOutput, (Object)result);
    }

    @Test
    public void testSeparatorUsedInINIInput() throws Exception {
        String inputSeparator = "=";
        String input = "[section]" + LINE_SEPARATOR + "k1:v1$key1=value1" + LINE_SEPARATOR + "k1:v1,k2:v2$key2=value2" + LINE_SEPARATOR + "key3:value3" + LINE_SEPARATOR + "key4 = value4" + LINE_SEPARATOR;
        INIConfiguration instance = (INIConfiguration)new FileBasedConfigurationBuilder(INIConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().ini().setSeparatorUsedInInput("=")}).getConfiguration();
        TestINIConfiguration.load(instance, input);
        Assert.assertEquals((Object)"value1", (Object)instance.getString("section.k1:v1$key1"));
        Assert.assertEquals((Object)"value2", (Object)instance.getString("section.k1:v1,k2:v2$key2"));
        Assert.assertEquals((Object)"", (Object)instance.getString("section.key3:value3"));
        Assert.assertEquals((Object)"value4", (Object)instance.getString("section.key4").trim());
    }

    @Test
    public void testCommentLeadingSeparatorUsedInINIInput() throws Exception {
        String inputCommentLeadingSeparator = ";";
        String input = "[section]" + LINE_SEPARATOR + "key1=a;b;c" + LINE_SEPARATOR + "key2=a#b#c" + LINE_SEPARATOR + ";key3=value3" + LINE_SEPARATOR + "#key4=value4" + LINE_SEPARATOR;
        INIConfiguration instance = (INIConfiguration)new FileBasedConfigurationBuilder(INIConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().ini().setCommentLeadingCharsUsedInInput(";")}).getConfiguration();
        TestINIConfiguration.load(instance, input);
        Assert.assertEquals((Object)"a;b;c", (Object)instance.getString("section.key1"));
        Assert.assertEquals((Object)"a#b#c", (Object)instance.getString("section.key2"));
        Assert.assertNull((String)"", (Object)instance.getString("section.;key3"));
        Assert.assertEquals((Object)"value4", (Object)instance.getString("section.#key4"));
    }

    private void checkSave(String content) throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(content);
        String sOutput = TestINIConfiguration.saveToString(config);
        Assert.assertEquals((String)"Wrong content of ini file", (Object)content, (Object)sOutput);
    }

    @Test
    public void testSaveWithGlobalSection() throws ConfigurationException {
        this.checkSave(INI_DATA_GLOBAL);
    }

    @Test
    public void testSaveWithOnlyGlobalSection() throws ConfigurationException {
        this.checkSave(INI_DATA_GLOBAL_ONLY);
    }

    @Test
    public void testSaveWithDelimiterParsingDisabled() throws ConfigurationException {
        INIConfiguration config = new INIConfiguration();
        String data = INI_DATA.substring(0, INI_DATA.length() - LINE_SEPARATOR.length()) + "nolist = 1,2, 3";
        TestINIConfiguration.load(config, data);
        Assert.assertEquals((String)"Wrong property value", (Object)"1,2, 3", (Object)config.getString("section3.nolist"));
        String content = TestINIConfiguration.saveToString(config);
        INIConfiguration config2 = new INIConfiguration();
        TestINIConfiguration.load(config2, content);
        Assert.assertEquals((String)"Wrong property value after reload", (Object)"1,2, 3", (Object)config2.getString("section3.nolist"));
    }

    @Test
    public void testLoad() throws Exception {
        this.checkLoad(INI_DATA);
    }

    @Test
    public void testLoadAlternativeSeparator() throws Exception {
        this.checkLoad(INI_DATA.replace('=', ':'));
    }

    @Test
    public void testLoadFromBuilder() throws ConfigurationException, IOException {
        File file = this.writeTestFile(INI_DATA);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(INIConfiguration.class);
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        INIConfiguration config = (INIConfiguration)builder.getConfiguration();
        this.checkContent(config);
    }

    private void checkContent(INIConfiguration instance) {
        Assert.assertEquals((String)"var1", (Object)"foo", (Object)instance.getString("section1.var1"));
        Assert.assertEquals((String)"var2", (long)451L, (long)instance.getInt("section1.var2"));
        Assert.assertEquals((String)"section2.var1", (double)123.45, (double)instance.getDouble("section2.var1"), (double)0.001);
        Assert.assertEquals((String)"section2.var2", (Object)"bar", (Object)instance.getString("section2.var2"));
        Assert.assertEquals((String)"section3.var1", (Object)true, (Object)instance.getBoolean("section3.var1"));
        Assert.assertEquals((String)"Wrong number of sections", (long)3L, (long)instance.getSections().size());
        Assert.assertTrue((String)"Wrong sections", (boolean)instance.getSections().containsAll(Arrays.asList("section1", "section2", "section3")));
    }

    private void checkLoad(String data) throws ConfigurationException {
        INIConfiguration instance = TestINIConfiguration.setUpConfig(data);
        this.checkContent(instance);
    }

    @Test
    public void testIsCommentLine() {
        INIConfiguration instance = new INIConfiguration();
        Assert.assertTrue((boolean)instance.isCommentLine("#comment1"));
        Assert.assertTrue((boolean)instance.isCommentLine(";comment1"));
        Assert.assertFalse((boolean)instance.isCommentLine("nocomment=true"));
        Assert.assertFalse((boolean)instance.isCommentLine(null));
    }

    @Test
    public void testIsSectionLine() {
        INIConfiguration instance = new INIConfiguration();
        Assert.assertTrue((boolean)instance.isSectionLine("[section]"));
        Assert.assertFalse((boolean)instance.isSectionLine("nosection=true"));
        Assert.assertFalse((boolean)instance.isSectionLine(null));
    }

    @Test
    public void testGetSections() {
        INIConfiguration instance = new INIConfiguration();
        instance.addProperty("test1.foo", (Object)"bar");
        instance.addProperty("test2.foo", (Object)"abc");
        HashSet<String> expResult = new HashSet<String>();
        expResult.add("test1");
        expResult.add("test2");
        Set result = instance.getSections();
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testQuotedValue() throws Exception {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA2);
        Assert.assertEquals((String)"value", (Object)"quoted value", (Object)config.getString("section4.var1"));
    }

    @Test
    public void testQuotedValueWithQuotes() throws Exception {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA2);
        Assert.assertEquals((String)"value", (Object)"quoted value\\nwith \"quotes\"", (Object)config.getString("section4.var2"));
    }

    @Test
    public void testValueWithComment() throws Exception {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA2);
        Assert.assertEquals((String)"value", (Object)"123", (Object)config.getString("section4.var3"));
    }

    @Test
    public void testQuotedValueWithComment() throws Exception {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA2);
        Assert.assertEquals((String)"value", (Object)"1;2;3", (Object)config.getString("section4.var4"));
    }

    @Test
    public void testQuotedValueWithSingleQuotes() throws Exception {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA2);
        Assert.assertEquals((String)"value", (Object)"'quoted' \"value\"", (Object)config.getString("section4.var5"));
    }

    @Test
    public void testWriteValueWithCommentChar() throws Exception {
        INIConfiguration config = new INIConfiguration();
        config.setProperty("section.key1", (Object)"1;2;3");
        StringWriter writer = new StringWriter();
        config.write((Writer)writer);
        INIConfiguration config2 = new INIConfiguration();
        config2.read((Reader)new StringReader(writer.toString()));
        Assert.assertEquals((String)"value", (Object)"1;2;3", (Object)config2.getString("section.key1"));
    }

    @Test
    public void testQuotedValueWithWhitespace() throws Exception {
        String content = "CmdPrompt = \" [test@cmd ~]$ \"";
        INIConfiguration config = TestINIConfiguration.setUpConfig("CmdPrompt = \" [test@cmd ~]$ \"");
        Assert.assertEquals((String)"Wrong propert value", (Object)" [test@cmd ~]$ ", (Object)config.getString("CmdPrompt"));
    }

    @Test
    public void testQuotedValueWithWhitespaceAndComment() throws Exception {
        String content = "CmdPrompt = \" [test@cmd ~]$ \" ; a comment";
        INIConfiguration config = TestINIConfiguration.setUpConfig("CmdPrompt = \" [test@cmd ~]$ \" ; a comment");
        Assert.assertEquals((String)"Wrong propert value", (Object)" [test@cmd ~]$ ", (Object)config.getString("CmdPrompt"));
    }

    @Test
    public void testQuotedValueEmpty() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA2);
        Assert.assertEquals((String)"Wrong value for empty property", (Object)"", (Object)config.getString("section4.var6"));
    }

    @Test
    public void testGetPropertyNoValue() throws ConfigurationException {
        String data = INI_DATA2 + LINE_SEPARATOR + "noValue =" + LINE_SEPARATOR;
        INIConfiguration config = TestINIConfiguration.setUpConfig(data);
        Assert.assertEquals((String)"Wrong value of key", (Object)"", (Object)config.getString("section4.noValue"));
    }

    @Test
    public void testGetPropertyNoKey() throws ConfigurationException {
        String data = INI_DATA2 + LINE_SEPARATOR + "= noKey" + LINE_SEPARATOR;
        INIConfiguration config = TestINIConfiguration.setUpConfig(data);
        Assert.assertEquals((String)"Cannot find property with no key", (Object)"noKey", (Object)config.getString("section4. "));
    }

    @Test
    public void testGlobalProperty() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        Assert.assertEquals((String)"Wrong value of global property", (Object)"testGlobal", (Object)config.getString("globalVar"));
    }

    @Test
    public void testGlobalSectionConnected() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration sub = config.getSection(null);
        config.setProperty("globalVar", (Object)"changed");
        Assert.assertEquals((String)"Wrong value in sub", (Object)"changed", (Object)sub.getString("globalVar"));
    }

    private void checkSectionNames(INIConfiguration config, String[] expected) {
        Set sectionNames = config.getSections();
        Iterator it = sectionNames.iterator();
        for (int idx = 0; idx < expected.length; ++idx) {
            Assert.assertEquals((String)("Wrong section at " + idx), (Object)expected[idx], it.next());
        }
        Assert.assertFalse((String)"Too many sections", (boolean)it.hasNext());
    }

    private INIConfiguration checkSectionNames(String data, String[] expected) throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(data);
        this.checkSectionNames(config, expected);
        return config;
    }

    @Test
    public void testGetSectionsWithGlobal() throws ConfigurationException {
        this.checkSectionNames(INI_DATA_GLOBAL, new String[]{null, "section1", "section2", "section3"});
    }

    @Test
    public void testGetSectionsNoGlobal() throws ConfigurationException {
        this.checkSectionNames(INI_DATA, new String[]{"section1", "section2", "section3"});
    }

    @Test
    public void testGetSectionsGlobalOnly() throws ConfigurationException {
        this.checkSectionNames(INI_DATA_GLOBAL_ONLY, new String[]{null});
    }

    @Test
    public void testGetSectionsDottedVar() throws ConfigurationException {
        String data = "dotted.var = 1" + LINE_SEPARATOR + INI_DATA_GLOBAL;
        INIConfiguration config = this.checkSectionNames(data, new String[]{null, "section1", "section2", "section3"});
        Assert.assertEquals((String)"Wrong value of dotted variable", (long)1L, (long)config.getInt("dotted..var"));
    }

    @Test
    public void testGetSectionsAdded() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA2);
        config.addProperty("section5.test", (Object)Boolean.TRUE);
        this.checkSectionNames(config, new String[]{"section4", "section5"});
    }

    @Test
    public void testGetSectionExisting() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA);
        SubnodeConfiguration section = config.getSection("section1");
        Assert.assertEquals((String)"Wrong value of var1", (Object)"foo", (Object)section.getString("var1"));
        Assert.assertEquals((String)"Wrong value of var2", (Object)"451", (Object)section.getString("var2"));
    }

    @Test
    public void testGetSectionConnected() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA);
        SubnodeConfiguration section = config.getSection("section1");
        section.setProperty("var1", (Object)"foo2");
        Assert.assertEquals((String)"Not connected to parent", (Object)"foo2", (Object)config.getString("section1.var1"));
    }

    @Test
    public void testGetSectionMerged() throws ConfigurationException {
        String data = INI_DATA + "[section1]" + LINE_SEPARATOR + "var3 = merged" + LINE_SEPARATOR;
        INIConfiguration config = TestINIConfiguration.setUpConfig(data);
        SubnodeConfiguration section = config.getSection("section1");
        Assert.assertEquals((String)"Wrong value of var1", (Object)"foo", (Object)section.getString("var1"));
        Assert.assertEquals((String)"Wrong value of var2", (Object)"451", (Object)section.getString("var2"));
        Assert.assertEquals((String)"Wrong value of var3", (Object)"merged", (Object)section.getString("var3"));
    }

    @Test
    public void testGetSectionGlobal() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration section = config.getSection(null);
        Assert.assertEquals((String)"Wrong value of global variable", (Object)"testGlobal", (Object)section.getString("globalVar"));
    }

    @Test
    public void testGetSectionGloabalMultiThreaded() throws ConfigurationException, InterruptedException {
        int i;
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        config.setSynchronizer((Synchronizer)new ReadWriteSynchronizer());
        int threadCount = 10;
        GlobalSectionTestThread[] threads = new GlobalSectionTestThread[10];
        for (i = 0; i < 10; ++i) {
            threads[i] = new GlobalSectionTestThread(config);
            threads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            threads[i].join();
            Assert.assertFalse((String)"Exception occurred", (boolean)threads[i].error);
        }
    }

    @Test
    public void testGetSectionGlobalNonExisting() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA);
        SubnodeConfiguration section = config.getSection(null);
        Assert.assertTrue((String)"Sub config not empty", (boolean)section.isEmpty());
    }

    @Test
    public void testGetSectionNonExisting() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA);
        SubnodeConfiguration section = config.getSection("Non existing section");
        Assert.assertTrue((String)"Sub config not empty", (boolean)section.isEmpty());
    }

    @Test
    public void testLineContinuation() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA3);
        Assert.assertEquals((String)"Wrong value", (Object)("one" + LINE_SEPARATOR + "two" + LINE_SEPARATOR + "three"), (Object)config.getString("section5.multiLine"));
    }

    @Test
    public void testLineContinuationNone() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA3);
        Assert.assertEquals((String)"Wrong value", (Object)"C:\\Temp\\", (Object)config.getString("section5.singleLine"));
    }

    @Test
    public void testLineContinuationQuoted() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA3);
        Assert.assertEquals((String)"Wrong value", (Object)("one" + LINE_SEPARATOR + "  two  " + LINE_SEPARATOR + "three"), (Object)config.getString("section5.multiQuoted"));
    }

    @Test
    public void testLineContinuationComment() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA3);
        Assert.assertEquals((String)"Wrong value", (Object)("one" + LINE_SEPARATOR + "two"), (Object)config.getString("section5.multiComment"));
    }

    @Test
    public void testLineContinuationQuotedComment() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA3);
        Assert.assertEquals((String)"Wrong value", (Object)(" one " + LINE_SEPARATOR + "two"), (Object)config.getString("section5.multiQuotedComment"));
    }

    @Test
    public void testLineContinuationEmptyLine() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA3);
        Assert.assertEquals((String)"Wrong value", (Object)(LINE_SEPARATOR + "line 2"), (Object)config.getString("section5.noFirstLine"));
    }

    @Test
    public void testLineContinuationAtEnd() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA3);
        Assert.assertEquals((String)"Wrong value", (Object)("one" + LINE_SEPARATOR), (Object)config.getString("section5.continueNoLine"));
    }

    @Test
    public void testSaveKeysWithDelimiters() throws ConfigurationException, IOException {
        INIConfiguration conf = new INIConfiguration();
        String section = "Section..with..dots";
        conf.addProperty("Section..with..dots.test1", (Object)"test1");
        conf.addProperty("Section..with..dots.test2", (Object)"test2");
        StringWriter writer = new StringWriter();
        conf.write((Writer)writer);
        conf = new INIConfiguration();
        conf.read((Reader)new StringReader(writer.toString()));
        Assert.assertEquals((String)"Wrong value (1)", (Object)"test1", (Object)conf.getString("Section..with..dots.test1"));
        Assert.assertEquals((String)"Wrong value (2)", (Object)"test2", (Object)conf.getString("Section..with..dots.test2"));
    }

    @Test
    public void testPropertyWithDelimiter() throws ConfigurationException {
        String data = INI_DATA + "key.dot = dotValue";
        INIConfiguration conf = new INIConfiguration();
        TestINIConfiguration.load(conf, data);
        Assert.assertEquals((String)"Wrong property value", (Object)"dotValue", (Object)conf.getString("section3.key..dot"));
        String output = TestINIConfiguration.saveToString(conf);
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"key.dot = dotValue"));
    }

    @Test
    public void testValueWithSemicolon() throws ConfigurationException {
        String path = "C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar";
        String content = "[Environment]" + LINE_SEPARATOR + "Application Type=any" + LINE_SEPARATOR + "Class Path=" + "C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar" + "  ;comment" + LINE_SEPARATOR + "Path=" + "C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar" + "\t; another comment";
        INIConfiguration config = TestINIConfiguration.setUpConfig(content);
        Assert.assertEquals((String)"Wrong class path", (Object)"C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar", (Object)config.getString("Environment.Class Path"));
        Assert.assertEquals((String)"Wrong path", (Object)"C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar", (Object)config.getString("Environment.Path"));
    }

    @Test
    public void testSeparators() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_SEPARATORS);
        for (int i = 1; i <= 4; ++i) {
            Assert.assertEquals((String)"Wrong value", (Object)("value" + i), (Object)config.getString("section.var" + i));
        }
    }

    @Test
    public void testMultipleSeparators() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_SEPARATORS);
        Assert.assertEquals((String)"Wrong value for var5", (Object)"value=5", (Object)config.getString("section.var5"));
        Assert.assertEquals((String)"Wrong value for var6", (Object)"6=value", (Object)config.getString("section.var"));
    }

    @Test
    public void testMultipleSeparatorsQuoted() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_SEPARATORS);
        Assert.assertEquals((String)"Wrong value for var7", (Object)"value7", (Object)config.getString("section.var:7"));
        Assert.assertEquals((String)"Wrong value for var8", (Object)"value8", (Object)config.getString("section.var:8"));
    }

    @Test
    public void testSaveClearedSection() throws ConfigurationException, IOException {
        String data = "[section]\ntest = failed\n";
        INIConfiguration config = TestINIConfiguration.setUpConfig("[section]\ntest = failed\n");
        SubnodeConfiguration sub = config.getSection("section");
        Assert.assertFalse((String)"No content", (boolean)sub.isEmpty());
        sub.clear();
        sub.close();
        sub = config.getSection("section");
        sub.setProperty("test", (Object)"success");
        StringWriter writer = new StringWriter();
        config.write((Writer)writer);
        INIConfiguration config2 = TestINIConfiguration.setUpConfig(writer.toString());
        Assert.assertEquals((String)"Wrong value", (Object)"success", (Object)config2.getString("section.test"));
    }

    @Test
    public void testMergeDuplicateSection() throws ConfigurationException, IOException {
        String data = "[section]\nvar1 = sec1\n\n[section]\nvar2 = sec2\n";
        INIConfiguration config = TestINIConfiguration.setUpConfig("[section]\nvar1 = sec1\n\n[section]\nvar2 = sec2\n");
        Assert.assertEquals((String)"Wrong value 1", (Object)"sec1", (Object)config.getString("section.var1"));
        Assert.assertEquals((String)"Wrong value 2", (Object)"sec2", (Object)config.getString("section.var2"));
        SubnodeConfiguration sub = config.getSection("section");
        Assert.assertEquals((String)"Wrong sub value 1", (Object)"sec1", (Object)sub.getString("var1"));
        Assert.assertEquals((String)"Wrong sub value 2", (Object)"sec2", (Object)sub.getString("var2"));
        StringWriter writer = new StringWriter();
        config.write((Writer)writer);
        String content = writer.toString();
        int pos = content.indexOf("[section]");
        Assert.assertTrue((String)("Section not found: " + content), (pos >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Section found multiple times: " + content), (content.indexOf("[section]", pos + 1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetSectionNonExistingManipulate() throws ConfigurationException, IOException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA);
        SubnodeConfiguration section = config.getSection("newSection");
        section.addProperty("test", (Object)"success");
        Assert.assertEquals((String)"Main config not updated", (Object)"success", (Object)config.getString("newSection.test"));
        StringWriter writer = new StringWriter();
        config.write((Writer)writer);
        INIConfiguration config2 = TestINIConfiguration.setUpConfig(writer.toString());
        section = config2.getSection("newSection");
        Assert.assertEquals((String)"Wrong value", (Object)"success", (Object)section.getString("test"));
    }

    @Test
    public void testGetSectionDuplicate() {
        INIConfiguration config = new INIConfiguration();
        config.addProperty("section.var1", (Object)"value1");
        config.addProperty("section(-1).var2", (Object)"value2");
        SubnodeConfiguration section = config.getSection("section");
        Iterator keys = section.getKeys();
        Assert.assertEquals((String)"Wrong key", (Object)"var1", keys.next());
        Assert.assertFalse((String)"Too many keys", (boolean)keys.hasNext());
    }

    @Test
    public void testValueWithDelimiters() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig("[test]" + LINE_SEPARATOR + "list=1,2,3" + LINE_SEPARATOR);
        List list = config.getList("test.list");
        Assert.assertEquals((String)"Wrong number of elements", (long)3L, (long)list.size());
        Assert.assertEquals((String)"Wrong element at 1", (Object)"1", list.get(0));
        Assert.assertEquals((String)"Wrong element at 2", (Object)"2", list.get(1));
        Assert.assertEquals((String)"Wrong element at 3", (Object)"3", list.get(2));
    }

    @Test
    public void testListParsingDisabled() throws ConfigurationException {
        INIConfiguration config = new INIConfiguration();
        TestINIConfiguration.load(config, "[test]" + LINE_SEPARATOR + "nolist=1,2,3");
        Assert.assertEquals((String)"Wrong value", (Object)"1,2,3", (Object)config.getString("test.nolist"));
    }

    @Test
    public void testGetSectionsSynchronized() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA);
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        config.setSynchronizer((Synchronizer)sync);
        Assert.assertFalse((String)"No sections", (boolean)config.getSections().isEmpty());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testListDelimiterHandling() throws ConfigurationException {
        INIConfiguration config = new INIConfiguration();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        config.addProperty("list", (Object)"a,b,c");
        config.addProperty("listesc", (Object)"3\\,1415");
        String output = TestINIConfiguration.saveToString(config);
        INIConfiguration config2 = TestINIConfiguration.setUpConfig(output);
        Assert.assertEquals((String)"Wrong list size", (long)3L, (long)config2.getList("list").size());
        Assert.assertEquals((String)"Wrong list element", (Object)"b", config2.getList("list").get(1));
        Assert.assertEquals((String)"Wrong escaped list element", (Object)"3,1415", (Object)config2.getString("listesc"));
    }

    @Test
    public void testListDelimiterHandlingInList() throws ConfigurationException {
        String data = INI_DATA + "[sectest]" + LINE_SEPARATOR + "list = 3\\,1415,pi,\\\\Test\\,5" + LINE_SEPARATOR;
        INIConfiguration config = TestINIConfiguration.setUpConfig(data);
        INIConfiguration config2 = TestINIConfiguration.setUpConfig(TestINIConfiguration.saveToString(config));
        List list = config2.getList("sectest.list");
        Assert.assertEquals((String)"Wrong number of values", (long)3L, (long)list.size());
        Assert.assertEquals((String)"Wrong element 1", (Object)"3,1415", list.get(0));
        Assert.assertEquals((String)"Wrong element 3", (Object)"\\Test,5", list.get(2));
    }

    @Test
    public void testKeysOfGlobalSection() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration sub = config.getSection(null);
        Iterator keys = sub.getKeys();
        Assert.assertEquals((String)"Wrong key", (Object)"globalVar", keys.next());
        if (keys.hasNext()) {
            StringBuilder buf = new StringBuilder();
            do {
                buf.append((String)keys.next()).append(' ');
            } while (keys.hasNext());
            Assert.fail((String)("Got additional keys: " + buf));
        }
    }

    @Test
    public void testGlobalSectionNodeHandlerGetChildrenByName() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration sub = config.getSection(null);
        NodeHandler handler = sub.getModel().getNodeHandler();
        Assert.assertTrue((String)"Sections not filtered", (boolean)handler.getChildren(sub.getModel().getNodeHandler().getRootNode(), "section1").isEmpty());
    }

    @Test
    public void testGlobalSectionNodeHandlerGetChildrenCount() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration sub = config.getSection(null);
        NodeHandler handler = sub.getModel().getNodeHandler();
        Assert.assertEquals((String)"Wrong number of children", (long)1L, (long)handler.getChildrenCount(handler.getRootNode(), null));
    }

    @Test
    public void testGlobalSectionNodeHandlerGetChildByIndex() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration sub = config.getSection(null);
        NodeHandler handler = sub.getModel().getNodeHandler();
        ImmutableNode child = (ImmutableNode)handler.getChild(handler.getRootNode(), 0);
        Assert.assertEquals((String)"Wrong child", (Object)"globalVar", (Object)child.getNodeName());
        try {
            handler.getChild(handler.getRootNode(), 1);
            Assert.fail((String)"Could obtain child with invalid index!");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testGlobalSectionNodeHandlerIndexOfChild() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration sub = config.getSection(null);
        NodeHandler handler = sub.getModel().getNodeHandler();
        List children = ((ImmutableNode)handler.getRootNode()).getChildren();
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)handler.indexOfChild(handler.getRootNode(), children.get(0)));
        Assert.assertEquals((String)"Wrong index of section child", (long)-1L, (long)handler.indexOfChild(handler.getRootNode(), children.get(1)));
    }

    @Test
    public void testExpressionEngineIgnoringCase() throws ConfigurationException {
        DefaultExpressionEngine engine = new DefaultExpressionEngine(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS, (NodeMatcher)NodeNameMatchers.EQUALS_IGNORE_CASE);
        INIConfiguration config = new INIConfiguration();
        config.setExpressionEngine((ExpressionEngine)engine);
        TestINIConfiguration.load(config, INI_DATA);
        this.checkContent(config);
        Assert.assertEquals((String)"Wrong result (1)", (Object)"foo", (Object)config.getString("Section1.var1"));
        Assert.assertEquals((String)"Wrong result (2)", (Object)"foo", (Object)config.getString("section1.Var1"));
        Assert.assertEquals((String)"Wrong result (1)", (Object)"foo", (Object)config.getString("SECTION1.VAR1"));
    }

    @Test
    public void testWriteEmptySection() throws ConfigurationException, IOException {
        String section = "[EmptySection]";
        INIConfiguration config = TestINIConfiguration.setUpConfig("[EmptySection]");
        Assert.assertEquals((String)"Wrong number of sections", (long)1L, (long)config.getSections().size());
        Assert.assertTrue((String)"Section not found", (boolean)config.getSections().contains("EmptySection"));
        StringWriter writer = new StringWriter();
        config.write((Writer)writer);
        Assert.assertEquals((String)"Wrong saved configuration", (Object)("[EmptySection]" + LINE_SEPARATOR + LINE_SEPARATOR), (Object)writer.toString());
    }

    private static class GlobalSectionTestThread
    extends Thread {
        private final INIConfiguration config;
        volatile boolean error;

        public GlobalSectionTestThread(INIConfiguration conf) {
            this.config = conf;
        }

        @Override
        public void run() {
            int loopCount = 250;
            for (int i = 0; i < 250 && !this.error; ++i) {
                try {
                    this.config.getSection(null);
                    continue;
                }
                catch (IllegalStateException istex) {
                    this.error = true;
                }
            }
        }
    }
}

