/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import java.util.List;
import java.util.Locale;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.xpath.AbstractXPathTest;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodeIteratorChildren;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.compiler.ProcessingInstructionTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationNodeIteratorChildren
extends AbstractXPathTest {
    private static final String PREFIX = "commons";
    private static final String PREFIX_NODE = "configuration";
    private ConfigurationNodePointer<ImmutableNode> rootPointer;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rootPointer = this.createPointer(this.root);
    }

    private ConfigurationNodePointer<ImmutableNode> createPointer(ImmutableNode node) {
        return new ConfigurationNodePointer((Object)node, Locale.getDefault(), this.handler);
    }

    @Test
    public void testIterateAllChildren() {
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, null, false, null);
        Assert.assertEquals((String)"Wrong number of elements", (long)5L, (long)this.iteratorSize((NodeIterator)it));
        this.checkValues((NodeIterator)it, 1, 2, 3, 4, 5);
    }

    @Test
    public void testIterateReverse() {
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, null, true, null);
        Assert.assertEquals((String)"Wrong number of elements", (long)5L, (long)this.iteratorSize((NodeIterator)it));
        this.checkValues((NodeIterator)it, 5, 4, 3, 2, 1);
    }

    @Test
    public void testIterateWithWildcardTest() {
        NodeNameTest test = new NodeNameTest(new QName(null, "*"));
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, (NodeTest)test, false, null);
        Assert.assertEquals((String)"Wrong number of elements", (long)5L, (long)this.iteratorSize((NodeIterator)it));
    }

    @Test
    public void testIterateWithPrefixTest() {
        NodeNameTest test = new NodeNameTest(new QName("prefix", "*"));
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, (NodeTest)test, false, null);
        Assert.assertNull((String)"Undefined node pointer not returned", (Object)it.getNodePointer());
        Assert.assertEquals((String)"Prefix was not evaluated", (long)0L, (long)this.iteratorSize((NodeIterator)it));
    }

    @Test
    public void testIterateWithNameTest() {
        NodeNameTest test = new NodeNameTest(new QName(null, "childNode"));
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, (NodeTest)test, false, null);
        Assert.assertTrue((String)"No children found", (this.iteratorSize((NodeIterator)it) > 0 ? 1 : 0) != 0);
        for (NodePointer nd : this.iterationElements((NodeIterator)it)) {
            Assert.assertEquals((String)"Wrong child element", (Object)"childNode", (Object)nd.getName().getName());
        }
    }

    @Test
    public void testIterateWithUnknownTest() {
        ProcessingInstructionTest test = new ProcessingInstructionTest("test");
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, (NodeTest)test, false, null);
        Assert.assertEquals((String)"Unknown test was not evaluated", (long)0L, (long)this.iteratorSize((NodeIterator)it));
    }

    @Test
    public void testIterateWithNodeType() {
        NodeTypeTest test = new NodeTypeTest(1);
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, (NodeTest)test, false, null);
        Assert.assertEquals((String)"Node type not evaluated", (long)5L, (long)this.iteratorSize((NodeIterator)it));
    }

    @Test
    public void testIterateWithUnknownType() {
        NodeTypeTest test = new NodeTypeTest(3);
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, (NodeTest)test, false, null);
        Assert.assertEquals((String)"Unknown node type not evaluated", (long)0L, (long)this.iteratorSize((NodeIterator)it));
    }

    @Test
    public void testIterateStartsWith() {
        ConfigurationNodePointer childPointer = new ConfigurationNodePointer(this.rootPointer, this.root.getChildren().get(2), this.handler);
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, null, false, childPointer);
        Assert.assertEquals((String)"Wrong start position", (long)0L, (long)it.getPosition());
        List<NodePointer> nodes = this.iterationElements((NodeIterator)it);
        Assert.assertEquals((String)"Wrong size of iteration", (long)2L, (long)nodes.size());
        int index = 4;
        for (NodePointer np : nodes) {
            ImmutableNode node = (ImmutableNode)np.getImmediateNode();
            Assert.assertEquals((String)"Wrong node value", (Object)String.valueOf(index), (Object)node.getValue());
            ++index;
        }
    }

    @Test
    public void testIterateStartsWithReverse() {
        ConfigurationNodePointer childPointer = new ConfigurationNodePointer(this.rootPointer, this.root.getChildren().get(3), this.handler);
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, null, true, childPointer);
        int value = 3;
        int index = 1;
        while (it.setPosition(index)) {
            ImmutableNode node = (ImmutableNode)it.getNodePointer().getNode();
            Assert.assertEquals((String)("Incorrect value at index " + index), (Object)String.valueOf(value), (Object)node.getValue());
            ++index;
            --value;
        }
        Assert.assertEquals((String)"Iteration ended not at end node", (long)0L, (long)value);
    }

    @Test
    public void testIterateStartsWithInvalid() {
        ConfigurationNodePointer childPointer = new ConfigurationNodePointer(this.rootPointer, (Object)new ImmutableNode.Builder().name("newNode").create(), this.handler);
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.rootPointer, null, false, childPointer);
        Assert.assertEquals((String)"Wrong size of iteration", (long)5L, (long)this.iteratorSize((NodeIterator)it));
        it.setPosition(1);
        ImmutableNode node = (ImmutableNode)it.getNodePointer().getNode();
        Assert.assertEquals((String)"Wrong start node", (Object)"1", (Object)node.getValue());
    }

    private ConfigurationNodePointer<ImmutableNode> createPointerWithNamespace() {
        ImmutableNode node = new ImmutableNode.Builder(2).addChild(this.root).addChild(NodeStructureHelper.createNode("commons:configuration", "test")).create();
        return this.createPointer(node);
    }

    @Test
    public void testIterateWithWildcardTestPrefix() {
        NodeNameTest test = new NodeNameTest(new QName(PREFIX, "*"));
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.createPointerWithNamespace(), (NodeTest)test, false, null);
        Assert.assertEquals((String)"Wrong number of elements", (long)1L, (long)this.iteratorSize((NodeIterator)it));
        for (NodePointer p : this.iterationElements((NodeIterator)it)) {
            Assert.assertEquals((String)"Wrong element", (Object)"commons:configuration", (Object)p.getName().getName());
        }
    }

    @Test
    public void testIterateWithMatchingPrefixTest() {
        NodeNameTest test = new NodeNameTest(new QName(PREFIX, PREFIX_NODE));
        ConfigurationNodeIteratorChildren it = new ConfigurationNodeIteratorChildren(this.createPointerWithNamespace(), (NodeTest)test, false, null);
        Assert.assertEquals((String)"Wrong number of elements", (long)1L, (long)this.iteratorSize((NodeIterator)it));
        for (NodePointer p : this.iterationElements((NodeIterator)it)) {
            Assert.assertEquals((String)"Wrong element", (Object)"commons:configuration", (Object)p.getName().getName());
        }
    }

    private void checkValues(NodeIterator iterator, int ... expectedIndices) {
        List<NodePointer> nodes = this.iterationElements(iterator);
        for (int i = 0; i < expectedIndices.length; ++i) {
            ImmutableNode child = (ImmutableNode)nodes.get(i).getImmediateNode();
            Assert.assertTrue((String)("Wrong index value for child " + i), (boolean)child.getValue().toString().endsWith(String.valueOf(expectedIndices[i])));
        }
    }
}

