/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.spring;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.spring.ConfigurationPropertySource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration
public class TestConfigurationPropertySource {
    private static final String TEST_PROPERTY = "test.property";
    private static final String TEST_VALUE = "testVALUE";
    @Value(value="${test.property}")
    private String value;

    @Test
    public void testValueInjection() {
        Assert.assertEquals((Object)TEST_VALUE, (Object)this.value);
    }

    private static ConfigurationPropertySource createConfigPropertySource() {
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
        propertiesConfiguration.addProperty(TEST_PROPERTY, (Object)TEST_VALUE);
        return new ConfigurationPropertySource("test configuration", (Configuration)propertiesConfiguration);
    }

    @org.springframework.context.annotation.Configuration
    static class Config {
        Config() {
        }

        @Bean
        public PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer(ConfigurableEnvironment env) {
            PropertySourcesPlaceholderConfigurer configurer = new PropertySourcesPlaceholderConfigurer();
            MutablePropertySources sources = new MutablePropertySources();
            sources.addLast((PropertySource)TestConfigurationPropertySource.createConfigPropertySource());
            configurer.setPropertySources((PropertySources)sources);
            configurer.setEnvironment((Environment)env);
            return configurer;
        }
    }
}

