/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.io.CombinedLocationStrategy;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCombinedLocationStrategy {
    private static FileLocator locator;
    private static URL locateURL;
    private FileSystem fileSystem;
    private FileLocationStrategy[] subStrategies;

    @BeforeClass
    public static void setUpOnce() throws Exception {
        locator = FileLocatorUtils.fileLocator().fileName("testFile.tst").create();
        locateURL = ConfigurationAssert.getTestURL("test.xml");
    }

    private FileSystem getFileSystem() {
        if (this.fileSystem == null) {
            this.fileSystem = (FileSystem)EasyMock.createMock(FileSystem.class);
            EasyMock.replay((Object[])new Object[]{this.fileSystem});
        }
        return this.fileSystem;
    }

    private FileLocationStrategy[] getSubStrategies() {
        if (this.subStrategies == null) {
            this.subStrategies = new FileLocationStrategy[2];
            for (int i = 0; i < this.subStrategies.length; ++i) {
                this.subStrategies[i] = (FileLocationStrategy)EasyMock.createMock(FileLocationStrategy.class);
            }
        }
        return this.subStrategies;
    }

    private void replaySubStrategies() {
        EasyMock.replay((Object[])this.getSubStrategies());
    }

    private void verifySubStrategies() {
        EasyMock.verify((Object[])this.getSubStrategies());
    }

    private void checkSubStrategies(CombinedLocationStrategy strategy) {
        Collection subs = strategy.getSubStrategies();
        Assert.assertEquals((String)"Wrong number of strategies", (long)this.getSubStrategies().length, (long)subs.size());
        int idx = 0;
        for (FileLocationStrategy strat : subs) {
            Assert.assertEquals((String)("Wrong sub strategy at " + idx), (Object)this.getSubStrategies()[idx++], (Object)strat);
        }
    }

    private CombinedLocationStrategy createCombinedStrategy() {
        return new CombinedLocationStrategy(Arrays.asList(this.getSubStrategies()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNullCollection() {
        new CombinedLocationStrategy(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitCollectionWithNullEntries() {
        LinkedList<FileLocationStrategy> col = new LinkedList<FileLocationStrategy>(Arrays.asList(this.getSubStrategies()));
        col.add(null);
        new CombinedLocationStrategy(col);
    }

    @Test
    public void testInitDefensiveCopy() {
        LinkedList<FileLocationStrategy> col = new LinkedList<FileLocationStrategy>(Arrays.asList(this.getSubStrategies()));
        CombinedLocationStrategy strategy = new CombinedLocationStrategy(col);
        col.add((FileLocationStrategy)EasyMock.createMock(FileLocationStrategy.class));
        this.checkSubStrategies(strategy);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetSubStrategiesModify() {
        CombinedLocationStrategy strategy = this.createCombinedStrategy();
        strategy.getSubStrategies().clear();
    }

    @Test
    public void testLocateSuccessFirstSubStrategy() {
        EasyMock.expect((Object)this.getSubStrategies()[0].locate(this.getFileSystem(), locator)).andReturn((Object)locateURL);
        this.replaySubStrategies();
        CombinedLocationStrategy strategy = this.createCombinedStrategy();
        Assert.assertSame((String)"Wrong result", (Object)locateURL, (Object)strategy.locate(this.getFileSystem(), locator));
        this.verifySubStrategies();
    }

    @Test
    public void testLocateSuccessSecondSubStrategy() {
        EasyMock.expect((Object)this.getSubStrategies()[0].locate(this.getFileSystem(), locator)).andReturn(null);
        EasyMock.expect((Object)this.getSubStrategies()[1].locate(this.getFileSystem(), locator)).andReturn((Object)locateURL);
        this.replaySubStrategies();
        CombinedLocationStrategy strategy = this.createCombinedStrategy();
        Assert.assertSame((String)"Wrong result", (Object)locateURL, (Object)strategy.locate(this.getFileSystem(), locator));
        this.verifySubStrategies();
    }

    @Test
    public void testLocateFailed() {
        EasyMock.expect((Object)this.getSubStrategies()[0].locate(this.getFileSystem(), locator)).andReturn(null);
        EasyMock.expect((Object)this.getSubStrategies()[1].locate(this.getFileSystem(), locator)).andReturn(null);
        this.replaySubStrategies();
        CombinedLocationStrategy strategy = this.createCombinedStrategy();
        Assert.assertNull((String)"Got a URL", (Object)strategy.locate(this.getFileSystem(), locator));
        this.verifySubStrategies();
    }
}

