/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.convert;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ValueTransformer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultListDelimiterHandler {
    private DefaultListDelimiterHandler handler;

    @Before
    public void setUp() throws Exception {
        this.handler = new DefaultListDelimiterHandler(',');
    }

    @Test
    public void testEscapeStringNoSpecialCharacter() {
        Assert.assertEquals((String)"Wrong result", (Object)"test", (Object)this.handler.escapeString("test"));
    }

    @Test
    public void testEscapeStringListDelimiter() {
        Assert.assertEquals((String)"Wrong result", (Object)"3\\,1415", (Object)this.handler.escapeString("3,1415"));
    }

    @Test
    public void testEscapeStringBackslash() {
        Assert.assertEquals((String)"Wrong result", (Object)"C:\\\\Temp\\\\", (Object)this.handler.escapeString("C:\\Temp\\"));
    }

    @Test
    public void testEscapeStringListDelimiterAndBackslash() {
        Assert.assertEquals((String)"Wrong result", (Object)"C:\\\\Temp\\\\\\,\\\\\\\\Share\\,/root", (Object)this.handler.escapeString("C:\\Temp\\,\\\\Share,/root"));
    }

    @Test
    public void testEscapeWithTransformer() {
        ValueTransformer trans = (ValueTransformer)EasyMock.createMock(ValueTransformer.class);
        EasyMock.expect((Object)trans.transformValue((Object)"a\\,b")).andReturn((Object)"ok");
        EasyMock.replay((Object[])new Object[]{trans});
        Assert.assertEquals((String)"Wrong result", (Object)"ok", (Object)this.handler.escape((Object)"a,b", trans));
        EasyMock.verify((Object[])new Object[]{trans});
    }

    @Test
    public void testEscapeList() {
        ValueTransformer trans = value -> String.valueOf(value) + "_trans";
        List<String> data = Arrays.asList("simple", "Hello,world!", "\\,\\", "end");
        Assert.assertEquals((String)"Wrong result", (Object)"simple_trans,Hello\\,world!_trans,\\\\\\,\\\\_trans,end_trans", (Object)this.handler.escapeList(data, trans));
    }

    private void checkSplit(String value, boolean trim, String ... expectedElements) {
        Collection elems = this.handler.split(value, trim);
        Assert.assertEquals((String)"Wrong number of elements", (long)expectedElements.length, (long)elems.size());
        int idx = 0;
        for (String elem : elems) {
            Assert.assertEquals((String)("Wrong value at " + idx), (Object)expectedElements[idx++], (Object)elem);
        }
    }

    @Test
    public void testSplitSingleElement() {
        this.checkSplit("test", true, "test");
    }

    @Test
    public void testSplitList() {
        this.checkSplit("a, b,c   ,   d", true, "a", "b", "c", "d");
    }

    @Test
    public void testSplitNoTrim() {
        this.checkSplit("a , b,  c  ,d", false, "a ", " b", "  c  ", "d");
    }

    @Test
    public void testSplitEscapeLineDelimiter() {
        this.checkSplit("3\\,1415", true, "3,1415");
    }

    @Test
    public void testSplitEscapeBackslash() {
        this.checkSplit("C:\\\\Temp\\\\", true, "C:\\Temp\\");
    }

    @Test
    public void testSplitEscapeListDelimiterAndBackslashes() {
        this.checkSplit("C:\\\\Temp\\\\\\,\\\\\\\\Share\\\\,/root", false, "C:\\Temp\\,\\\\Share\\", "/root");
    }

    @Test
    public void testSplitUnexpectedEscape() {
        this.checkSplit("\\x, \\,y, \\", true, "\\x", ",y", "\\");
    }
}

