/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.XMLBuilderParametersImpl;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.EntityResolver;

public class TestXMLBuilderParametersImpl {
    private XMLBuilderParametersImpl params;

    @Before
    public void setUp() throws Exception {
        this.params = new XMLBuilderParametersImpl();
    }

    @Test
    public void testSetEntityResolver() {
        EntityResolver resolver = (EntityResolver)EasyMock.createMock(EntityResolver.class);
        EasyMock.replay((Object[])new Object[]{resolver});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setEntityResolver(resolver));
        Assert.assertSame((String)"Resolver not set", (Object)resolver, (Object)this.params.getEntityResolver());
        Assert.assertSame((String)"Resolver not in parameters", (Object)resolver, this.params.getParameters().get("entityResolver"));
    }

    @Test
    public void testSetDocumentBuilder() {
        DocumentBuilder builder = (DocumentBuilder)EasyMock.createMock(DocumentBuilder.class);
        EasyMock.replay((Object[])new Object[]{builder});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setDocumentBuilder(builder));
        Assert.assertSame((String)"Builder not in parameters", (Object)builder, this.params.getParameters().get("documentBuilder"));
    }

    @Test
    public void testSetPublicID() {
        String pubID = "testPublicID";
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setPublicID("testPublicID"));
        Assert.assertEquals((String)"ID not in parameters", (Object)"testPublicID", this.params.getParameters().get("publicID"));
    }

    @Test
    public void testSetSystemID() {
        String sysID = "testSystemID";
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setSystemID("testSystemID"));
        Assert.assertEquals((String)"ID not in parameters", (Object)"testSystemID", this.params.getParameters().get("systemID"));
    }

    @Test
    public void testSetValidating() {
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setValidating(true));
        Assert.assertEquals((String)"Flag not in parameters", (Object)Boolean.TRUE, this.params.getParameters().get("validating"));
    }

    @Test
    public void testSetSchemaValidation() {
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setSchemaValidation(false));
        Assert.assertEquals((String)"Flag not in parameters", (Object)Boolean.FALSE, this.params.getParameters().get("schemaValidation"));
    }

    @Test
    public void testBeanPropertiesAccess() throws Exception {
        EntityResolver resolver = (EntityResolver)EasyMock.createMock(EntityResolver.class);
        DocumentBuilder builder = (DocumentBuilder)EasyMock.createMock(DocumentBuilder.class);
        EasyMock.replay((Object[])new Object[]{resolver, builder});
        BeanHelper.setProperty((Object)this.params, (String)"throwExceptionOnMissing", (Object)Boolean.TRUE);
        BeanHelper.setProperty((Object)this.params, (String)"fileName", (Object)"test.xml");
        BeanHelper.setProperty((Object)this.params, (String)"entityResolver", (Object)resolver);
        BeanHelper.setProperty((Object)this.params, (String)"documentBuilder", (Object)builder);
        Assert.assertEquals((String)"Wrong file name", (Object)"test.xml", (Object)this.params.getFileHandler().getFileName());
        Map paramsMap = this.params.getParameters();
        Assert.assertEquals((String)"Wrong exception flag", (Object)Boolean.TRUE, paramsMap.get("throwExceptionOnMissing"));
        Assert.assertSame((String)"Wrong resolver", (Object)resolver, paramsMap.get("entityResolver"));
        Assert.assertSame((String)"Wrong builder", (Object)builder, paramsMap.get("documentBuilder"));
    }

    @Test
    public void testInheritFrom() {
        EntityResolver resolver = (EntityResolver)EasyMock.createMock(EntityResolver.class);
        DocumentBuilder builder = (DocumentBuilder)EasyMock.createMock(DocumentBuilder.class);
        this.params.setDocumentBuilder(builder).setEntityResolver(resolver).setSchemaValidation(true).setValidating(true);
        this.params.setThrowExceptionOnMissing(true);
        XMLBuilderParametersImpl params2 = new XMLBuilderParametersImpl();
        params2.inheritFrom(this.params.getParameters());
        Map parameters = params2.getParameters();
        Assert.assertEquals((String)"Exception flag not set", (Object)Boolean.TRUE, parameters.get("throwExceptionOnMissing"));
        Assert.assertEquals((String)"Entity resolver not set", (Object)resolver, parameters.get("entityResolver"));
        Assert.assertEquals((String)"Document builder not set", (Object)builder, parameters.get("documentBuilder"));
        Assert.assertEquals((String)"Validation flag not set", (Object)Boolean.TRUE, parameters.get("validating"));
        Assert.assertEquals((String)"Schema flag not set", (Object)Boolean.TRUE, parameters.get("schemaValidation"));
    }
}

