/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.resolver.CatalogResolver;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestXMLConfiguration {
    private static final String CATALOG_FILES = ConfigurationAssert.getTestFile("catalog.xml").getAbsolutePath();
    static final String ENCODING = "ISO-8859-1";
    static final String SYSTEM_ID = "properties.dtd";
    static final String PUBLIC_ID = "-//Commons Configuration//DTD Test Configuration 1.3//EN";
    static final String DOCTYPE_DECL = " PUBLIC \"-//Commons Configuration//DTD Test Configuration 1.3//EN\" \"properties.dtd\">";
    static final String DOCTYPE = "<!DOCTYPE ";
    static final String PROP_FACTORY = "javax.xml.transform.TransformerFactory";
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private final String testProperties = ConfigurationAssert.getTestFile("test.xml").getAbsolutePath();
    private final String testProperties2 = ConfigurationAssert.getTestFile("testDigesterConfigurationInclude1.xml").getAbsolutePath();
    private File testSaveConf;
    private File testSaveFile;
    private final String testFile2 = ConfigurationAssert.getTestFile("sample.xml").getAbsolutePath();
    private static final int THREAD_COUNT = 5;
    private static final int LOOP_COUNT = 100;
    private XMLConfiguration conf;

    @Before
    public void setUp() throws Exception {
        this.testSaveConf = this.folder.newFile("testsave.xml");
        this.testSaveFile = this.folder.newFile("testsample2.xml");
        this.conf = TestXMLConfiguration.createFromFile(this.testProperties);
        this.removeTestFile();
    }

    private static void load(XMLConfiguration config, String fileName) throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)config);
        handler.setFileName(fileName);
        handler.load();
    }

    private static XMLConfiguration createFromFile(String fileName) throws ConfigurationException {
        XMLConfiguration config = new XMLConfiguration();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        TestXMLConfiguration.load(config, fileName);
        return config;
    }

    @Test
    public void testGetProperty() {
        Assert.assertEquals((Object)"value", (Object)this.conf.getProperty("element"));
    }

    @Test
    public void testGetCommentedProperty() {
        Assert.assertEquals((Object)"", (Object)this.conf.getProperty("test.comment"));
    }

    @Test
    public void testGetPropertyWithXMLEntity() {
        Assert.assertEquals((Object)"1<2", (Object)this.conf.getProperty("test.entity"));
    }

    @Test
    public void testClearPropertyNotExisting() {
        String key = "clearly";
        this.conf.clearProperty("clearly");
        Assert.assertNull((String)"clearly", (Object)this.conf.getProperty("clearly"));
        Assert.assertNull((String)"clearly", (Object)this.conf.getProperty("clearly"));
    }

    @Test
    public void testClearPropertySingleElement() {
        String key = "clear.element";
        this.conf.clearProperty("clear.element");
        Assert.assertNull((String)"clear.element", (Object)this.conf.getProperty("clear.element"));
        Assert.assertNull((String)"clear.element", (Object)this.conf.getProperty("clear.element"));
    }

    @Test
    public void testClearPropertySingleElementWithAttribute() {
        String key = "clear.element2";
        this.conf.clearProperty(key);
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        key = "clear.element2[@id]";
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
    }

    @Test
    public void testClearPropertyNonText() {
        String key = "clear.comment";
        this.conf.clearProperty("clear.comment");
        Assert.assertNull((String)"clear.comment", (Object)this.conf.getProperty("clear.comment"));
        Assert.assertNull((String)"clear.comment", (Object)this.conf.getProperty("clear.comment"));
    }

    @Test
    public void testClearPropertyCData() {
        String key = "clear.cdata";
        this.conf.clearProperty("clear.cdata");
        Assert.assertNull((String)"clear.cdata", (Object)this.conf.getProperty("clear.cdata"));
        Assert.assertNull((String)"clear.cdata", (Object)this.conf.getProperty("clear.cdata"));
    }

    @Test
    public void testClearPropertyMultipleSiblings() {
        String key = "clear.list.item";
        this.conf.clearProperty(key);
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        key = "clear.list.item[@id]";
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
    }

    @Test
    public void testClearPropertyMultipleDisjoined() throws Exception {
        String key = "list.item";
        this.conf.clearProperty("list.item");
        Assert.assertNull((String)"list.item", (Object)this.conf.getProperty("list.item"));
        Assert.assertNull((String)"list.item", (Object)this.conf.getProperty("list.item"));
    }

    @Test
    public void testgetProperty() {
        Object property = this.conf.getProperty("clear");
        Assert.assertNull((Object)property);
        property = this.conf.getProperty("e");
        Assert.assertNull((Object)property);
        property = this.conf.getProperty("element3[@n]");
        Assert.assertNull((Object)property);
        property = this.conf.getProperty("element");
        Assert.assertNotNull((Object)property);
        Assert.assertTrue((boolean)(property instanceof String));
        Assert.assertEquals((Object)"value", (Object)property);
        property = this.conf.getProperty("element3[@name]");
        Assert.assertNotNull((Object)property);
        Assert.assertTrue((boolean)(property instanceof String));
        Assert.assertEquals((Object)"foo", (Object)property);
        property = this.conf.getProperty("test.comment");
        Assert.assertEquals((Object)"", (Object)property);
        property = this.conf.getProperty("test.cdata");
        Assert.assertNotNull((Object)property);
        Assert.assertTrue((boolean)(property instanceof String));
        Assert.assertEquals((Object)"<cdata value>", (Object)property);
        property = this.conf.getProperty("list.sublist.item");
        Assert.assertNotNull((Object)property);
        Assert.assertTrue((boolean)(property instanceof List));
        List list = (List)property;
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"five", list.get(0));
        Assert.assertEquals((Object)"six", list.get(1));
        property = this.conf.getProperty("list.item");
        Assert.assertNotNull((Object)property);
        Assert.assertTrue((boolean)(property instanceof List));
        list = (List)property;
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"one", list.get(0));
        Assert.assertEquals((Object)"two", list.get(1));
        Assert.assertEquals((Object)"three", list.get(2));
        Assert.assertEquals((Object)"four", list.get(3));
        property = this.conf.getProperty("list.item[@name]");
        Assert.assertNotNull((Object)property);
        Assert.assertTrue((boolean)(property instanceof List));
        list = (List)property;
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"one", list.get(0));
        Assert.assertEquals((Object)"three", list.get(1));
    }

    @Test
    public void testGetAttribute() {
        Assert.assertEquals((String)"element3[@name]", (Object)"foo", (Object)this.conf.getProperty("element3[@name]"));
    }

    @Test
    public void testClearAttributeNonExisting() {
        String key = "clear[@id]";
        this.conf.clearProperty("clear[@id]");
        Assert.assertNull((String)"clear[@id]", (Object)this.conf.getProperty("clear[@id]"));
        Assert.assertNull((String)"clear[@id]", (Object)this.conf.getProperty("clear[@id]"));
    }

    @Test
    public void testClearAttributeSingle() {
        String key = "clear.element2[@id]";
        this.conf.clearProperty(key);
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        key = "clear.element2";
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
    }

    @Test
    public void testClearAttributeMultipleDisjoined() throws Exception {
        String key = "clear.list.item[@id]";
        this.conf.clearProperty(key);
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        key = "clear.list.item";
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
    }

    @Test
    public void testSetAttribute() {
        this.conf.setProperty("element3[@name]", (Object)"bar");
        Assert.assertEquals((String)"element3[@name]", (Object)"bar", (Object)this.conf.getProperty("element3[@name]"));
        this.conf.setProperty("foo[@bar]", (Object)"value");
        Assert.assertEquals((String)"foo[@bar]", (Object)"value", (Object)this.conf.getProperty("foo[@bar]"));
        this.conf.setProperty("name1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)this.conf.getProperty("name1"));
    }

    @Test
    public void testOverrideAttribute() {
        this.conf.addProperty("element3[@name]", (Object)"bar");
        List list = this.conf.getList("element3[@name]");
        Assert.assertNotNull((String)"null list", (Object)list);
        Assert.assertTrue((String)"'bar' element missing", (boolean)list.contains("bar"));
        Assert.assertEquals((String)"list size", (long)1L, (long)list.size());
    }

    @Test
    public void testAddObjectAttribute() {
        this.conf.addProperty("test.boolean[@value]", (Object)Boolean.TRUE);
        Assert.assertTrue((String)"test.boolean[@value]", (boolean)this.conf.getBoolean("test.boolean[@value]"));
    }

    @Test
    public void testSetRootAttribute() throws ConfigurationException {
        this.conf.setProperty("[@test]", (Object)"true");
        Assert.assertEquals((String)"Root attribute not set", (Object)"true", (Object)this.conf.getString("[@test]"));
        this.saveTestConfig();
        XMLConfiguration checkConf = this.checkSavedConfig();
        Assert.assertTrue((String)"Attribute not found after save", (boolean)checkConf.containsKey("[@test]"));
        checkConf.setProperty("[@test]", (Object)"newValue");
        this.conf = checkConf;
        this.saveTestConfig();
        checkConf = this.checkSavedConfig();
        Assert.assertEquals((String)"Attribute not modified after save", (Object)"newValue", (Object)checkConf.getString("[@test]"));
    }

    @Test
    public void testSetRootNamespace() throws ConfigurationException {
        this.conf.addProperty("[@xmlns:foo]", (Object)"http://example.com/");
        this.conf.addProperty("foo:bar", (Object)"foobar");
        Assert.assertEquals((String)"Root attribute not set", (Object)"http://example.com/", (Object)this.conf.getString("[@xmlns:foo]"));
        this.saveTestConfig();
        XMLConfiguration checkConf = this.checkSavedConfig();
        Assert.assertTrue((String)"Attribute not found after save", (boolean)checkConf.containsKey("[@xmlns:foo]"));
        checkConf.setProperty("[@xmlns:foo]", (Object)"http://example.net/");
    }

    @Test
    public void testAddList() {
        this.conf.addProperty("test.array", (Object)"value1");
        this.conf.addProperty("test.array", (Object)"value2");
        List list = this.conf.getList("test.array");
        Assert.assertNotNull((String)"null list", (Object)list);
        Assert.assertTrue((String)"'value1' element missing", (boolean)list.contains("value1"));
        Assert.assertTrue((String)"'value2' element missing", (boolean)list.contains("value2"));
        Assert.assertEquals((String)"list size", (long)2L, (long)list.size());
    }

    @Test
    public void testGetComplexProperty() {
        Assert.assertEquals((Object)"I'm complex!", (Object)this.conf.getProperty("element2.subelement.subsubelement"));
    }

    @Test
    public void testLoadAndSaveFromFile() throws Exception {
        Assert.assertFalse((String)"File exists", (boolean)this.testSaveConf.exists());
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class, null, true);
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(this.testSaveConf)});
        this.conf = (XMLConfiguration)builder.getConfiguration();
        Assert.assertTrue((boolean)this.conf.isEmpty());
        this.conf.addProperty("test", (Object)"yes");
        builder.save();
        XMLConfiguration checkConfig = TestXMLConfiguration.createFromFile(this.testSaveConf.getAbsolutePath());
        Assert.assertEquals((Object)"yes", (Object)checkConfig.getString("test"));
    }

    @Test
    public void testLoadFromStream() throws Exception {
        String xml = "<?xml version=\"1.0\"?><config><test>1</test></config>";
        this.conf = new XMLConfiguration();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.load((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\"?><config><test>1</test></config>".getBytes()));
        Assert.assertEquals((long)1L, (long)this.conf.getInt("test"));
        this.conf = new XMLConfiguration();
        handler = new FileHandler((FileBased)this.conf);
        handler.load((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\"?><config><test>1</test></config>".getBytes()), "UTF8");
        Assert.assertEquals((long)1L, (long)this.conf.getInt("test"));
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadInvalidXML() throws Exception {
        String xml = "<?xml version=\"1.0\"?><config><test>1</rest></config>";
        this.conf = new XMLConfiguration();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.load((Reader)new StringReader("<?xml version=\"1.0\"?><config><test>1</rest></config>"));
    }

    @Test
    public void testSetProperty() throws Exception {
        this.conf.setProperty("element.string", (Object)"hello");
        Assert.assertEquals((String)"'element.string'", (Object)"hello", (Object)this.conf.getString("element.string"));
        Assert.assertEquals((String)"XML value of element.string", (Object)"hello", (Object)this.conf.getProperty("element.string"));
    }

    @Test
    public void testAddProperty() {
        XMLConfiguration config = new XMLConfiguration();
        config.addProperty("test.string", (Object)"hello");
        Assert.assertEquals((String)"'test.string'", (Object)"hello", (Object)config.getString("test.string"));
    }

    @Test
    public void testAddObjectProperty() {
        this.conf.addProperty("test.boolean", (Object)Boolean.TRUE);
        Assert.assertTrue((String)"'test.boolean'", (boolean)this.conf.getBoolean("test.boolean"));
    }

    @Test
    public void testSave() throws Exception {
        this.conf.addProperty("string", (Object)"value1");
        for (int i = 1; i < 5; ++i) {
            this.conf.addProperty("test.array", (Object)("value" + i));
        }
        this.conf.addProperty("split.list5", (Object)"a\\,b\\,c");
        this.conf.setProperty("element3", (Object)"value\\,value1\\,value2");
        this.conf.setProperty("element3[@name]", (Object)"foo\\,bar");
        this.saveTestConfig();
        this.checkSavedConfig();
    }

    @Test
    public void testSaveToURL() throws Exception {
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.save(this.testSaveConf.toURI().toURL());
        this.checkSavedConfig(this.testSaveConf);
    }

    @Test
    public void testSaveToStream() throws ConfigurationException, IOException {
        FileHandler handler = new FileHandler((FileBased)this.conf);
        try (FileOutputStream out = null;){
            out = new FileOutputStream(this.testSaveConf);
            handler.save((OutputStream)out, "UTF8");
        }
        this.checkSavedConfig(this.testSaveConf);
    }

    @Test
    public void testSaveToStreamWithEncoding() throws ConfigurationException, IOException {
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.setEncoding("UTF8");
        try (FileOutputStream out = null;){
            out = new FileOutputStream(this.testSaveConf);
            handler.save((OutputStream)out);
        }
        this.checkSavedConfig(this.testSaveConf);
    }

    @Test
    public void testAppend() throws Exception {
        TestXMLConfiguration.load(this.conf, this.testProperties2);
        Assert.assertEquals((Object)"value", (Object)this.conf.getString("element"));
        Assert.assertEquals((Object)"tasks", (Object)this.conf.getString("table.name"));
        this.saveTestConfig();
        this.conf = TestXMLConfiguration.createFromFile(this.testSaveConf.getAbsolutePath());
        Assert.assertEquals((Object)"value", (Object)this.conf.getString("element"));
        Assert.assertEquals((Object)"tasks", (Object)this.conf.getString("table.name"));
        Assert.assertEquals((Object)"application", (Object)this.conf.getString("table[@tableType]"));
    }

    @Test
    public void testSaveAttributes() throws Exception {
        this.conf.clear();
        TestXMLConfiguration.load(this.conf, this.testProperties);
        this.saveTestConfig();
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, this.testSaveConf.getAbsolutePath());
        Assert.assertEquals((Object)"foo", (Object)this.conf.getString("element3[@name]"));
    }

    @Test
    public void testComplexNames() {
        Assert.assertEquals((Object)"Name with dot", (Object)this.conf.getString("complexNames.my..elem"));
        Assert.assertEquals((Object)"Another dot", (Object)this.conf.getString("complexNames.my..elem.sub..elem"));
    }

    private DocumentBuilder createValidatingDocBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new DefaultHandler(){

            @Override
            public void error(SAXParseException ex) throws SAXException {
                throw ex;
            }
        });
        return builder;
    }

    @Test
    public void testCustomDocBuilder() throws Exception {
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, ConfigurationAssert.getTestFile("testValidateInvalid.xml").getAbsolutePath());
        Assert.assertEquals((Object)"customers", (Object)this.conf.getString("table.name"));
        Assert.assertFalse((boolean)this.conf.containsKey("table.fields.field(1).type"));
    }

    @Test(expected=ConfigurationException.class)
    public void testCustomDocBuilderValidationError() throws Exception {
        DocumentBuilder builder = this.createValidatingDocBuilder();
        this.conf = new XMLConfiguration();
        this.conf.setDocumentBuilder(builder);
        TestXMLConfiguration.load(this.conf, ConfigurationAssert.getTestFile("testValidateInvalid.xml").getAbsolutePath());
    }

    @Test
    public void testCustomDocBuilderValidationSuccess() throws Exception {
        DocumentBuilder builder = this.createValidatingDocBuilder();
        this.conf = new XMLConfiguration();
        this.conf.setDocumentBuilder(builder);
        TestXMLConfiguration.load(this.conf, ConfigurationAssert.getTestFile("testValidateValid.xml").getAbsolutePath());
        Assert.assertTrue((boolean)this.conf.containsKey("table.fields.field(1).type"));
    }

    @Test
    public void testClone() {
        Configuration c = (Configuration)this.conf.clone();
        Assert.assertTrue((boolean)(c instanceof XMLConfiguration));
        XMLConfiguration copy = (XMLConfiguration)c;
        Assert.assertNotNull((Object)this.conf.getDocument());
        Assert.assertNull((Object)copy.getDocument());
        copy.setProperty("element3", (Object)"clonedValue");
        Assert.assertEquals((Object)"value", (Object)this.conf.getString("element3"));
        this.conf.setProperty("element3[@name]", (Object)"originalFoo");
        Assert.assertEquals((Object)"foo", (Object)copy.getString("element3[@name]"));
    }

    @Test
    public void testCloneWithSave() throws ConfigurationException {
        XMLConfiguration c = (XMLConfiguration)this.conf.clone();
        c.addProperty("test.newProperty", (Object)Boolean.TRUE);
        this.conf.addProperty("test.orgProperty", (Object)Boolean.TRUE);
        new FileHandler((FileBased)c).save(this.testSaveConf);
        XMLConfiguration c2 = new XMLConfiguration();
        TestXMLConfiguration.load(c2, this.testSaveConf.getAbsolutePath());
        Assert.assertTrue((String)"New property after clone() was not saved", (boolean)c2.getBoolean("test.newProperty"));
        Assert.assertFalse((String)"Property of original config was saved", (boolean)c2.containsKey("test.orgProperty"));
    }

    @Test
    public void testSubset() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, "testHierarchicalXMLConfiguration.xml");
        this.conf.subset("tables.table(0)");
        this.saveTestConfig();
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, "testHierarchicalXMLConfiguration.xml");
        Assert.assertEquals((Object)"users", (Object)this.conf.getString("tables.table(0).name"));
    }

    @Test
    public void testSplitLists() {
        Assert.assertEquals((Object)"a,b,c", (Object)this.conf.getString("split.list3[@values]"));
        Assert.assertEquals((long)0L, (long)this.conf.getMaxIndex("split.list3[@values]"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)this.conf.getString("split.list4[@values]"));
        Assert.assertEquals((Object)"a", (Object)this.conf.getString("split.list1"));
        Assert.assertEquals((long)2L, (long)this.conf.getMaxIndex("split.list1"));
        Assert.assertEquals((Object)"a,b,c", (Object)this.conf.getString("split.list2"));
    }

    @Test
    public void testDelimiterParsingDisabled() throws ConfigurationException {
        XMLConfiguration conf2 = new XMLConfiguration();
        TestXMLConfiguration.load(conf2, this.testProperties);
        Assert.assertEquals((Object)"a,b,c", (Object)conf2.getString("split.list3[@values]"));
        Assert.assertEquals((long)0L, (long)conf2.getMaxIndex("split.list3[@values]"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)conf2.getString("split.list4[@values]"));
        Assert.assertEquals((Object)"a,b,c", (Object)conf2.getString("split.list1"));
        Assert.assertEquals((long)0L, (long)conf2.getMaxIndex("split.list1"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)conf2.getString("split.list2"));
    }

    @Test
    public void testDelimiterParsingDisabledXPath() throws ConfigurationException {
        XMLConfiguration conf2 = new XMLConfiguration();
        conf2.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        TestXMLConfiguration.load(conf2, this.testProperties);
        Assert.assertEquals((Object)"a,b,c", (Object)conf2.getString("split/list3/@values"));
        Assert.assertEquals((long)0L, (long)conf2.getMaxIndex("split/list3/@values"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)conf2.getString("split/list4/@values"));
        Assert.assertEquals((Object)"a,b,c", (Object)conf2.getString("split/list1"));
        Assert.assertEquals((long)0L, (long)conf2.getMaxIndex("split/list1"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)conf2.getString("split/list2"));
    }

    @Test
    public void testSaveWithDelimiterParsingDisabled() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        this.conf.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        TestXMLConfiguration.load(this.conf, this.testProperties);
        Assert.assertEquals((Object)"a,b,c", (Object)this.conf.getString("split/list3/@values"));
        Assert.assertEquals((long)0L, (long)this.conf.getMaxIndex("split/list3/@values"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)this.conf.getString("split/list4/@values"));
        Assert.assertEquals((Object)"a,b,c", (Object)this.conf.getString("split/list1"));
        Assert.assertEquals((long)0L, (long)this.conf.getMaxIndex("split/list1"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)this.conf.getString("split/list2"));
        this.saveTestConfig();
        XMLConfiguration config = new XMLConfiguration();
        TestXMLConfiguration.load(config, this.testFile2);
        config.setProperty("Employee[@attr1]", (Object)"3,2,1");
        Assert.assertEquals((Object)"3,2,1", (Object)config.getString("Employee[@attr1]"));
        new FileHandler((FileBased)config).save(this.testSaveFile);
        config = new XMLConfiguration();
        TestXMLConfiguration.load(config, this.testSaveFile.getAbsolutePath());
        config.setProperty("Employee[@attr1]", (Object)"1,2,3");
        Assert.assertEquals((Object)"1,2,3", (Object)config.getString("Employee[@attr1]"));
        config.setProperty("Employee[@attr2]", (Object)"one, two, three");
        Assert.assertEquals((Object)"one, two, three", (Object)config.getString("Employee[@attr2]"));
        config.setProperty("Employee.text", (Object)"a,b,d");
        Assert.assertEquals((Object)"a,b,d", (Object)config.getString("Employee.text"));
        config.setProperty("Employee.Salary", (Object)"100,000");
        Assert.assertEquals((Object)"100,000", (Object)config.getString("Employee.Salary"));
        new FileHandler((FileBased)config).save(this.testSaveFile);
        XMLConfiguration checkConfig = new XMLConfiguration();
        checkConfig.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        TestXMLConfiguration.load(checkConfig, this.testSaveFile.getAbsolutePath());
        Assert.assertEquals((Object)"1,2,3", (Object)checkConfig.getString("Employee/@attr1"));
        Assert.assertEquals((Object)"one, two, three", (Object)checkConfig.getString("Employee/@attr2"));
        Assert.assertEquals((Object)"a,b,d", (Object)checkConfig.getString("Employee/text"));
        Assert.assertEquals((Object)"100,000", (Object)checkConfig.getString("Employee/Salary"));
    }

    @Test
    public void testDtd() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, "testDtd.xml");
        Assert.assertEquals((Object)"value1", (Object)this.conf.getString("entry(0)"));
        Assert.assertEquals((Object)"test2", (Object)this.conf.getString("entry(1)[@key]"));
    }

    @Test
    public void testValidating() throws ConfigurationException {
        File nonValidFile = ConfigurationAssert.getTestFile("testValidateInvalid.xml");
        this.conf = new XMLConfiguration();
        Assert.assertFalse((boolean)this.conf.isValidating());
        TestXMLConfiguration.load(this.conf, nonValidFile.getAbsolutePath());
        Assert.assertEquals((Object)"customers", (Object)this.conf.getString("table.name"));
        Assert.assertFalse((boolean)this.conf.containsKey("table.fields.field(1).type"));
    }

    @Test(expected=ConfigurationException.class)
    public void testValidatingInvalidFile() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        this.conf.setValidating(true);
        TestXMLConfiguration.load(this.conf, "testValidateInvalid.xml");
    }

    @Test
    public void testEmptyElements() throws ConfigurationException {
        Assert.assertTrue((boolean)this.conf.containsKey("empty"));
        Assert.assertEquals((Object)"", (Object)this.conf.getString("empty"));
        this.conf.addProperty("empty2", (Object)"");
        this.conf.setProperty("empty", (Object)"no more empty");
        this.saveTestConfig();
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, this.testSaveConf.getAbsolutePath());
        Assert.assertEquals((Object)"no more empty", (Object)this.conf.getString("empty"));
        Assert.assertEquals((Object)"", (Object)this.conf.getProperty("empty2"));
    }

    @Test
    public void testEmptyReload() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        Assert.assertTrue((String)"Newly created configuration not empty", (boolean)this.conf.isEmpty());
        this.saveTestConfig();
        TestXMLConfiguration.load(this.conf, this.testSaveConf.getAbsolutePath());
        Assert.assertTrue((String)"Reloaded configuration not empty", (boolean)this.conf.isEmpty());
    }

    @Test
    public void testLoadWithEncoding() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        new FileHandler((FileBased)this.conf).load(ConfigurationAssert.getTestFile("testEncoding.xml"));
        Assert.assertEquals((Object)"test3_yoge", (Object)this.conf.getString("yoge"));
    }

    @Test
    public void testLoadWithRootNamespace() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        new FileHandler((FileBased)this.conf).load(ConfigurationAssert.getTestFile("testRootNamespace.xml"));
        Assert.assertEquals((Object)"http://example.com/", (Object)this.conf.getString("[@xmlns:foo]"));
    }

    @Test
    public void testLoadChildNamespace() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        new FileHandler((FileBased)this.conf).load(ConfigurationAssert.getTestFile("testChildNamespace.xml"));
        Assert.assertEquals((Object)"http://example.com/", (Object)this.conf.getString("foo:bar.[@xmlns:foo]"));
    }

    @Test
    public void testSaveWithEncoding() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        this.conf.setProperty("test", (Object)"a value");
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.setEncoding(ENCODING);
        StringWriter out = new StringWriter();
        handler.save((Writer)out);
        Assert.assertThat((String)"Encoding was not written to file", (Object)out.toString(), (Matcher)CoreMatchers.containsString((String)"encoding=\"ISO-8859-1\""));
    }

    @Test
    public void testSaveWithRootAttributes() throws ConfigurationException {
        this.conf.setProperty("[@xmlns:ex]", (Object)"http://example.com/");
        Assert.assertEquals((String)"Root attribute not set", (Object)"http://example.com/", (Object)this.conf.getString("[@xmlns:ex]"));
        FileHandler handler = new FileHandler((FileBased)this.conf);
        StringWriter out = new StringWriter();
        handler.save((Writer)out);
        Assert.assertThat((String)"Encoding was not written to file", (Object)out.toString(), (Matcher)CoreMatchers.containsString((String)"testconfig xmlns:ex=\"http://example.com/\""));
    }

    @Test
    public void testSaveWithRootAttributes_ByHand() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        this.conf.addProperty("[@xmlns:foo]", (Object)"http://example.com/");
        Assert.assertEquals((String)"Root attribute not set", (Object)"http://example.com/", (Object)this.conf.getString("[@xmlns:foo]"));
        FileHandler handler = new FileHandler((FileBased)this.conf);
        StringWriter out = new StringWriter();
        handler.save((Writer)out);
        Assert.assertThat((String)"Encoding was not written to file", (Object)out.toString(), (Matcher)CoreMatchers.containsString((String)"configuration xmlns:foo=\"http://example.com/\""));
    }

    @Test
    public void testSaveWithNullEncoding() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        this.conf.setProperty("testNoEncoding", (Object)"yes");
        FileHandler handler = new FileHandler((FileBased)this.conf);
        StringWriter out = new StringWriter();
        handler.save((Writer)out);
        Assert.assertThat((String)"Encoding was written to file", (Object)out.toString(), (Matcher)CoreMatchers.containsString((String)"encoding=\"UTF-"));
    }

    @Test
    public void testSaveWithDoctype() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, "testDtdPublic.xml");
        Assert.assertEquals((String)"Wrong public ID", (Object)PUBLIC_ID, (Object)this.conf.getPublicID());
        Assert.assertEquals((String)"Wrong system ID", (Object)SYSTEM_ID, (Object)this.conf.getSystemID());
        StringWriter out = new StringWriter();
        new FileHandler((FileBased)this.conf).save((Writer)out);
        Assert.assertThat((String)"Did not find DOCTYPE", (Object)out.toString(), (Matcher)CoreMatchers.containsString((String)DOCTYPE));
    }

    @Test
    public void testSaveWithDoctypeIDs() throws ConfigurationException {
        Assert.assertNull((String)"A public ID was found", (Object)this.conf.getPublicID());
        Assert.assertNull((String)"A system ID was found", (Object)this.conf.getSystemID());
        this.conf.setPublicID(PUBLIC_ID);
        this.conf.setSystemID(SYSTEM_ID);
        StringWriter out = new StringWriter();
        new FileHandler((FileBased)this.conf).save((Writer)out);
        Assert.assertThat((String)"Did not find DOCTYPE", (Object)out.toString(), (Matcher)CoreMatchers.containsString((String)"<!DOCTYPE testconfig PUBLIC \"-//Commons Configuration//DTD Test Configuration 1.3//EN\" \"properties.dtd\">"));
    }

    @Test
    public void testSaveWithInvalidTransformerFactory() throws ConfigurationException {
        System.setProperty(PROP_FACTORY, "an.invalid.Class");
        try {
            this.saveTestConfig();
            Assert.fail((String)"Could save with invalid TransformerFactory!");
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
        }
        finally {
            System.getProperties().remove(PROP_FACTORY);
        }
    }

    @Test
    public void testXPathExpressionEngine() {
        this.conf.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        Assert.assertEquals((String)"Wrong attribute value", (Object)"foo\"bar", (Object)this.conf.getString("test[1]/entity/@name"));
        this.conf.clear();
        Assert.assertNull((Object)this.conf.getString("test[1]/entity/@name"));
    }

    @Test
    public void testInitCopy() throws ConfigurationException {
        XMLConfiguration copy = new XMLConfiguration((HierarchicalConfiguration)this.conf);
        copy.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        Assert.assertEquals((Object)"value", (Object)copy.getProperty("element"));
        Assert.assertNull((String)"Document was copied, too", (Object)copy.getDocument());
        new FileHandler((FileBased)copy).save(this.testSaveConf);
        this.checkSavedConfig();
    }

    @Test
    public void testSetTextRootElement() throws ConfigurationException {
        this.conf.setProperty("", (Object)"Root text");
        this.saveTestConfig();
        this.checkSavedConfig();
    }

    @Test
    public void testClearTextRootElement() throws ConfigurationException {
        String xml = "<e a=\"v\">text</e>";
        this.conf.clear();
        StringReader in = new StringReader("<e a=\"v\">text</e>");
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.load((Reader)in);
        Assert.assertEquals((String)"Wrong text of root", (Object)"text", (Object)this.conf.getString(""));
        this.conf.clearProperty("");
        this.saveTestConfig();
        this.checkSavedConfig();
    }

    @Test
    public void testListWithAttributes() {
        Assert.assertEquals((String)"Wrong number of <a> elements", (long)6L, (long)this.conf.getList("attrList.a").size());
        Assert.assertEquals((String)"Wrong value of first element", (Object)"ABC", (Object)this.conf.getString("attrList.a(0)"));
        Assert.assertEquals((String)"Wrong value of first name attribute", (Object)"x", (Object)this.conf.getString("attrList.a(0)[@name]"));
        Assert.assertEquals((String)"Wrong number of name attributes", (long)6L, (long)this.conf.getList("attrList.a[@name]").size());
    }

    @Test
    public void testListWithAttributesMultiValue() {
        Assert.assertEquals((String)"Wrong value of 2nd element", (Object)"1", (Object)this.conf.getString("attrList.a(1)"));
        Assert.assertEquals((String)"Wrong value of 2nd name attribute", (Object)"y", (Object)this.conf.getString("attrList.a(1)[@name]"));
        for (int i = 1; i <= 3; ++i) {
            Assert.assertEquals((String)("Wrong value of element " + (i + 1)), (long)i, (long)this.conf.getInt("attrList.a(" + i + ")"));
            Assert.assertEquals((String)("Wrong name attribute for element " + i), (Object)"y", (Object)this.conf.getString("attrList.a(" + i + ")[@name]"));
        }
    }

    @Test
    public void testListWithMultipleAttributesMultiValue() {
        for (int i = 1; i <= 2; ++i) {
            String idxStr = String.format("(%d)", i + 3);
            String nodeKey = "attrList.a" + idxStr;
            Assert.assertEquals((String)"Wrong value of multi-valued node", (Object)("value" + i), (Object)this.conf.getString(nodeKey));
            Assert.assertEquals((String)("Wrong name attribute at " + i), (Object)"u", (Object)this.conf.getString(nodeKey + "[@name]"));
            Assert.assertEquals((String)("Wrong test attribute at " + i), (Object)"yes", (Object)this.conf.getString(nodeKey + "[@test]"));
        }
    }

    @Test
    public void testAutoSaveWithSubnodeConfig() throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class);
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFileName(this.testProperties)});
        this.conf = (XMLConfiguration)builder.getConfiguration();
        builder.getFileHandler().setFile(this.testSaveConf);
        builder.setAutoSave(true);
        String newValue = "I am autosaved";
        HierarchicalConfiguration sub = this.conf.configurationAt("element2.subelement", true);
        sub.setProperty("subsubelement", (Object)"I am autosaved");
        Assert.assertEquals((String)"Change not visible to parent", (Object)"I am autosaved", (Object)this.conf.getString("element2.subelement.subsubelement"));
        XMLConfiguration conf2 = new XMLConfiguration();
        TestXMLConfiguration.load(conf2, this.testSaveConf.getAbsolutePath());
        Assert.assertEquals((String)"Change was not saved", (Object)"I am autosaved", (Object)conf2.getString("element2.subelement.subsubelement"));
    }

    @Test
    public void testAutoSaveWithSubSubnodeConfig() throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class);
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFileName(this.testProperties)});
        this.conf = (XMLConfiguration)builder.getConfiguration();
        builder.getFileHandler().setFile(this.testSaveConf);
        builder.setAutoSave(true);
        String newValue = "I am autosaved";
        HierarchicalConfiguration sub1 = this.conf.configurationAt("element2", true);
        HierarchicalConfiguration sub2 = sub1.configurationAt("subelement", true);
        sub2.setProperty("subsubelement", (Object)"I am autosaved");
        Assert.assertEquals((String)"Change not visible to parent", (Object)"I am autosaved", (Object)this.conf.getString("element2.subelement.subsubelement"));
        XMLConfiguration conf2 = new XMLConfiguration();
        TestXMLConfiguration.load(conf2, this.testSaveConf.getAbsolutePath());
        Assert.assertEquals((String)"Change was not saved", (Object)"I am autosaved", (Object)conf2.getString("element2.subelement.subsubelement"));
    }

    @Test
    public void testSaveDelimiterParsingDisabled() throws ConfigurationException {
        this.checkSaveDelimiterParsingDisabled("list.delimiter.test");
    }

    private void checkSaveDelimiterParsingDisabled(String key) throws ConfigurationException {
        this.conf.clear();
        this.conf.setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler());
        TestXMLConfiguration.load(this.conf, this.testProperties);
        this.conf.setProperty(key, (Object)"C:\\Temp\\,C:\\Data\\");
        this.conf.addProperty(key, (Object)"a,b,c");
        this.saveTestConfig();
        XMLConfiguration checkConf = new XMLConfiguration();
        checkConf.setListDelimiterHandler(this.conf.getListDelimiterHandler());
        TestXMLConfiguration.load(checkConf, this.testSaveConf.getAbsolutePath());
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)this.conf, (ImmutableConfiguration)checkConf);
    }

    @Test
    public void testNoDelimiterParsingInAttrValues() throws ConfigurationException {
        this.conf.clear();
        TestXMLConfiguration.load(this.conf, this.testProperties);
        List expr = this.conf.getList("expressions[@value]");
        Assert.assertEquals((String)"Wrong list size", (long)1L, (long)expr.size());
        Assert.assertEquals((String)"Wrong element 1", (Object)"a || (b && c) | !d", expr.get(0));
    }

    @Test
    public void testAttributeKeyWithMultipleValues() throws ConfigurationException {
        this.conf.addProperty("errorTest[@multiAttr]", Arrays.asList("v1", "v2"));
        this.saveTestConfig();
        XMLConfiguration checkConfig = new XMLConfiguration();
        TestXMLConfiguration.load(checkConfig, this.testSaveConf.getAbsolutePath());
        Assert.assertEquals((String)"Wrong attribute value", (Object)"v1", (Object)checkConfig.getString("errorTest[@multiAttr]"));
    }

    @Test
    public void testAddNodesCopy() throws ConfigurationException {
        XMLConfiguration c2 = new XMLConfiguration();
        TestXMLConfiguration.load(c2, this.testProperties2);
        this.conf.addNodes("copiedProperties", (Collection)((ImmutableNode)c2.getModel().getNodeHandler().getRootNode()).getChildren());
        this.saveTestConfig();
        this.checkSavedConfig();
    }

    @Test
    public void testAutoSaveAddNodes() throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class);
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFileName(this.testProperties)});
        this.conf = (XMLConfiguration)builder.getConfiguration();
        builder.getFileHandler().setFile(this.testSaveConf);
        builder.setAutoSave(true);
        ImmutableNode node = NodeStructureHelper.createNode("addNodesTest", Boolean.TRUE);
        ArrayList<ImmutableNode> nodes = new ArrayList<ImmutableNode>(1);
        nodes.add(node);
        this.conf.addNodes("test.autosave", nodes);
        XMLConfiguration c2 = new XMLConfiguration();
        TestXMLConfiguration.load(c2, this.testSaveConf.getAbsolutePath());
        Assert.assertTrue((String)"Added nodes are not saved", (boolean)c2.getBoolean("test.autosave.addNodesTest"));
    }

    @Test
    public void testAddNodesAndSave() throws ConfigurationException {
        ImmutableNode.Builder bldrNode = new ImmutableNode.Builder(1);
        bldrNode.addChild(NodeStructureHelper.createNode("child", null));
        bldrNode.addAttribute("attr", (Object)"");
        ImmutableNode node2 = NodeStructureHelper.createNode("test2", null);
        this.conf.addNodes("add.nodes", Arrays.asList(bldrNode.name("test").create(), node2));
        this.saveTestConfig();
        this.conf.setProperty("add.nodes.test", (Object)"true");
        this.conf.setProperty("add.nodes.test.child", (Object)"yes");
        this.conf.setProperty("add.nodes.test[@attr]", (Object)"existing");
        this.conf.setProperty("add.nodes.test2", (Object)"anotherValue");
        this.saveTestConfig();
        XMLConfiguration c2 = new XMLConfiguration();
        TestXMLConfiguration.load(c2, this.testSaveConf.getAbsolutePath());
        Assert.assertEquals((String)"Value was not saved", (Object)"true", (Object)c2.getString("add.nodes.test"));
        Assert.assertEquals((String)"Child value was not saved", (Object)"yes", (Object)c2.getString("add.nodes.test.child"));
        Assert.assertEquals((String)"Attr value was not saved", (Object)"existing", (Object)c2.getString("add.nodes.test[@attr]"));
        Assert.assertEquals((String)"Node2 not saved", (Object)"anotherValue", (Object)c2.getString("add.nodes.test2"));
    }

    @Test
    public void testSaveAfterCreateWithCopyConstructor() throws ConfigurationException {
        HierarchicalConfiguration hc = this.conf.configurationAt("element2");
        this.conf = new XMLConfiguration(hc);
        this.saveTestConfig();
        XMLConfiguration checkConfig = this.checkSavedConfig();
        Assert.assertEquals((String)"Wrong name of root element", (Object)"element2", (Object)checkConfig.getRootElementName());
    }

    @Test
    public void testCopyRootName() throws ConfigurationException {
        String rootName = "rootElement";
        String xml = "<rootElement><test>true</test></rootElement>";
        this.conf.clear();
        new FileHandler((FileBased)this.conf).load((Reader)new StringReader("<rootElement><test>true</test></rootElement>"));
        XMLConfiguration copy = new XMLConfiguration((HierarchicalConfiguration)this.conf);
        Assert.assertEquals((String)"Wrong name of root element", (Object)"rootElement", (Object)copy.getRootElementName());
        new FileHandler((FileBased)copy).save(this.testSaveConf);
        copy = new XMLConfiguration();
        TestXMLConfiguration.load(copy, this.testSaveConf.getAbsolutePath());
        Assert.assertEquals((String)"Wrong name of root element after save", (Object)"rootElement", (Object)copy.getRootElementName());
    }

    @Test
    public void testCopyRootNameNoDocument() throws ConfigurationException {
        String rootName = "rootElement";
        this.conf = new XMLConfiguration();
        this.conf.setRootElementName("rootElement");
        this.conf.setProperty("test", (Object)Boolean.TRUE);
        XMLConfiguration copy = new XMLConfiguration((HierarchicalConfiguration)this.conf);
        Assert.assertEquals((String)"Wrong name of root element", (Object)"rootElement", (Object)copy.getRootElementName());
        new FileHandler((FileBased)copy).save(this.testSaveConf);
        TestXMLConfiguration.load(copy, this.testSaveConf.getAbsolutePath());
        Assert.assertEquals((String)"Wrong name of root element after save", (Object)"rootElement", (Object)copy.getRootElementName());
    }

    @Test
    public void testCopyNull() {
        this.conf = new XMLConfiguration(null);
        Assert.assertTrue((String)"Not empty", (boolean)this.conf.isEmpty());
        Assert.assertEquals((String)"Wrong root element name", (Object)"configuration", (Object)this.conf.getRootElementName());
    }

    @Test
    public void testPreserveSpace() {
        Assert.assertEquals((String)"Wrong value of blanc", (Object)" ", (Object)this.conf.getString("space.blanc"));
        Assert.assertEquals((String)"Wrong value of stars", (Object)" * * ", (Object)this.conf.getString("space.stars"));
    }

    @Test
    public void testPreserveSpaceOnElement() {
        Assert.assertEquals((String)"Wrong value spaceElement", (Object)" preserved ", (Object)this.conf.getString("spaceElement"));
        Assert.assertEquals((String)"Wrong value of spaceBlankElement", (Object)"   ", (Object)this.conf.getString("spaceBlankElement"));
    }

    @Test
    public void testPreserveSpaceOverride() {
        Assert.assertEquals((String)"Not trimmed", (Object)"Some text", (Object)this.conf.getString("space.description"));
    }

    @Test
    public void testPreserveSpaceInvalid() {
        Assert.assertEquals((String)"Invalid not trimmed", (Object)"Some other text", (Object)this.conf.getString("space.testInvalid"));
    }

    @Test
    public void testSaveWithValidation() throws Exception {
        CatalogResolver resolver = new CatalogResolver();
        resolver.setCatalogFiles(CATALOG_FILES);
        this.conf = new XMLConfiguration();
        this.conf.setEntityResolver((EntityResolver)resolver);
        this.conf.setSchemaValidation(true);
        TestXMLConfiguration.load(this.conf, this.testFile2);
        this.conf.setProperty("Employee.SSN", (Object)"123456789");
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.conf.setSynchronizer((Synchronizer)sync);
        this.conf.validate();
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
        this.saveTestConfig();
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, this.testSaveConf.getAbsolutePath());
        Assert.assertEquals((Object)"123456789", (Object)this.conf.getString("Employee.SSN"));
    }

    @Test
    public void testSaveWithValidationFailure() throws Exception {
        CatalogResolver resolver = new CatalogResolver();
        resolver.setCatalogFiles(CATALOG_FILES);
        this.conf = new XMLConfiguration();
        this.conf.setEntityResolver((EntityResolver)resolver);
        this.conf.setSchemaValidation(true);
        TestXMLConfiguration.load(this.conf, this.testFile2);
        this.conf.setProperty("Employee.Email", (Object)"JohnDoe@apache.org");
        try {
            this.conf.validate();
            Assert.fail((String)"No validation failure on save");
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            Assert.assertNotNull((String)"No cause for exception on save", (Object)cause);
            Assert.assertTrue((String)"Incorrect exception on save", (boolean)(cause instanceof SAXParseException));
        }
    }

    @Test
    public void testConcurrentGetAndReload() throws ConfigurationException, InterruptedException {
        int i;
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class);
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFileName(this.testProperties)});
        XMLConfiguration config = (XMLConfiguration)builder.getConfiguration();
        Assert.assertTrue((String)"Property not found", (config.getProperty("test.short") != null ? 1 : 0) != 0);
        Thread[] testThreads = new Thread[5];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new ReloadThread(builder);
            testThreads[i].start();
        }
        for (i = 0; i < 100; ++i) {
            config = (XMLConfiguration)builder.getConfiguration();
            Assert.assertTrue((String)"Property not found", (config.getProperty("test.short") != null ? 1 : 0) != 0);
        }
        for (Thread testThread : testThreads) {
            testThread.join();
        }
    }

    @Test
    public void testSaveWindowsPath() throws ConfigurationException {
        this.conf.clear();
        this.conf.setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler());
        this.conf.addProperty("path", (Object)"C:\\Temp");
        StringWriter writer = new StringWriter();
        new FileHandler((FileBased)this.conf).save((Writer)writer);
        String content = writer.toString();
        Assert.assertThat((String)"Path not found: ", (Object)content, (Matcher)CoreMatchers.containsString((String)"<path>C:\\Temp</path>"));
        this.saveTestConfig();
        XMLConfiguration conf2 = new XMLConfiguration();
        TestXMLConfiguration.load(conf2, this.testSaveConf.getAbsolutePath());
        Assert.assertEquals((String)"Wrong windows path", (Object)"C:\\Temp", (Object)conf2.getString("path"));
    }

    @Test
    public void testEmptyAttribute() throws ConfigurationException {
        String key = "element3[@value]";
        this.conf.setProperty("element3[@value]", (Object)"");
        Assert.assertTrue((String)"Key not found", (boolean)this.conf.containsKey("element3[@value]"));
        Assert.assertEquals((String)"Wrong value", (Object)"", (Object)this.conf.getString("element3[@value]"));
        this.saveTestConfig();
        this.conf = new XMLConfiguration();
        TestXMLConfiguration.load(this.conf, this.testSaveConf.getAbsolutePath());
        Assert.assertTrue((String)"Key not found after save", (boolean)this.conf.containsKey("element3[@value]"));
        Assert.assertEquals((String)"Wrong value after save", (Object)"", (Object)this.conf.getString("element3[@value]"));
    }

    @Test
    public void testAddNodesToSubnodeConfiguration() throws Exception {
        HierarchicalConfiguration sub = this.conf.configurationAt("element2", true);
        sub.addProperty("newKey", (Object)"newvalue");
        Assert.assertEquals((String)"Property not added", (Object)"newvalue", (Object)this.conf.getString("element2.newKey"));
    }

    @Test
    public void testSetPropertyListWithDelimiterParsingDisabled() throws ConfigurationException {
        String prop = "delimiterListProp";
        List<String> list = Arrays.asList("val", "val2", "val3");
        this.conf.setProperty("delimiterListProp", list);
        this.saveTestConfig();
        XMLConfiguration conf2 = new XMLConfiguration();
        TestXMLConfiguration.load(conf2, this.testSaveConf.getAbsolutePath());
        Assert.assertEquals((String)"Wrong list property", list, (Object)conf2.getProperty("delimiterListProp"));
    }

    @Test
    public void testAddPropertyListWithDelimiterParsingDisabled() throws ConfigurationException {
        this.conf.clear();
        String prop = "delimiterListProp";
        this.conf.setListDelimiterHandler(DisabledListDelimiterHandler.INSTANCE);
        List<String> list = Arrays.asList("val", "val2", "val3");
        this.conf.addProperty("delimiterListProp", list);
        this.saveTestConfig();
        XMLConfiguration conf2 = new XMLConfiguration();
        TestXMLConfiguration.load(conf2, this.testSaveConf.getAbsolutePath());
        Assert.assertEquals((String)"Wrong list property", list, (Object)conf2.getProperty("delimiterListProp"));
    }

    @Test
    public void testSystemIdSynchronized() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.conf.setSynchronizer((Synchronizer)sync);
        this.conf.setSystemID(SYSTEM_ID);
        Assert.assertEquals((String)"SystemID not set", (Object)SYSTEM_ID, (Object)this.conf.getSystemID());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE, SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testPublicIdSynchronized() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.conf.setSynchronizer((Synchronizer)sync);
        this.conf.setPublicID(PUBLIC_ID);
        Assert.assertEquals((String)"PublicID not set", (Object)PUBLIC_ID, (Object)this.conf.getPublicID());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE, SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testReadCalledDirectly() throws IOException {
        this.conf = new XMLConfiguration();
        String content = "<configuration><test>1</test></configuration>";
        ByteArrayInputStream bis = new ByteArrayInputStream("<configuration><test>1</test></configuration>".getBytes());
        try {
            this.conf.read((InputStream)bis);
            Assert.fail((String)"No exception thrown!");
        }
        catch (ConfigurationException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"FileHandler"));
        }
    }

    private void removeTestFile() {
        if (this.testSaveConf.exists()) {
            Assert.assertTrue((boolean)this.testSaveConf.delete());
        }
    }

    private void saveTestConfig() throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.save(this.testSaveConf);
    }

    private XMLConfiguration checkSavedConfig(File saveFile) throws ConfigurationException {
        XMLConfiguration config = TestXMLConfiguration.createFromFile(saveFile.getAbsolutePath());
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)this.conf, (ImmutableConfiguration)config);
        return config;
    }

    private XMLConfiguration checkSavedConfig() throws ConfigurationException {
        return this.checkSavedConfig(this.testSaveConf);
    }

    private class ReloadThread
    extends Thread {
        private final FileBasedConfigurationBuilder<?> builder;

        ReloadThread(FileBasedConfigurationBuilder<?> confBulder) {
            this.builder = confBulder;
        }

        @Override
        public void run() {
            for (int i = 0; i < 100; ++i) {
                this.builder.resetResult();
            }
        }
    }
}

