/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class Logging
extends Log4JLogger {
    private static final long serialVersionUID = 8619242753795694874L;
    private static final String FQCN = Logging.class.getName();
    private static Priority traceLevel;

    public Logging() {
    }

    public Logging(String name) {
        super(name);
    }

    public Logging(Logger logger) {
        super(logger);
    }

    public void trace(Object message) {
        this.getLogger().log(FQCN, traceLevel, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.getLogger().log(FQCN, traceLevel, message, t);
    }

    public void debug(Object message) {
        this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, t);
    }

    public void info(Object message) {
        this.getLogger().log(FQCN, (Priority)Level.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.getLogger().log(FQCN, (Priority)Level.INFO, message, t);
    }

    public void warn(Object message) {
        this.getLogger().log(FQCN, (Priority)Level.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.getLogger().log(FQCN, (Priority)Level.WARN, message, t);
    }

    public void error(Object message) {
        this.getLogger().log(FQCN, (Priority)Level.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.getLogger().log(FQCN, (Priority)Level.ERROR, message, t);
    }

    public void fatal(Object message) {
        this.getLogger().log(FQCN, (Priority)Level.FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.getLogger().log(FQCN, (Priority)Level.FATAL, message, t);
    }

    static {
        try {
            traceLevel = (Priority)Level.class.getDeclaredField("TRACE").get(null);
        }
        catch (Exception ex) {
            traceLevel = Level.DEBUG;
        }
        String level = System.getProperty("LogLevel");
        if (level != null) {
            Logger log = Logger.getRootLogger();
            log.setLevel(Level.toLevel((String)level));
            ConsoleAppender appender = new ConsoleAppender((Layout)new PatternLayout("%p %l - %m%n"), "System.out");
            log.addAppender((Appender)appender);
        }
    }
}

