/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.interpol;

import java.io.File;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.interpol.ExprLookup;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.junit.Assert;
import org.junit.Test;

public class TestExprLookup {
    private static File TEST_FILE = ConfigurationAssert.getTestFile("test.xml");
    private static String PATTERN1 = "String.replace(Util.message, 'Hello', 'Goodbye') + System.getProperty('user.name')";
    private static String PATTERN2 = "'$[element] ' + String.trimToEmpty('$[space.description]')";

    private static XMLConfiguration loadConfig() throws ConfigurationException {
        XMLConfiguration config = new XMLConfiguration();
        FileHandler handler = new FileHandler((FileBased)config);
        handler.load(TEST_FILE);
        return config;
    }

    @Test
    public void testLookup() throws Exception {
        ConsoleAppender app = new ConsoleAppender((Layout)new SimpleLayout());
        Log log = LogFactory.getLog((String)"TestLogger");
        Logger logger = ((Log4JLogger)log).getLogger();
        logger.addAppender((Appender)app);
        logger.setLevel(Level.DEBUG);
        logger.setAdditivity(false);
        ExprLookup.Variables vars = new ExprLookup.Variables();
        vars.add((Object)new ExprLookup.Variable("String", StringUtils.class));
        vars.add((Object)new ExprLookup.Variable("Util", (Object)new Utility("Hello")));
        vars.add((Object)new ExprLookup.Variable("System", (Object)"Class:java.lang.System"));
        XMLConfiguration config = TestExprLookup.loadConfig();
        ConfigurationLogger testLogger = new ConfigurationLogger("TestLogger");
        config.setLogger(testLogger);
        ExprLookup lookup = new ExprLookup(vars);
        lookup.setInterpolator(config.getInterpolator());
        lookup.setLogger(testLogger);
        String str = lookup.lookup(PATTERN1);
        Assert.assertTrue((boolean)str.startsWith("Goodbye"));
        str = lookup.lookup(PATTERN2);
        Assert.assertTrue((String)("Incorrect value: " + str), (boolean)str.equals("value Some text"));
        logger.removeAppender((Appender)app);
    }

    @Test
    public void testLookupNoConfigurationInterpolator() {
        ExprLookup.Variables vars = new ExprLookup.Variables();
        vars.add((Object)new ExprLookup.Variable("String", StringUtils.class));
        ExprLookup lookup = new ExprLookup(vars);
        String value = "test";
        Assert.assertEquals((String)"Wrong result", (Object)"test", (Object)lookup.lookup("test"));
    }

    @Test
    public void testGetVariables() {
        ExprLookup.Variables vars = new ExprLookup.Variables();
        vars.add((Object)new ExprLookup.Variable("String", StringUtils.class));
        ExprLookup lookup = new ExprLookup(vars);
        Assert.assertEquals((String)"Wrong variables", (Object)vars, (Object)lookup.getVariables());
    }

    @Test
    public void testGetVariablesDefensiveCopy() {
        ExprLookup.Variables vars = new ExprLookup.Variables();
        vars.add((Object)new ExprLookup.Variable("String", StringUtils.class));
        ExprLookup lookup = new ExprLookup(vars);
        ExprLookup.Variables vars2 = lookup.getVariables();
        vars2.add((Object)new ExprLookup.Variable("System", (Object)"Class:java.lang.System"));
        Assert.assertEquals((String)"Modified variables", (Object)vars, (Object)lookup.getVariables());
    }

    @Test
    public void testLookupNonStringExpression() throws ConfigurationException {
        ExprLookup.Variables vars = new ExprLookup.Variables();
        vars.add((Object)new ExprLookup.Variable("System", (Object)"Class:java.lang.System"));
        ExprLookup lookup = new ExprLookup(vars);
        XMLConfiguration config = TestExprLookup.loadConfig();
        lookup.setInterpolator(config.getInterpolator());
        String pattern = "System.currentTimeMillis()";
        String result = lookup.lookup("System.currentTimeMillis()");
        Assert.assertNotEquals((String)"Not replaced", (Object)"System.currentTimeMillis()", (Object)result);
    }

    @Test
    public void testLookupNullExpression() throws ConfigurationException {
        ExprLookup.Variables vars = new ExprLookup.Variables();
        vars.add((Object)new ExprLookup.Variable("System", (Object)"Class:java.lang.System"));
        ExprLookup lookup = new ExprLookup(vars);
        XMLConfiguration config = TestExprLookup.loadConfig();
        lookup.setInterpolator(config.getInterpolator());
        Assert.assertNull((String)"Wrong result", (Object)lookup.lookup("System.getProperty('undefined.property')"));
    }

    public static class Utility {
        String message;

        public Utility(String msg) {
            this.message = msg;
        }

        public String getMessage() {
            return this.message;
        }

        public String str(String str) {
            return str;
        }
    }
}

