/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.DataConfiguration;
import org.apache.commons.configuration2.FileURLStreamHandler;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.LegacyListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.DefaultFileSystem;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestPropertiesConfiguration {
    private static final String PROP_NAME = "testProperty";
    private static final String PROP_VALUE = "value";
    private static final String CR = System.getProperty("line.separator");
    private static String testProperties = ConfigurationAssert.getTestFile("test.properties").getAbsolutePath();
    private static String testBasePath = ConfigurationAssert.TEST_DIR.getAbsolutePath();
    private static String testBasePath2 = ConfigurationAssert.TEST_DIR.getParentFile().getAbsolutePath();
    private static File testSavePropertiesFile = ConfigurationAssert.getOutFile("testsave.properties");
    private PropertiesConfiguration conf;
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    private static FileHandler load(PropertiesConfiguration pc, String fileName) throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setFileName(fileName);
        handler.load();
        return handler;
    }

    private void checkBackslashList(String key) {
        Object prop = this.conf.getProperty("test." + key);
        Assert.assertTrue((String)"Not a list", (boolean)(prop instanceof List));
        List list = (List)prop;
        Assert.assertEquals((String)"Wrong number of list elements", (long)2L, (long)list.size());
        String prefix = "\\\\" + key;
        Assert.assertEquals((String)"Wrong element 1", (Object)(prefix + "a"), list.get(0));
        Assert.assertEquals((String)"Wrong element 2", (Object)(prefix + "b"), list.get(1));
    }

    private void checkCopiedConfig(Configuration copyConf) throws ConfigurationException {
        this.saveTestConfig();
        PropertiesConfiguration checkConf = new PropertiesConfiguration();
        TestPropertiesConfiguration.load(checkConf, testSavePropertiesFile.getAbsolutePath());
        Iterator it = copyConf.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assert.assertEquals((String)("Wrong value for property " + key), (Object)checkConf.getProperty(key), (Object)copyConf.getProperty(key));
        }
    }

    private void checkEmpty(String key) {
        String empty = this.conf.getString(key);
        Assert.assertNotNull((String)("Property not found: " + key), (Object)empty);
        Assert.assertEquals((String)("Wrong value for property " + key), (Object)"", (Object)empty);
    }

    private PropertiesConfiguration checkSavedConfig() throws ConfigurationException {
        PropertiesConfiguration checkConfig = new PropertiesConfiguration();
        checkConfig.setListDelimiterHandler((ListDelimiterHandler)new LegacyListDelimiterHandler(','));
        TestPropertiesConfiguration.load(checkConfig, testSavePropertiesFile.getAbsolutePath());
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)this.conf, (ImmutableConfiguration)checkConfig);
        return checkConfig;
    }

    private void saveTestConfig() throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.save(testSavePropertiesFile);
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new PropertiesConfiguration();
        this.conf.setListDelimiterHandler((ListDelimiterHandler)new LegacyListDelimiterHandler(','));
        TestPropertiesConfiguration.load(this.conf, testProperties);
        if (testSavePropertiesFile.exists()) {
            Assert.assertTrue((String)"Test output file could not be deleted", (boolean)testSavePropertiesFile.delete());
        }
    }

    private Configuration setUpCopyConfig() {
        int count = 25;
        BaseConfiguration result = new BaseConfiguration();
        for (int i = 1; i <= 25; ++i) {
            result.addProperty("copyKey" + i, (Object)("copyValue" + i));
        }
        return result;
    }

    @Test
    public void testAppend() throws Exception {
        File file2 = ConfigurationAssert.getTestFile("threesome.properties");
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.load(file2);
        Assert.assertEquals((Object)"aaa", (Object)this.conf.getString("test.threesome.one"));
        Assert.assertEquals((Object)"true", (Object)this.conf.getString("configuration.loaded"));
    }

    @Test
    public void testAppendAndSave() throws ConfigurationException {
        Configuration copyConf = this.setUpCopyConfig();
        this.conf.append(copyConf);
        this.checkCopiedConfig(copyConf);
    }

    @Test
    public void testBackslashEscapingInLists() throws Exception {
        this.checkBackslashList("share2");
        this.checkBackslashList("share1");
    }

    @Test
    public void testChangingListDelimiter() throws Exception {
        Assert.assertEquals((String)"Wrong initial string", (Object)"a^b^c", (Object)this.conf.getString("test.other.delimiter"));
        PropertiesConfiguration pc2 = new PropertiesConfiguration();
        pc2.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler('^'));
        TestPropertiesConfiguration.load(pc2, testProperties);
        Assert.assertEquals((String)"Should obtain the first value", (Object)"a", (Object)pc2.getString("test.other.delimiter"));
        Assert.assertEquals((String)"Wrong list size", (long)3L, (long)pc2.getList("test.other.delimiter").size());
    }

    @Test
    public void testClearFooterComment() {
        this.conf.clear();
        Assert.assertNull((String)"Still got a footer comment", (Object)this.conf.getFooter());
        Assert.assertNull((String)"Still got a header comment", (Object)this.conf.getHeader());
    }

    @Test
    public void testClone() throws ConfigurationException {
        PropertiesConfiguration copy = (PropertiesConfiguration)this.conf.clone();
        Assert.assertNotSame((String)"Copy has same layout object", (Object)this.conf.getLayout(), (Object)copy.getLayout());
        Assert.assertEquals((String)"Wrong number of event listeners for original", (long)1L, (long)this.conf.getEventListeners(ConfigurationEvent.ANY).size());
        Assert.assertEquals((String)"Wrong number of event listeners for clone", (long)1L, (long)copy.getEventListeners(ConfigurationEvent.ANY).size());
        Assert.assertSame((String)"Wrong event listener for original", (Object)this.conf.getLayout(), this.conf.getEventListeners(ConfigurationEvent.ANY).iterator().next());
        Assert.assertSame((String)"Wrong event listener for clone", (Object)copy.getLayout(), copy.getEventListeners(ConfigurationEvent.ANY).iterator().next());
        StringWriter outConf = new StringWriter();
        new FileHandler((FileBased)this.conf).save((Writer)outConf);
        StringWriter outCopy = new StringWriter();
        new FileHandler((FileBased)copy).save((Writer)outCopy);
        Assert.assertEquals((String)"Output from copy is different", (Object)outConf.toString(), (Object)outCopy.toString());
    }

    @Test
    public void testCloneNullLayout() {
        this.conf = new PropertiesConfiguration();
        PropertiesConfiguration copy = (PropertiesConfiguration)this.conf.clone();
        Assert.assertNotSame((String)"Layout objects are the same", (Object)this.conf.getLayout(), (Object)copy.getLayout());
    }

    @Test
    public void testComment() {
        Assert.assertFalse((String)"comment line starting with '#' parsed as a property", (boolean)this.conf.containsKey("#comment"));
        Assert.assertFalse((String)"comment line starting with '!' parsed as a property", (boolean)this.conf.containsKey("!comment"));
    }

    @Test
    public void testCopyAndSave() throws ConfigurationException {
        Configuration copyConf = this.setUpCopyConfig();
        this.conf.copy(copyConf);
        this.checkCopiedConfig(copyConf);
    }

    @Test
    public void testDisableIncludes() throws ConfigurationException, IOException {
        String content = PropertiesConfiguration.getInclude() + " = nonExistingIncludeFile" + CR + PROP_NAME + " = " + PROP_VALUE + CR;
        StringReader in = new StringReader(content);
        this.conf = new PropertiesConfiguration();
        this.conf.setIncludesAllowed(false);
        this.conf.read((Reader)in);
        Assert.assertEquals((String)"Data not loaded", (Object)PROP_VALUE, (Object)this.conf.getString(PROP_NAME));
    }

    @Test
    public void testDisableListDelimiter() throws Exception {
        Assert.assertEquals((long)4L, (long)this.conf.getList("test.mixed.array").size());
        PropertiesConfiguration pc2 = new PropertiesConfiguration();
        TestPropertiesConfiguration.load(pc2, testProperties);
        Assert.assertEquals((long)2L, (long)pc2.getList("test.mixed.array").size());
    }

    @Test
    public void testEmpty() {
        this.checkEmpty("test.empty");
    }

    @Test
    public void testEmptyNoSeparator() {
        this.checkEmpty("test.empty2");
    }

    @Test
    public void testEscapedKey() throws Exception {
        this.conf.clear();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.load((Reader)new StringReader("\\u0066\\u006f\\u006f=bar"));
        Assert.assertEquals((String)"value of the 'foo' property", (Object)"bar", (Object)this.conf.getString("foo"));
    }

    @Test
    public void testEscapedKeyValueSeparator() {
        Assert.assertEquals((String)"Escaped separator '=' not supported in keys", (Object)"foo", (Object)this.conf.getProperty("test.separator=in.key"));
        Assert.assertEquals((String)"Escaped separator ':' not supported in keys", (Object)"bar", (Object)this.conf.getProperty("test.separator:in.key"));
        Assert.assertEquals((String)"Escaped separator '\\t' not supported in keys", (Object)"foo", (Object)this.conf.getProperty("test.separator\tin.key"));
        Assert.assertEquals((String)"Escaped separator '\\f' not supported in keys", (Object)"bar", (Object)this.conf.getProperty("test.separator\fin.key"));
        Assert.assertEquals((String)"Escaped separator ' ' not supported in keys", (Object)"foo", (Object)this.conf.getProperty("test.separator in.key"));
    }

    @Test
    public void testEscapeQuote() throws ConfigurationException {
        this.conf.clear();
        String text = "\"Hello World!\"";
        this.conf.setProperty(PROP_NAME, (Object)"\"Hello World!\"");
        StringWriter out = new StringWriter();
        new FileHandler((FileBased)this.conf).save((Writer)out);
        Assert.assertTrue((String)("Value was escaped: " + out), (boolean)out.toString().contains("\"Hello World!\""));
        this.saveTestConfig();
        PropertiesConfiguration c2 = new PropertiesConfiguration();
        TestPropertiesConfiguration.load(c2, testSavePropertiesFile.getAbsolutePath());
        Assert.assertEquals((String)"Wrong value", (Object)"\"Hello World!\"", (Object)c2.getString(PROP_NAME));
    }

    @Test
    public void testFileWithSharpSymbol() throws Exception {
        File file = this.folder.newFile("sharp#1.properties");
        PropertiesConfiguration conf = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)conf);
        handler.setFile(file);
        handler.load();
        handler.save();
        Assert.assertTrue((String)("Missing file " + file), (boolean)file.exists());
    }

    @Test
    public void testGetFooterSynchronized() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.conf.setSynchronizer((Synchronizer)sync);
        Assert.assertNotNull((String)"No footer comment", (Object)this.conf.getFooter());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetHeaderSynchronized() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.conf.setSynchronizer((Synchronizer)sync);
        Assert.assertNull((String)"Got a header comment", (Object)this.conf.getHeader());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetIOFactoryDefault() {
        Assert.assertNotNull((String)"No default IO factory", (Object)this.conf.getIOFactory());
    }

    @Test
    public void testGetLayout() {
        PropertiesConfigurationLayout layout = this.conf.getLayout();
        Assert.assertNotNull((String)"Layout is null", (Object)layout);
        Assert.assertSame((String)"Different object returned", (Object)layout, (Object)this.conf.getLayout());
        this.conf.setLayout(null);
        PropertiesConfigurationLayout layout2 = this.conf.getLayout();
        Assert.assertNotNull((String)"Layout 2 is null", (Object)layout2);
        Assert.assertNotSame((String)"Same object returned", (Object)layout, (Object)layout2);
    }

    @Test
    public void testGetStringWithEscapedChars() {
        String property = this.conf.getString("test.unescape");
        Assert.assertEquals((String)"String with escaped characters", (Object)"This \n string \t contains \" escaped \\ characters", (Object)property);
    }

    @Test
    public void testGetStringWithEscapedComma() {
        String property = this.conf.getString("test.unescape.list-separator");
        Assert.assertEquals((String)"String with an escaped list separator", (Object)"This string contains , an escaped list separator", (Object)property);
    }

    @Test
    public void testIncludeInSubDir() throws ConfigurationException {
        CombinedConfigurationBuilder builder = new CombinedConfigurationBuilder();
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFileName("testFactoryPropertiesInclude.xml")});
        Configuration config = (Configuration)builder.getConfiguration();
        Assert.assertTrue((boolean)config.getBoolean("deeptest"));
        Assert.assertTrue((boolean)config.getBoolean("deepinclude"));
        Assert.assertFalse((boolean)config.containsKey("deeptestinvalid"));
    }

    @Test
    public void testInitFromNonExistingFile() throws ConfigurationException {
        String testProperty = "test.successfull";
        this.conf = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.setFile(testSavePropertiesFile);
        this.conf.addProperty("test.successfull", (Object)"true");
        handler.save();
        this.checkSavedConfig();
    }

    @Test
    public void testInMemoryCreatedSave() throws Exception {
        this.conf = new PropertiesConfiguration();
        this.conf.addProperty("string", (Object)"value1");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i < 5; ++i) {
            list.add(PROP_VALUE + i);
        }
        this.conf.addProperty("array", list);
        this.saveTestConfig();
        Assert.assertTrue((String)"The saved file doesn't exist", (boolean)testSavePropertiesFile.exists());
        this.checkSavedConfig();
    }

    @Test
    public void testIsCommentLine() {
        Assert.assertTrue((String)"Comment not detected", (boolean)PropertiesConfiguration.isCommentLine((String)"# a comment"));
        Assert.assertTrue((String)"Alternative comment not detected", (boolean)PropertiesConfiguration.isCommentLine((String)"! a comment"));
        Assert.assertTrue((String)"Comment with no space not detected", (boolean)PropertiesConfiguration.isCommentLine((String)"#a comment"));
        Assert.assertTrue((String)"Comment with leading space not detected", (boolean)PropertiesConfiguration.isCommentLine((String)"    ! a comment"));
        Assert.assertFalse((String)"Wrong comment", (boolean)PropertiesConfiguration.isCommentLine((String)"   a#comment"));
    }

    @Test
    public void testJupRead() throws IOException, ConfigurationException {
        this.conf.clear();
        this.conf.setIOFactory((PropertiesConfiguration.IOFactory)new PropertiesConfiguration.JupIOFactory());
        String testFilePath = ConfigurationAssert.getTestFile("jup-test.properties").getAbsolutePath();
        TestPropertiesConfiguration.load(this.conf, testFilePath);
        Properties jup = new Properties();
        InputStream in = Files.newInputStream(Paths.get(testFilePath, new String[0]), new OpenOption[0]);
        Object object = null;
        try {
            jup.load(in);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (object != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        HashSet pcKeys = new HashSet(IteratorUtils.toList((Iterator)this.conf.getKeys()));
        Assert.assertEquals(jup.keySet(), pcKeys);
        for (Object e : jup.keySet()) {
            String keyString = e.toString();
            System.out.println(keyString);
            Assert.assertEquals((String)("Wrong property value for '" + keyString + "'"), (Object)jup.getProperty(keyString), (Object)this.conf.getProperty(keyString));
        }
    }

    @Test
    public void testJupWrite() throws IOException, ConfigurationException {
        this.conf.clear();
        this.conf.setIOFactory((PropertiesConfiguration.IOFactory)new PropertiesConfiguration.JupIOFactory());
        String testFilePath = ConfigurationAssert.getTestFile("jup-test.properties").getAbsolutePath();
        Properties origProps = new Properties();
        Throwable throwable = null;
        try (InputStream in = Files.newInputStream(Paths.get(testFilePath, new String[0]), new OpenOption[0]);){
            origProps.load(in);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Object e : origProps.keySet()) {
            String keyString = e.toString();
            this.conf.setProperty(keyString, (Object)origProps.getProperty(keyString));
        }
        this.saveTestConfig();
        Assert.assertTrue((String)"The saved file doesn't exist", (boolean)testSavePropertiesFile.exists());
        Properties testProps = new Properties();
        InputStream inputStream = Files.newInputStream(testSavePropertiesFile.toPath(), new OpenOption[0]);
        Object object = null;
        try {
            testProps.load(inputStream);
        }
        catch (Throwable throwable4) {
            object = throwable4;
            throw throwable4;
        }
        finally {
            if (inputStream != null) {
                if (object != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable5) {
                        ((Throwable)object).addSuppressed(throwable5);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
        HashSet hashSet = new HashSet(IteratorUtils.toList((Iterator)this.conf.getKeys()));
        Assert.assertEquals(testProps.keySet(), hashSet);
        for (Object e : testProps.keySet()) {
            String keyString = e.toString();
            Assert.assertEquals((String)("Wrong property value for '" + keyString + "'"), (Object)testProps.getProperty(keyString), (Object)this.conf.getProperty(keyString));
        }
    }

    @Test
    public void testJupWriteUtf8WithoutUnicodeEscapes() throws IOException, ConfigurationException {
        this.conf.clear();
        this.conf.setIOFactory((PropertiesConfiguration.IOFactory)new PropertiesConfiguration.JupIOFactory(false));
        String testFilePath = ConfigurationAssert.getTestFile("jup-test.properties").getAbsolutePath();
        Properties origProps = new Properties();
        Throwable throwable = null;
        try (InputStream in = Files.newInputStream(Paths.get(testFilePath, new String[0]), new OpenOption[0]);){
            origProps.load(in);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Object e : origProps.keySet()) {
            String keyString = e.toString();
            this.conf.setProperty(keyString, (Object)origProps.getProperty(keyString));
        }
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.setEncoding(StandardCharsets.UTF_8.name());
        handler.save(testSavePropertiesFile);
        Assert.assertTrue((String)"The saved file doesn't exist", (boolean)testSavePropertiesFile.exists());
        Properties properties = new Properties();
        BufferedReader in = Files.newBufferedReader(testSavePropertiesFile.toPath(), StandardCharsets.UTF_8);
        Iterator<String> iterator = null;
        try {
            properties.load(in);
        }
        catch (Throwable throwable4) {
            iterator = throwable4;
            throw throwable4;
        }
        finally {
            if (in != null) {
                if (iterator != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable5) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable5);
                    }
                } else {
                    in.close();
                }
            }
        }
        HashSet pcKeys = new HashSet(IteratorUtils.toList((Iterator)this.conf.getKeys()));
        Assert.assertEquals(properties.keySet(), pcKeys);
        for (Object e : properties.keySet()) {
            String keyString = e.toString();
            Assert.assertEquals((String)("Wrong property value for '" + keyString + "'"), (Object)properties.getProperty(keyString), (Object)this.conf.getProperty(keyString));
        }
        for (String string : Files.readAllLines(testSavePropertiesFile.toPath())) {
            if (!string.contains("\\u")) continue;
            Assert.fail((String)("Unicode escape found in line: " + string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeepSeparators() throws ConfigurationException, IOException {
        this.saveTestConfig();
        String[] separatorTests = new String[]{"test.separator.equal = foo", "test.separator.colon : foo", "test.separator.tab\tfoo", "test.separator.whitespace foo", "test.separator.no.space=foo"};
        HashSet<String> foundLines = new HashSet<String>();
        try (BufferedReader in = new BufferedReader(new FileReader(testSavePropertiesFile));){
            String s;
            while ((s = in.readLine()) != null) {
                for (String separatorTest : separatorTests) {
                    if (!separatorTest.equals(s)) continue;
                    foundLines.add(s);
                }
            }
        }
        Assert.assertEquals((String)("No all separators were found: " + foundLines), (long)separatorTests.length, (long)foundLines.size());
    }

    @Test
    public void testKeyValueSeparators() {
        Assert.assertEquals((String)"equal separator not properly parsed", (Object)"foo", (Object)this.conf.getProperty("test.separator.equal"));
        Assert.assertEquals((String)"colon separator not properly parsed", (Object)"foo", (Object)this.conf.getProperty("test.separator.colon"));
        Assert.assertEquals((String)"tab separator not properly parsed", (Object)"foo", (Object)this.conf.getProperty("test.separator.tab"));
        Assert.assertEquals((String)"formfeed separator not properly parsed", (Object)"foo", (Object)this.conf.getProperty("test.separator.formfeed"));
        Assert.assertEquals((String)"whitespace separator not properly parsed", (Object)"foo", (Object)this.conf.getProperty("test.separator.whitespace"));
    }

    @Test
    public void testLineSeparator() throws ConfigurationException {
        String EOL = System.getProperty("line.separator");
        this.conf = new PropertiesConfiguration();
        this.conf.setHeader("My header");
        this.conf.setProperty("prop", (Object)PROP_VALUE);
        StringWriter out = new StringWriter();
        new FileHandler((FileBased)this.conf).save((Writer)out);
        String content = out.toString();
        Assert.assertTrue((String)"Header could not be found", (content.indexOf("# My header" + EOL + EOL) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Property could not be found", (content.indexOf("prop = value" + EOL) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testList() throws Exception {
        List packages = this.conf.getList("packages");
        Assert.assertEquals((long)3L, (long)packages.size());
    }

    @Test
    public void testLoad() throws Exception {
        String loaded = this.conf.getString("configuration.loaded");
        Assert.assertEquals((Object)"true", (Object)loaded);
    }

    @Test
    public void testLoadFromFile() throws Exception {
        File file = ConfigurationAssert.getTestFile("test.properties");
        this.conf.clear();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.setFile(file);
        handler.load();
        Assert.assertEquals((Object)"true", (Object)this.conf.getString("configuration.loaded"));
    }

    @Test
    public void testLoadInclude() throws Exception {
        String loaded = this.conf.getString("include.loaded");
        Assert.assertEquals((Object)"true", (Object)loaded);
    }

    @Test
    public void testLoadIncludeFileViaFileSystem() throws ConfigurationException {
        this.conf.clear();
        this.conf.addProperty("include", (Object)"include.properties");
        this.saveTestConfig();
        DefaultFileSystem fs = new DefaultFileSystem(){

            public InputStream getInputStream(URL url) throws ConfigurationException {
                if (url.toString().endsWith("include.properties")) {
                    try {
                        return new ByteArrayInputStream("test.outcome = success".getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new ConfigurationException("Unsupported encoding", (Throwable)e);
                    }
                }
                return super.getInputStream(url);
            }
        };
        Parameters params = new Parameters();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        builder.configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)((FileBasedBuilderParameters)params.fileBased().setFile(testSavePropertiesFile)).setBasePath(ConfigurationAssert.OUT_DIR.toURI().toString())).setFileSystem((FileSystem)fs)});
        PropertiesConfiguration configuration = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertEquals((Object)"success", (Object)configuration.getString("test.outcome"));
    }

    @Test
    public void testLoadIncludeFromClassPath() {
        Assert.assertEquals((Object)"true", (Object)this.conf.getString("include.loaded"));
    }

    @Test
    public void testLoadIncludeFromReader() throws ConfigurationException {
        StringReader in = new StringReader(PropertiesConfiguration.getInclude() + " = " + ConfigurationAssert.getTestURL("include.properties"));
        this.conf = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.load((Reader)in);
        Assert.assertEquals((String)"Include file not loaded", (Object)"true", (Object)this.conf.getString("include.loaded"));
    }

    @Test
    public void testLoadIncludeInterpol() throws Exception {
        String loaded = this.conf.getString("include.interpol.loaded");
        Assert.assertEquals((Object)"true", (Object)loaded);
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadUnexistingFile() throws ConfigurationException {
        TestPropertiesConfiguration.load(this.conf, "unexisting file");
    }

    @Test
    public void testLoadViaPropertyWithBasePath() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(testBasePath);
        handler.setFileName("test.properties");
        handler.load();
        Assert.assertTrue((String)"Make sure we have multiple keys", (boolean)pc.getBoolean("test.boolean"));
    }

    @Test
    public void testLoadIncludeOptional() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(testBasePath);
        handler.setFileName("includeoptional.properties");
        handler.load();
        Assert.assertTrue((String)"Make sure we have multiple keys", (boolean)pc.getBoolean("includeoptional.loaded"));
    }

    @Test
    public void testLoadViaPropertyWithBasePath2() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(testBasePath2);
        handler.setFileName("test.properties");
        handler.load();
        Assert.assertTrue((String)"Make sure we have multiple keys", (boolean)pc.getBoolean("test.boolean"));
    }

    @Test
    public void testMixedArray() {
        String[] array = this.conf.getStringArray("test.mixed.array");
        Assert.assertEquals((String)"array length", (long)4L, (long)array.length);
        Assert.assertEquals((String)"1st element", (Object)"a", (Object)array[0]);
        Assert.assertEquals((String)"2nd element", (Object)"b", (Object)array[1]);
        Assert.assertEquals((String)"3rd element", (Object)"c", (Object)array[2]);
        Assert.assertEquals((String)"4th element", (Object)"d", (Object)array[3]);
    }

    @Test
    public void testMultilines() {
        String property = "This is a value spread out across several adjacent natural lines by escaping the line terminator with a backslash character.";
        Assert.assertEquals((String)"'test.multilines' property", (Object)"This is a value spread out across several adjacent natural lines by escaping the line terminator with a backslash character.", (Object)this.conf.getString("test.multilines"));
    }

    @Test
    public void testMultipleIncludeFiles() throws ConfigurationException {
        this.conf = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.load(ConfigurationAssert.getTestFile("config/testMultiInclude.properties"));
        Assert.assertEquals((String)"Wrong top-level property", (Object)"topValue", (Object)this.conf.getString("top"));
        Assert.assertEquals((String)"Wrong included property (1)", (long)100L, (long)this.conf.getInt("property.c"));
        Assert.assertEquals((String)"Wrong included property (2)", (Object)true, (Object)this.conf.getBoolean("include.loaded"));
    }

    @Test
    public void testNewLineEscaping() {
        List list = this.conf.getList("test.path");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"C:\\path1\\", list.get(0));
        Assert.assertEquals((Object)"C:\\path2\\", list.get(1));
        Assert.assertEquals((Object)"C:\\path3\\complex\\test\\", list.get(2));
    }

    @Test
    public void testPropertyLoaded() throws ConfigurationException {
        DummyLayout layout = new DummyLayout();
        this.conf.setLayout((PropertiesConfigurationLayout)layout);
        this.conf.propertyLoaded("layoutLoadedProperty", "yes");
        Assert.assertEquals((String)"Layout's load() was called", (long)0L, (long)layout.loadCalls);
        Assert.assertEquals((String)"Property not added", (Object)"yes", (Object)this.conf.getString("layoutLoadedProperty"));
    }

    @Test
    public void testPropertyLoadedInclude() throws ConfigurationException {
        DummyLayout layout = new DummyLayout();
        this.conf.setLayout((PropertiesConfigurationLayout)layout);
        this.conf.propertyLoaded(PropertiesConfiguration.getInclude(), "testClasspath.properties,testEqual.properties");
        Assert.assertEquals((String)"Layout's load() was not correctly called", (long)2L, (long)layout.loadCalls);
        Assert.assertFalse((String)"Property was added", (boolean)this.conf.containsKey(PropertiesConfiguration.getInclude()));
    }

    @Test
    public void testPropertyLoadedIncludeNotAllowed() throws ConfigurationException {
        DummyLayout layout = new DummyLayout();
        this.conf.setLayout((PropertiesConfigurationLayout)layout);
        this.conf.setIncludesAllowed(false);
        this.conf.propertyLoaded(PropertiesConfiguration.getInclude(), "testClassPath.properties,testEqual.properties");
        Assert.assertEquals((String)"Layout's load() was called", (long)0L, (long)layout.loadCalls);
        Assert.assertFalse((String)"Property was added", (boolean)this.conf.containsKey(PropertiesConfiguration.getInclude()));
    }

    @Test
    public void testReadCalledDirectly() throws IOException {
        this.conf = new PropertiesConfiguration();
        try (FileReader in = new FileReader(ConfigurationAssert.getTestFile("test.properties"));){
            this.conf.read((Reader)in);
            Assert.fail((String)"No exception thrown!");
        }
    }

    @Test
    public void testReadFooterComment() {
        Assert.assertEquals((String)"Wrong footer comment", (Object)"\n# This is a foot comment\n", (Object)this.conf.getFooter());
        Assert.assertEquals((String)"Wrong footer comment from layout", (Object)"\nThis is a foot comment\n", (Object)this.conf.getLayout().getCanonicalFooterCooment(false));
    }

    @Test
    public void testReference() throws Exception {
        Assert.assertEquals((Object)"baseextra", (Object)this.conf.getString("base.reference"));
    }

    @Test
    public void testSave() throws Exception {
        this.conf.addProperty("string", (Object)"value1");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i < 5; ++i) {
            list.add(PROP_VALUE + i);
        }
        this.conf.addProperty("array", list);
        this.saveTestConfig();
        Assert.assertTrue((String)"The saved file doesn't exist", (boolean)testSavePropertiesFile.exists());
        this.checkSavedConfig();
    }

    @Test
    public void testSaveEscapedEscapingCharacter() throws ConfigurationException {
        this.conf.addProperty("test.dirs", (Object)"C:\\Temp\\\\,D:\\Data\\\\,E:\\Test\\");
        List dirs = this.conf.getList("test.dirs");
        Assert.assertEquals((String)"Wrong number of list elements", (long)3L, (long)dirs.size());
        this.saveTestConfig();
        this.checkSavedConfig();
    }

    @Test(expected=ConfigurationException.class)
    public void testSaveMissingFilename() throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.save();
    }

    @Test
    public void testSaveToCustomURL() throws Exception {
        URL url = new URL("foo", "", 0, this.folder.newFile("testsave-custom-url.properties").getAbsolutePath(), new FileURLStreamHandler());
        FileHandler handlerSave = new FileHandler((FileBased)this.conf);
        handlerSave.save(url);
        PropertiesConfiguration config2 = new PropertiesConfiguration();
        FileHandler handlerLoad = new FileHandler((FileBased)config2);
        handlerLoad.load(url);
        Assert.assertEquals((Object)"true", (Object)config2.getString("configuration.loaded"));
    }

    @Test
    public void testSaveToHTTPServerFail() throws Exception {
        MockHttpURLStreamHandler handler = new MockHttpURLStreamHandler(400, testSavePropertiesFile);
        URL url = new URL(null, "http://jakarta.apache.org", handler);
        try {
            new FileHandler((FileBased)this.conf).save(url);
            Assert.fail((String)"Response code was not checked!");
        }
        catch (ConfigurationException cex) {
            Assert.assertTrue((String)("Wrong root cause: " + (Object)((Object)cex)), (boolean)(cex.getCause() instanceof IOException));
        }
    }

    @Test
    public void testSaveToHTTPServerSuccess() throws Exception {
        MockHttpURLStreamHandler handler = new MockHttpURLStreamHandler(200, testSavePropertiesFile);
        URL url = new URL(null, "http://jakarta.apache.org", handler);
        new FileHandler((FileBased)this.conf).save(url);
        MockHttpURLConnection con = handler.getMockConnection();
        Assert.assertTrue((String)"Wrong output flag", (boolean)con.getDoOutput());
        Assert.assertEquals((String)"Wrong method", (Object)"PUT", (Object)con.getRequestMethod());
        this.checkSavedConfig();
    }

    @Test
    public void testSaveWithBasePath() throws Exception {
        this.conf.setProperty("test", (Object)"true");
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.setBasePath(testSavePropertiesFile.getParentFile().toURI().toURL().toString());
        handler.setFileName(testSavePropertiesFile.getName());
        handler.save();
        Assert.assertTrue((boolean)testSavePropertiesFile.exists());
    }

    @Test
    public void testSaveWithDataConfig() throws ConfigurationException {
        this.conf = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.setFile(testSavePropertiesFile);
        DataConfiguration dataConfig = new DataConfiguration((Configuration)this.conf);
        dataConfig.setProperty("foo", (Object)"bar");
        Assert.assertEquals((String)"Property not set", (Object)"bar", (Object)this.conf.getString("foo"));
        handler.save();
        PropertiesConfiguration config2 = new PropertiesConfiguration();
        TestPropertiesConfiguration.load(config2, testSavePropertiesFile.getAbsolutePath());
        Assert.assertEquals((String)"Property not saved", (Object)"bar", (Object)config2.getString("foo"));
    }

    @Test
    public void testSaveWithDefaultListDelimiterHandler() throws ConfigurationException {
        this.conf.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        this.saveTestConfig();
        PropertiesConfiguration checkConfig = new PropertiesConfiguration();
        checkConfig.setListDelimiterHandler(this.conf.getListDelimiterHandler());
        new FileHandler((FileBased)checkConfig).load(testSavePropertiesFile);
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)this.conf, (ImmutableConfiguration)checkConfig);
    }

    @Test
    public void testSaveWithDelimiterParsingDisabled() throws ConfigurationException {
        this.conf.clear();
        this.conf.setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler());
        this.conf.addProperty("test.list", (Object)"a,b,c");
        this.conf.addProperty("test.dirs", (Object)"C:\\Temp\\,D:\\Data\\");
        this.saveTestConfig();
        PropertiesConfiguration checkConfig = new PropertiesConfiguration();
        checkConfig.setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler());
        new FileHandler((FileBased)checkConfig).load(testSavePropertiesFile);
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)this.conf, (ImmutableConfiguration)checkConfig);
    }

    @Test
    public void testSetFooterSynchronized() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.conf.setSynchronizer((Synchronizer)sync);
        this.conf.setFooter("new comment");
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testSetHeaderSynchronized() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.conf.setSynchronizer((Synchronizer)sync);
        this.conf.setHeader("new comment");
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testSetInclude() throws Exception {
        this.conf.clear();
        PropertiesConfiguration.setInclude((String)"import");
        TestPropertiesConfiguration.load(this.conf, testProperties);
        PropertiesConfiguration.setInclude((String)"include");
        Assert.assertNull((Object)this.conf.getString("include.loaded"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetIOFactoryNull() {
        this.conf.setIOFactory(null);
    }

    @Test
    public void testSetIOFactoryReader() throws ConfigurationException {
        int propertyCount = 10;
        this.conf.clear();
        this.conf.setIOFactory(new PropertiesConfiguration.IOFactory(){

            public PropertiesConfiguration.PropertiesReader createPropertiesReader(Reader in) {
                return new PropertiesReaderTestImpl(in, 10);
            }

            public PropertiesConfiguration.PropertiesWriter createPropertiesWriter(Writer out, ListDelimiterHandler handler) {
                throw new UnsupportedOperationException("Unexpected call!");
            }
        });
        TestPropertiesConfiguration.load(this.conf, testProperties);
        for (int i = 1; i <= 10; ++i) {
            Assert.assertEquals((String)("Wrong property value at " + i), (Object)(PROP_VALUE + i), (Object)this.conf.getString(PROP_NAME + i));
        }
    }

    @Test
    public void testSetIOFactoryWriter() throws ConfigurationException, IOException {
        final MutableObject propertiesWriter = new MutableObject();
        this.conf.setIOFactory(new PropertiesConfiguration.IOFactory(){

            public PropertiesConfiguration.PropertiesReader createPropertiesReader(Reader in) {
                throw new UnsupportedOperationException("Unexpected call!");
            }

            public PropertiesConfiguration.PropertiesWriter createPropertiesWriter(Writer out, ListDelimiterHandler handler) {
                try {
                    PropertiesWriterTestImpl propWriter = new PropertiesWriterTestImpl(handler);
                    propertiesWriter.setValue((Object)propWriter);
                    return propWriter;
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
        new FileHandler((FileBased)this.conf).save((Writer)new StringWriter());
        ((Writer)propertiesWriter.getValue()).close();
        this.checkSavedConfig();
    }

    @Test
    public void testSetPropertyListWithDelimiterParsingDisabled() throws ConfigurationException {
        String prop = "delimiterListProp";
        this.conf.setListDelimiterHandler(DisabledListDelimiterHandler.INSTANCE);
        List<String> list = Arrays.asList("val", "val2", "val3");
        this.conf.setProperty("delimiterListProp", list);
        this.saveTestConfig();
        this.conf.clear();
        TestPropertiesConfiguration.load(this.conf, testSavePropertiesFile.getAbsolutePath());
        Assert.assertEquals((String)"Wrong list property", list, (Object)this.conf.getProperty("delimiterListProp"));
    }

    @Test
    public void testSlashEscaping() throws ConfigurationException {
        this.conf.setProperty(PROP_NAME, (Object)"http://www.apache.org");
        StringWriter writer = new StringWriter();
        new FileHandler((FileBased)this.conf).save((Writer)writer);
        String s = writer.toString();
        Assert.assertTrue((String)("Value not found: " + s), (boolean)s.contains("testProperty = http://www.apache.org"));
    }

    @Test
    public void testUnEscapeCharacters() {
        Assert.assertEquals((String)"Wrong value", (Object)"#1 =: me!", (Object)this.conf.getString("test.unescape.characters"));
    }

    @Test
    public void testUnescapeJava() {
        Assert.assertEquals((Object)"test\\,test", (Object)PropertiesConfiguration.unescapeJava((String)"test\\,test"));
    }

    @Test
    public void testWriteFooterComment() throws ConfigurationException, IOException {
        String footer = "my footer";
        this.conf.clear();
        this.conf.setProperty(PROP_NAME, (Object)PROP_VALUE);
        this.conf.setFooter("my footer");
        StringWriter out = new StringWriter();
        this.conf.write((Writer)out);
        Assert.assertEquals((String)"Wrong result", (Object)("testProperty = value" + CR + "# " + "my footer" + CR), (Object)out.toString());
    }

    private static class PropertiesWriterTestImpl
    extends PropertiesConfiguration.PropertiesWriter {
        public PropertiesWriterTestImpl(ListDelimiterHandler handler) throws IOException {
            super((Writer)new FileWriter(testSavePropertiesFile), handler);
        }
    }

    private static class PropertiesReaderTestImpl
    extends PropertiesConfiguration.PropertiesReader {
        private final int maxProperties;
        private int propertyCount;

        public PropertiesReaderTestImpl(Reader reader, int maxProps) {
            super(reader);
            this.maxProperties = maxProps;
        }

        public String getPropertyName() {
            return TestPropertiesConfiguration.PROP_NAME + this.propertyCount;
        }

        public String getPropertyValue() {
            return TestPropertiesConfiguration.PROP_VALUE + this.propertyCount;
        }

        public boolean nextProperty() throws IOException {
            ++this.propertyCount;
            return this.propertyCount <= this.maxProperties;
        }
    }

    static class MockHttpURLStreamHandler
    extends URLStreamHandler {
        private final int responseCode;
        private final File outputFile;
        private MockHttpURLConnection connection;

        public MockHttpURLStreamHandler(int respCode, File outFile) {
            this.responseCode = respCode;
            this.outputFile = outFile;
        }

        public MockHttpURLConnection getMockConnection() {
            return this.connection;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            this.connection = new MockHttpURLConnection(u, this.responseCode, this.outputFile);
            return this.connection;
        }
    }

    static class MockHttpURLConnection
    extends HttpURLConnection {
        private final int returnCode;
        private final File outputFile;

        protected MockHttpURLConnection(URL u, int respCode, File outFile) {
            super(u);
            this.returnCode = respCode;
            this.outputFile = outFile;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public void disconnect() {
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new FileOutputStream(this.outputFile);
        }

        @Override
        public int getResponseCode() throws IOException {
            return this.returnCode;
        }

        @Override
        public boolean usingProxy() {
            return false;
        }
    }

    static class DummyLayout
    extends PropertiesConfigurationLayout {
        public int loadCalls;

        DummyLayout() {
        }

        public void load(PropertiesConfiguration config, Reader in) throws ConfigurationException {
            ++this.loadCalls;
        }
    }
}

