/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.StrictConfigurationComparator;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.commons.configuration2.sync.ReadWriteSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.NodeModel;
import org.apache.commons.configuration2.tree.OverrideCombiner;
import org.apache.commons.configuration2.tree.UnionCombiner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestCombinedConfiguration {
    private static final String TEST_NAME = "SUBCONFIG";
    private static final String TEST_KEY = "test.value";
    private static final String KEY_CONCURRENT = "concurrent.access.test";
    private static final String CHILD1 = "SUBCONFIG1";
    private static final String CHILD2 = "SUBCONFIG2";
    private static final String SUB_KEY = "test.sub.config";
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private CombinedConfiguration config;
    private CombinedListener listener;

    @Before
    public void setUp() throws Exception {
        this.config = new CombinedConfiguration();
        this.listener = new CombinedListener();
        this.config.addEventListener(ConfigurationEvent.ANY, (EventListener)this.listener);
    }

    @Test
    public void testInit() {
        Assert.assertEquals((String)"Already configurations contained", (long)0L, (long)this.config.getNumberOfConfigurations());
        Assert.assertTrue((String)"Set of names is not empty", (boolean)this.config.getConfigurationNames().isEmpty());
        Assert.assertTrue((String)"Wrong node combiner", (boolean)(this.config.getNodeCombiner() instanceof UnionCombiner));
        Assert.assertNull((String)"Test config was found", (Object)this.config.getConfiguration(TEST_NAME));
    }

    @Test
    public void testAddConfiguration() {
        AbstractConfiguration c = TestCombinedConfiguration.setUpTestConfiguration();
        this.config.addConfiguration((Configuration)c);
        this.checkAddConfig(c);
        Assert.assertEquals((String)"Wrong number of configs", (long)1L, (long)this.config.getNumberOfConfigurations());
        Assert.assertTrue((String)"Name list is not empty", (boolean)this.config.getConfigurationNames().isEmpty());
        Assert.assertSame((String)"Added config not found", (Object)c, (Object)this.config.getConfiguration(0));
        Assert.assertTrue((String)"Wrong property value", (boolean)this.config.getBoolean(TEST_KEY));
        this.listener.checkEvent(1, 0);
    }

    @Test
    public void testAddConfigurationWithName() {
        AbstractConfiguration c = TestCombinedConfiguration.setUpTestConfiguration();
        this.config.addConfiguration((Configuration)c, TEST_NAME);
        this.checkAddConfig(c);
        Assert.assertEquals((String)"Wrong number of configs", (long)1L, (long)this.config.getNumberOfConfigurations());
        Assert.assertSame((String)"Added config not found", (Object)c, (Object)this.config.getConfiguration(0));
        Assert.assertSame((String)"Added config not found by name", (Object)c, (Object)this.config.getConfiguration(TEST_NAME));
        Set names = this.config.getConfigurationNames();
        Assert.assertEquals((String)"Wrong number of config names", (long)1L, (long)names.size());
        Assert.assertTrue((String)"Name not found", (boolean)names.contains(TEST_NAME));
        Assert.assertTrue((String)"Wrong property value", (boolean)this.config.getBoolean(TEST_KEY));
        this.listener.checkEvent(1, 0);
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testAddConfigurationWithNameTwice() {
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration(), TEST_NAME);
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration(), TEST_NAME, "prefix");
    }

    @Test
    public void testAddConfigurationAt() {
        AbstractConfiguration c = TestCombinedConfiguration.setUpTestConfiguration();
        this.config.addConfiguration((Configuration)c, null, "my");
        this.checkAddConfig(c);
        Assert.assertTrue((String)"Wrong property value", (boolean)this.config.getBoolean("my.test.value"));
    }

    @Test
    public void testAddConfigurationComplexAt() {
        AbstractConfiguration c = TestCombinedConfiguration.setUpTestConfiguration();
        this.config.addConfiguration((Configuration)c, null, "This..is.a.complex");
        this.checkAddConfig(c);
        Assert.assertTrue((String)"Wrong property value", (boolean)this.config.getBoolean("This..is.a.complex.test.value"));
    }

    private void checkAddConfig(AbstractConfiguration c) {
        Collection listeners = c.getEventListeners(ConfigurationEvent.ANY);
        Assert.assertEquals((String)"Wrong number of configuration listeners", (long)1L, (long)listeners.size());
        Assert.assertTrue((String)"Combined config is no listener", (boolean)listeners.contains(this.config));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNullConfiguration() {
        this.config.addConfiguration(null);
    }

    @Test
    public void testAccessPropertyEmpty() {
        Assert.assertFalse((String)"Found a key", (boolean)this.config.containsKey(TEST_KEY));
        Assert.assertNull((String)"Key has a value", (Object)this.config.getString("test.comment"));
        Assert.assertTrue((String)"Config is not empty", (boolean)this.config.isEmpty());
    }

    @Test
    public void testAccessPropertyMulti() {
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration());
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration(), null, "prefix1");
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration(), null, "prefix2");
        Assert.assertTrue((String)"Prop1 not found", (boolean)this.config.getBoolean(TEST_KEY));
        Assert.assertTrue((String)"Prop 2 not found", (boolean)this.config.getBoolean("prefix1.test.value"));
        Assert.assertTrue((String)"Prop 3 not found", (boolean)this.config.getBoolean("prefix2.test.value"));
        Assert.assertFalse((String)"Configuration is empty", (boolean)this.config.isEmpty());
        this.listener.checkEvent(3, 0);
    }

    @Test
    public void testRemoveConfiguration() {
        AbstractConfiguration c = TestCombinedConfiguration.setUpTestConfiguration();
        this.config.addConfiguration((Configuration)c);
        this.checkAddConfig(c);
        Assert.assertTrue((String)"Config could not be removed", (boolean)this.config.removeConfiguration((Configuration)c));
        this.checkRemoveConfig(c);
    }

    @Test
    public void testRemoveConfigurationAt() {
        AbstractConfiguration c = TestCombinedConfiguration.setUpTestConfiguration();
        this.config.addConfiguration((Configuration)c);
        Assert.assertSame((String)"Wrong config removed", (Object)c, (Object)this.config.removeConfigurationAt(0));
        this.checkRemoveConfig(c);
    }

    @Test
    public void testRemoveConfigurationByName() {
        AbstractConfiguration c = TestCombinedConfiguration.setUpTestConfiguration();
        this.config.addConfiguration((Configuration)c, TEST_NAME);
        Assert.assertSame((String)"Wrong config removed", (Object)c, (Object)this.config.removeConfiguration(TEST_NAME));
        this.checkRemoveConfig(c);
    }

    @Test
    public void testRemoveNamedConfiguration() {
        AbstractConfiguration c = TestCombinedConfiguration.setUpTestConfiguration();
        this.config.addConfiguration((Configuration)c, TEST_NAME);
        this.config.removeConfiguration((Configuration)c);
        this.checkRemoveConfig(c);
    }

    @Test
    public void testRemoveNamedConfigurationAt() {
        AbstractConfiguration c = TestCombinedConfiguration.setUpTestConfiguration();
        this.config.addConfiguration((Configuration)c, TEST_NAME);
        Assert.assertSame((String)"Wrong config removed", (Object)c, (Object)this.config.removeConfigurationAt(0));
        this.checkRemoveConfig(c);
    }

    @Test
    public void testRemoveNonContainedConfiguration() {
        Assert.assertFalse((String)"Could remove non contained config", (boolean)this.config.removeConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration()));
        this.listener.checkEvent(0, 0);
    }

    @Test
    public void testRemoveConfigurationByUnknownName() {
        Assert.assertNull((String)"Could remove configuration by unknown name", (Object)this.config.removeConfiguration("unknownName"));
        this.listener.checkEvent(0, 0);
    }

    private void checkRemoveConfig(AbstractConfiguration c) {
        Assert.assertTrue((String)"Listener was not removed", (boolean)c.getEventListeners(ConfigurationEvent.ANY).isEmpty());
        Assert.assertEquals((String)"Wrong number of contained configs", (long)0L, (long)this.config.getNumberOfConfigurations());
        Assert.assertTrue((String)"Name was not removed", (boolean)this.config.getConfigurationNames().isEmpty());
        this.listener.checkEvent(2, 0);
    }

    @Test
    public void testUpdateContainedConfiguration() {
        AbstractConfiguration c = TestCombinedConfiguration.setUpTestConfiguration();
        this.config.addConfiguration((Configuration)c);
        c.addProperty("test.otherTest", (Object)"yes");
        Assert.assertEquals((String)"New property not found", (Object)"yes", (Object)this.config.getString("test.otherTest"));
        this.listener.checkEvent(2, 0);
    }

    @Test
    public void testSetNodeCombiner() {
        UnionCombiner combiner = new UnionCombiner();
        this.config.setNodeCombiner((NodeCombiner)combiner);
        Assert.assertSame((String)"Node combiner was not set", (Object)combiner, (Object)this.config.getNodeCombiner());
        this.listener.checkEvent(1, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetNullNodeCombiner() {
        this.config.setNodeCombiner(null);
    }

    @Test
    public void testClone() {
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration());
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration(), TEST_NAME, "conf2");
        this.config.addConfiguration((Configuration)new PropertiesConfiguration(), "props");
        CombinedConfiguration cc2 = (CombinedConfiguration)this.config.clone();
        Assert.assertNotNull((String)"No root node", (Object)cc2.getModel().getNodeHandler().getRootNode());
        Assert.assertEquals((String)"Wrong number of contained configurations", (long)this.config.getNumberOfConfigurations(), (long)cc2.getNumberOfConfigurations());
        Assert.assertSame((String)"Wrong node combiner", (Object)this.config.getNodeCombiner(), (Object)cc2.getNodeCombiner());
        Assert.assertEquals((String)"Wrong number of names", (long)this.config.getConfigurationNames().size(), (long)cc2.getConfigurationNames().size());
        Assert.assertTrue((String)"Found duplicate event listeners", (boolean)Collections.disjoint(cc2.getEventListeners(ConfigurationEvent.ANY), this.config.getEventListeners(ConfigurationEvent.ANY)));
        StrictConfigurationComparator comp = new StrictConfigurationComparator();
        for (int i = 0; i < this.config.getNumberOfConfigurations(); ++i) {
            Assert.assertNotSame((String)("Configuration at " + i + " was not cloned"), (Object)this.config.getConfiguration(i), (Object)cc2.getConfiguration(i));
            Assert.assertEquals((String)("Wrong config class at " + i), this.config.getConfiguration(i).getClass(), cc2.getConfiguration(i).getClass());
            Assert.assertTrue((String)("Configs not equal at " + i), (boolean)comp.compare(this.config.getConfiguration(i), cc2.getConfiguration(i)));
        }
        Assert.assertTrue((String)"Combined configs not equal", (boolean)comp.compare((Configuration)this.config, (Configuration)cc2));
    }

    @Test
    public void testCloneModify() {
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration(), TEST_NAME);
        CombinedConfiguration cc2 = (CombinedConfiguration)this.config.clone();
        Assert.assertTrue((String)"Name is missing", (boolean)cc2.getConfigurationNames().contains(TEST_NAME));
        cc2.removeConfiguration(TEST_NAME);
        Assert.assertFalse((String)"Names in original changed", (boolean)this.config.getConfigurationNames().isEmpty());
    }

    @Test
    public void testClear() {
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration(), TEST_NAME, "test");
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration());
        this.config.clear();
        Assert.assertEquals((String)"Still configs contained", (long)0L, (long)this.config.getNumberOfConfigurations());
        Assert.assertTrue((String)"Still names contained", (boolean)this.config.getConfigurationNames().isEmpty());
        Assert.assertTrue((String)"Config is not empty", (boolean)this.config.isEmpty());
        this.listener.checkEvent(3, 2);
    }

    @Test
    public void testClearRemoveChildListener() {
        AbstractConfiguration child = TestCombinedConfiguration.setUpTestConfiguration();
        this.config.addConfiguration((Configuration)child);
        this.config.clear();
        for (EventListener listener : child.getEventListeners(ConfigurationEvent.ANY)) {
            Assert.assertNotEquals((String)"Still registered", (Object)this.config, (Object)listener);
        }
    }

    private void setUpSourceTest() {
        BaseHierarchicalConfiguration c1 = new BaseHierarchicalConfiguration();
        PropertiesConfiguration c2 = new PropertiesConfiguration();
        c1.addProperty(TEST_KEY, (Object)TEST_NAME);
        c2.addProperty("another.key", (Object)"test");
        this.config.addConfiguration((Configuration)c1, CHILD1);
        this.config.addConfiguration((Configuration)c2, CHILD2);
    }

    @Test
    public void testGetSourceHierarchical() {
        this.setUpSourceTest();
        Assert.assertEquals((String)"Wrong source configuration", (Object)this.config.getConfiguration(CHILD1), (Object)this.config.getSource(TEST_KEY));
    }

    @Test
    public void testGetSourceNonHierarchical() {
        this.setUpSourceTest();
        Assert.assertEquals((String)"Wrong source configuration", (Object)this.config.getConfiguration(CHILD2), (Object)this.config.getSource("another.key"));
    }

    @Test
    public void testGetSourceUnknown() {
        this.setUpSourceTest();
        Assert.assertNull((String)"Wrong result for unknown key", (Object)this.config.getSource("an.unknown.key"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetSourceNull() {
        this.config.getSource(null);
    }

    @Test
    public void testGetSourceCombined() {
        this.setUpSourceTest();
        String key = "yet.another.key";
        this.config.addProperty("yet.another.key", (Object)Boolean.TRUE);
        Assert.assertEquals((String)"Wrong source for key", (Object)this.config, (Object)this.config.getSource("yet.another.key"));
    }

    @Test
    public void testGetSourceMulti() {
        this.setUpSourceTest();
        String key = "list.key";
        this.config.getConfiguration(CHILD1).addProperty("list.key", (Object)"1,2,3");
        Assert.assertEquals((String)"Wrong source for multi-value property", (Object)this.config.getConfiguration(CHILD1), (Object)this.config.getSource("list.key"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetSourceMultiSources() {
        this.setUpSourceTest();
        String key = "list.key";
        this.config.getConfiguration(CHILD1).addProperty("list.key", (Object)"1,2,3");
        this.config.getConfiguration(CHILD2).addProperty("list.key", (Object)"a,b,c");
        this.config.getSource("list.key");
    }

    @Test
    public void testGetSourceWithCombinedChildConfiguration() {
        this.setUpSourceTest();
        CombinedConfiguration cc = new CombinedConfiguration();
        cc.addConfiguration((Configuration)this.config);
        Assert.assertEquals((String)"Wrong source", (Object)this.config, (Object)cc.getSource(TEST_KEY));
    }

    @Test
    public void testGetSourcesMultiSources() {
        this.setUpSourceTest();
        String key = "list.key";
        this.config.getConfiguration(CHILD1).addProperty("list.key", (Object)"1,2,3");
        this.config.getConfiguration(CHILD2).addProperty("list.key", (Object)"a,b,c");
        Set sources = this.config.getSources("list.key");
        Assert.assertEquals((String)"Wrong number of sources", (long)2L, (long)sources.size());
        Assert.assertTrue((String)"Source 1 not found", (boolean)sources.contains(this.config.getConfiguration(CHILD1)));
        Assert.assertTrue((String)"Source 2 not found", (boolean)sources.contains(this.config.getConfiguration(CHILD2)));
    }

    @Test
    public void testGetSourcesUnknownKey() {
        this.setUpSourceTest();
        Assert.assertTrue((String)"Got sources", (boolean)this.config.getSources("non.existing,key").isEmpty());
    }

    @Test
    public void testEscapeListDelimiters() {
        PropertiesConfiguration sub = new PropertiesConfiguration();
        sub.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        sub.addProperty("test.pi", (Object)"3\\,1415");
        this.config.addConfiguration((Configuration)sub);
        Assert.assertEquals((String)"Wrong value", (Object)"3,1415", (Object)this.config.getString("test.pi"));
    }

    @Test
    public void testInvalidateEventBeforeAndAfterChange() {
        ConfigurationEvent event = new ConfigurationEvent((Object)this.config, ConfigurationEvent.ANY, null, null, true);
        this.config.onEvent(event);
        Assert.assertEquals((String)"No invalidate event fired", (long)1L, (long)this.listener.invalidateEvents);
        event = new ConfigurationEvent((Object)this.config, ConfigurationEvent.ANY, null, null, false);
        this.config.onEvent(event);
        Assert.assertEquals((String)"Another invalidate event fired", (long)1L, (long)this.listener.invalidateEvents);
    }

    @Test
    public void testConversionExpressionEngine() {
        PropertiesConfiguration child = new PropertiesConfiguration();
        child.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        child.addProperty("test(a)", (Object)"1,2,3");
        this.config.addConfiguration((Configuration)child);
        DefaultExpressionEngine engineQuery = new DefaultExpressionEngine(new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS).setIndexStart("<").setIndexEnd(">").create());
        this.config.setExpressionEngine((ExpressionEngine)engineQuery);
        DefaultExpressionEngine engineConvert = new DefaultExpressionEngine(new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS).setIndexStart("[").setIndexEnd("]").create());
        this.config.setConversionExpressionEngine((ExpressionEngine)engineConvert);
        Assert.assertEquals((String)"Wrong property 1", (Object)"1", (Object)this.config.getString("test(a)<0>"));
        Assert.assertEquals((String)"Wrong property 2", (Object)"2", (Object)this.config.getString("test(a)<1>"));
        Assert.assertEquals((String)"Wrong property 3", (Object)"3", (Object)this.config.getString("test(a)<2>"));
    }

    @Test
    public void testGetConfigurations() throws Exception {
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration());
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration(), TEST_NAME, "conf2");
        PropertiesConfiguration pc = new PropertiesConfiguration();
        this.config.addConfiguration((Configuration)pc, "props");
        List list = this.config.getConfigurations();
        Assert.assertNotNull((String)"No list of configurations returned", (Object)list);
        Assert.assertTrue((String)"Incorrect number of configurations", (list.size() == 3 ? 1 : 0) != 0);
        Configuration c = (Configuration)list.get(2);
        Assert.assertTrue((String)"Incorrect configuration", (c == pc ? 1 : 0) != 0);
    }

    @Test
    public void testGetConfigurationNameList() throws Exception {
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration());
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration(), TEST_NAME, "conf2");
        PropertiesConfiguration pc = new PropertiesConfiguration();
        this.config.addConfiguration((Configuration)pc, "props");
        List list = this.config.getConfigurationNameList();
        Assert.assertNotNull((String)"No list of configurations returned", (Object)list);
        Assert.assertTrue((String)"Incorrect number of configurations", (list.size() == 3 ? 1 : 0) != 0);
        String name = (String)list.get(1);
        Assert.assertNotNull((String)"No name returned", (Object)name);
        Assert.assertTrue((String)"Incorrect configuration name", (boolean)TEST_NAME.equals(name));
    }

    @Test
    public void testCombinedCopyToXML() throws ConfigurationException {
        XMLConfiguration x1 = new XMLConfiguration();
        x1.addProperty("key1", (Object)"value1");
        x1.addProperty("key1[@override]", (Object)"USER1");
        x1.addProperty("key2", (Object)"value2");
        x1.addProperty("key2[@override]", (Object)"USER2");
        XMLConfiguration x2 = new XMLConfiguration();
        x2.addProperty("key2", (Object)"value2.2");
        x2.addProperty("key2[@override]", (Object)"USER2");
        this.config.setNodeCombiner((NodeCombiner)new OverrideCombiner());
        this.config.addConfiguration((Configuration)x2);
        this.config.addConfiguration((Configuration)x1);
        XMLConfiguration x3 = new XMLConfiguration((HierarchicalConfiguration)this.config);
        Assert.assertEquals((String)"Wrong element value", (Object)"value2.2", (Object)x3.getString("key2"));
        Assert.assertEquals((String)"Wrong attribute value", (Object)"USER2", (Object)x3.getString("key2[@override]"));
        StringWriter w = new StringWriter();
        new FileHandler((FileBased)x3).save((Writer)w);
        String s = w.toString();
        x3 = new XMLConfiguration();
        new FileHandler((FileBased)x3).load((Reader)new StringReader(s));
        Assert.assertEquals((String)"Wrong element value after load", (Object)"value2.2", (Object)x3.getString("key2"));
        Assert.assertEquals((String)"Wrong attribute value after load", (Object)"USER2", (Object)x3.getString("key2[@override]"));
    }

    private SynchronizerTestImpl setUpSynchronizerTest() {
        this.setUpSourceTest();
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.config.setSynchronizer((Synchronizer)sync);
        return sync;
    }

    @Test
    public void testAddConfigurationSynchronized() {
        SynchronizerTestImpl sync = this.setUpSynchronizerTest();
        this.config.addConfiguration((Configuration)new BaseHierarchicalConfiguration());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
        this.checkCombinedRootNotConstructed();
    }

    @Test
    public void testSetNodeCombinerSynchronized() {
        SynchronizerTestImpl sync = this.setUpSynchronizerTest();
        this.config.setNodeCombiner((NodeCombiner)new UnionCombiner());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
        this.checkCombinedRootNotConstructed();
    }

    @Test
    public void testGetNodeCombinerSynchronized() {
        SynchronizerTestImpl sync = this.setUpSynchronizerTest();
        Assert.assertNotNull((String)"No node combiner", (Object)this.config.getNodeCombiner());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
        this.checkCombinedRootNotConstructed();
    }

    @Test
    public void testGetConfigurationByIdxSynchronized() {
        SynchronizerTestImpl sync = this.setUpSynchronizerTest();
        Assert.assertNotNull((String)"No configuration", (Object)this.config.getConfiguration(0));
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
        this.checkCombinedRootNotConstructed();
    }

    @Test
    public void testGetConfigurationByNameSynchronized() {
        SynchronizerTestImpl sync = this.setUpSynchronizerTest();
        Assert.assertNotNull((String)"No configuration", (Object)this.config.getConfiguration(CHILD1));
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
        this.checkCombinedRootNotConstructed();
    }

    @Test
    public void testGetConfigurationNamesSynchronized() {
        SynchronizerTestImpl sync = this.setUpSynchronizerTest();
        Assert.assertFalse((String)"No child names", (boolean)this.config.getConfigurationNames().isEmpty());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
        this.checkCombinedRootNotConstructed();
    }

    @Test
    public void testGetConfigurationNameListSynchronized() {
        SynchronizerTestImpl sync = this.setUpSynchronizerTest();
        Assert.assertFalse((String)"No child names", (boolean)this.config.getConfigurationNameList().isEmpty());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
        this.checkCombinedRootNotConstructed();
    }

    private void checkCombinedRootNotConstructed() {
        Assert.assertTrue((String)"Root node was constructed", (boolean)((ImmutableNode)this.config.getModel().getNodeHandler().getRootNode()).getChildren().isEmpty());
    }

    @Test
    public void testGetConfigurationsSynchronized() {
        SynchronizerTestImpl sync = this.setUpSynchronizerTest();
        Assert.assertFalse((String)"No child configurations", (boolean)this.config.getConfigurations().isEmpty());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
        this.checkCombinedRootNotConstructed();
    }

    @Test
    public void testGetConversionExpressionEngineSynchronized() {
        SynchronizerTestImpl sync = this.setUpSynchronizerTest();
        Assert.assertNull((String)"Got a conversion engine", (Object)this.config.getConversionExpressionEngine());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
        this.checkCombinedRootNotConstructed();
    }

    @Test
    public void testSetConversionExpressionEngineSynchronized() {
        SynchronizerTestImpl sync = this.setUpSynchronizerTest();
        this.config.setConversionExpressionEngine((ExpressionEngine)new DefaultExpressionEngine(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS));
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
        this.checkCombinedRootNotConstructed();
    }

    @Test
    public void testInvalidateSynchronized() {
        SynchronizerTestImpl sync = this.setUpSynchronizerTest();
        this.config.invalidate();
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testGetSourceSynchronized() {
        SynchronizerTestImpl sync = this.setUpSynchronizerTest();
        Assert.assertNotNull((String)"No source found", (Object)this.config.getSource(TEST_KEY));
        sync.verifyStart(SynchronizerTestImpl.Methods.BEGIN_READ);
        sync.verifyEnd(SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetNumberOfConfigurationsSynchronized() {
        SynchronizerTestImpl sync = this.setUpSynchronizerTest();
        Assert.assertEquals((String)"Wrong number of configurations", (long)2L, (long)this.config.getNumberOfConfigurations());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
        this.checkCombinedRootNotConstructed();
    }

    @Test
    public void testCloneSynchronized() {
        this.setUpSourceTest();
        this.config.lock(LockMode.READ);
        this.config.unlock(LockMode.READ);
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.config.setSynchronizer((Synchronizer)sync);
        this.config.clone();
        sync.verifyStart(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.BEGIN_READ);
        sync.verifyEnd(SynchronizerTestImpl.Methods.END_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testLockHandlingWithExceptionWhenConstructingRootNode() {
        SynchronizerTestImpl sync = this.setUpSynchronizerTest();
        ConfigurationRuntimeException testEx = new ConfigurationRuntimeException("Test exception");
        BaseHierarchicalConfiguration childEx = new BaseHierarchicalConfiguration((RuntimeException)testEx){
            final /* synthetic */ RuntimeException val$testEx;
            {
                this.val$testEx = runtimeException;
            }

            public NodeModel<ImmutableNode> getModel() {
                throw this.val$testEx;
            }
        };
        this.config.addConfiguration((Configuration)childEx);
        try {
            this.config.lock(LockMode.READ);
            Assert.fail((String)"Exception not detected!");
        }
        catch (Exception ex) {
            Assert.assertEquals((String)"Unexpected exception", (Object)testEx, (Object)ex);
        }
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE, SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ, SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testConcurrentAccess() throws ConfigurationException, InterruptedException {
        this.setUpSourceTest();
        XMLConfiguration xmlConf = new XMLConfiguration();
        new FileHandler((FileBased)xmlConf).load(ConfigurationAssert.getTestFile("test.xml"));
        this.config.addConfiguration((Configuration)xmlConf);
        PropertiesConfiguration propConf = new PropertiesConfiguration();
        new FileHandler((FileBased)propConf).load(ConfigurationAssert.getTestFile("test.properties"));
        for (int i = 0; i < 8; ++i) {
            this.config.addConfiguration((Configuration)new BaseHierarchicalConfiguration());
        }
        this.config.getConfiguration(0).addProperty(KEY_CONCURRENT, (Object)TEST_NAME);
        ReadWriteSynchronizer sync = new ReadWriteSynchronizer();
        this.config.setSynchronizer((Synchronizer)sync);
        for (Configuration c : this.config.getConfigurations()) {
            c.setSynchronizer((Synchronizer)sync);
        }
        int numberOfReaders = 3;
        int readCount = 5000;
        int writeCount = 3000;
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger errorCount = new AtomicInteger();
        ArrayList<Thread> threads = new ArrayList<Thread>(4);
        WriteThread writeThread = new WriteThread(this.config, latch, errorCount, 3000);
        writeThread.start();
        threads.add(writeThread);
        for (int i = 0; i < 3; ++i) {
            ReadThread readThread = new ReadThread((Configuration)this.config, latch, errorCount, 5000);
            readThread.start();
            threads.add(readThread);
        }
        latch.countDown();
        for (Thread t : threads) {
            t.join();
        }
        Assert.assertEquals((String)"Got errors", (long)0L, (long)errorCount.get());
    }

    private AbstractConfiguration setUpSubConfigTest() {
        AbstractConfiguration srcConfig = TestCombinedConfiguration.setUpTestConfiguration();
        this.config.addConfiguration((Configuration)srcConfig, "source", SUB_KEY);
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration());
        this.config.addConfiguration((Configuration)TestCombinedConfiguration.setUpTestConfiguration(), "otherTest", "other.prefix");
        return srcConfig;
    }

    @Test
    public void testSubConfigurationWithUpdates() {
        AbstractConfiguration srcConfig = this.setUpSubConfigTest();
        HierarchicalConfiguration sub = this.config.configurationAt(SUB_KEY, true);
        Assert.assertTrue((String)"Wrong value before update", (boolean)sub.getBoolean(TEST_KEY));
        srcConfig.setProperty(TEST_KEY, (Object)Boolean.FALSE);
        Assert.assertFalse((String)"Wrong value after update", (boolean)sub.getBoolean(TEST_KEY));
        Assert.assertFalse((String)"Wrong value from combined configuration", (boolean)this.config.getBoolean("test.sub.config.test.value"));
    }

    private void checkConfigurationsAt(boolean withUpdates) {
        this.setUpSubConfigTest();
        List subs = this.config.configurationsAt(SUB_KEY, withUpdates);
        Assert.assertEquals((String)"Wrong number of sub configurations", (long)1L, (long)subs.size());
        Assert.assertTrue((String)"Wrong value in sub configuration", (boolean)((HierarchicalConfiguration)subs.get(0)).getBoolean(TEST_KEY));
    }

    @Test
    public void testConfigurationsAt() {
        this.checkConfigurationsAt(false);
    }

    @Test
    public void testConfigurationsAtWithUpdates() {
        this.checkConfigurationsAt(true);
    }

    private static AbstractConfiguration setUpTestConfiguration() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty(TEST_KEY, (Object)Boolean.TRUE);
        config.addProperty("test.comment", (Object)"This is a test");
        return config;
    }

    private static class WriteThread
    extends Thread {
        private final List<Configuration> testConfigs;
        private final CountDownLatch startLatch;
        private final AtomicInteger errorCount;
        private final int numberOfWrites;
        private int currentChildConfigIdx;

        public WriteThread(CombinedConfiguration cc, CountDownLatch latch, AtomicInteger errCnt, int writeCount) {
            this.testConfigs = cc.getConfigurations();
            this.startLatch = latch;
            this.errorCount = errCnt;
            this.numberOfWrites = writeCount;
        }

        @Override
        public void run() {
            try {
                this.startLatch.await();
                for (int i = 0; i < this.numberOfWrites; ++i) {
                    this.updateConfigurations();
                }
            }
            catch (InterruptedException e) {
                this.errorCount.incrementAndGet();
            }
        }

        private void updateConfigurations() {
            int newIdx = (this.currentChildConfigIdx + 1) % this.testConfigs.size();
            this.testConfigs.get(newIdx).addProperty(TestCombinedConfiguration.KEY_CONCURRENT, (Object)TestCombinedConfiguration.TEST_NAME);
            this.testConfigs.get(this.currentChildConfigIdx).clearProperty(TestCombinedConfiguration.KEY_CONCURRENT);
            this.currentChildConfigIdx = newIdx;
        }
    }

    private static class ReadThread
    extends Thread {
        private final Configuration config;
        private final CountDownLatch startLatch;
        private final AtomicInteger errorCount;
        private final int numberOfReads;

        public ReadThread(Configuration readConfig, CountDownLatch latch, AtomicInteger errCnt, int readCount) {
            this.config = readConfig;
            this.startLatch = latch;
            this.errorCount = errCnt;
            this.numberOfReads = readCount;
        }

        @Override
        public void run() {
            try {
                this.startLatch.await();
                for (int i = 0; i < this.numberOfReads; ++i) {
                    this.readConfiguration();
                }
            }
            catch (Exception e) {
                this.errorCount.incrementAndGet();
            }
        }

        private void readConfiguration() {
            List values = this.config.getList(TestCombinedConfiguration.KEY_CONCURRENT);
            if (values.size() < 1 || values.size() > 2) {
                this.errorCount.incrementAndGet();
            } else {
                boolean ok = true;
                for (Object value : values) {
                    if (TestCombinedConfiguration.TEST_NAME.equals(value)) continue;
                    ok = false;
                }
                if (!ok) {
                    this.errorCount.incrementAndGet();
                }
            }
        }
    }

    private static class CombinedListener
    implements EventListener<ConfigurationEvent> {
        int invalidateEvents;
        int otherEvents;

        private CombinedListener() {
        }

        public void onEvent(ConfigurationEvent event) {
            if (event.getEventType() == CombinedConfiguration.COMBINED_INVALIDATE) {
                ++this.invalidateEvents;
            } else {
                ++this.otherEvents;
            }
        }

        public void checkEvent(int expectedInvalidate, int expectedOthers) {
            Assert.assertEquals((String)"Wrong number of invalidate events", (long)expectedInvalidate, (long)this.invalidateEvents);
            Assert.assertEquals((String)"Wrong number of other events", (long)expectedOthers, (long)this.otherEvents);
        }
    }
}

