/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.interpol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.DefaultLookups;
import org.apache.commons.configuration2.interpol.InterpolatorSpecification;
import org.apache.commons.configuration2.interpol.Lookup;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationInterpolator {
    private static final String TEST_PREFIX = "prefix";
    private static final String TEST_NAME = "varname";
    private static final String TEST_VALUE = "TestVariableValue";
    private ConfigurationInterpolator interpolator;

    @Before
    public void setUp() throws Exception {
        this.interpolator = new ConfigurationInterpolator();
    }

    private static Lookup setUpTestLookup() {
        return TestConfigurationInterpolator.setUpTestLookup(TEST_NAME, TEST_VALUE);
    }

    private static Lookup setUpTestLookup(final String var, final Object value) {
        Lookup lookup = (Lookup)EasyMock.createMock(Lookup.class);
        EasyMock.expect((Object)lookup.lookup((String)EasyMock.anyObject(String.class))).andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                if (var.equals(EasyMock.getCurrentArguments()[0])) {
                    return value;
                }
                return null;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{lookup});
        return lookup;
    }

    @Test
    public void testInit() {
        Assert.assertTrue((String)"A default lookup is set", (boolean)this.interpolator.getDefaultLookups().isEmpty());
        Assert.assertTrue((String)"Got predefined lookups", (boolean)this.interpolator.getLookups().isEmpty());
        Assert.assertNull((String)"Got a parent interpolator", (Object)this.interpolator.getParentInterpolator());
    }

    @Test
    public void testRegisterLookup() {
        Lookup lookup = (Lookup)EasyMock.createMock(Lookup.class);
        EasyMock.replay((Object[])new Object[]{lookup});
        this.interpolator.registerLookup(TEST_PREFIX, lookup);
        Assert.assertSame((String)"New lookup not registered", (Object)lookup, this.interpolator.getLookups().get(TEST_PREFIX));
        Assert.assertTrue((String)"Not in prefix set", (boolean)this.interpolator.prefixSet().contains(TEST_PREFIX));
        Assert.assertTrue((String)"Default lookups were changed", (boolean)this.interpolator.getDefaultLookups().isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterLookupNull() {
        this.interpolator.registerLookup(TEST_PREFIX, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterLookupNullPrefix() {
        this.interpolator.registerLookup(null, (Lookup)EasyMock.createMock(Lookup.class));
    }

    @Test
    public void testDeregisterLookup() {
        Lookup lookup = (Lookup)EasyMock.createMock(Lookup.class);
        EasyMock.replay((Object[])new Object[]{lookup});
        this.interpolator.registerLookup(TEST_PREFIX, lookup);
        Assert.assertTrue((String)"Derigstration not successfull", (boolean)this.interpolator.deregisterLookup(TEST_PREFIX));
        Assert.assertFalse((String)"Deregistered prefix still contained", (boolean)this.interpolator.prefixSet().contains(TEST_PREFIX));
        Assert.assertTrue((String)"Lookups not empty", (boolean)this.interpolator.getLookups().isEmpty());
    }

    @Test
    public void testDeregisterLookupNonExisting() {
        Assert.assertFalse((String)"Could deregister unknown lookup", (boolean)this.interpolator.deregisterLookup(TEST_PREFIX));
    }

    @Test
    public void testResolveWithPrefix() {
        this.interpolator.registerLookup(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup());
        Assert.assertEquals((String)"Wrong variable value", (Object)TEST_VALUE, (Object)this.interpolator.resolve("prefix:varname"));
    }

    @Test
    public void testResolveWithUnknownPrefix() {
        this.interpolator.registerLookup(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup());
        Assert.assertNull((String)"Variable could be resolved", (Object)this.interpolator.resolve("UnknownPrefix:varname"));
        Assert.assertNull((String)"Variable with empty prefix could be resolved", (Object)this.interpolator.resolve(":varname"));
    }

    @Test
    public void testResolveDefault() {
        Lookup l1 = (Lookup)EasyMock.createMock(Lookup.class);
        Lookup l2 = (Lookup)EasyMock.createMock(Lookup.class);
        Lookup l3 = (Lookup)EasyMock.createMock(Lookup.class);
        EasyMock.expect((Object)l1.lookup(TEST_NAME)).andReturn(null);
        EasyMock.expect((Object)l2.lookup(TEST_NAME)).andReturn((Object)TEST_VALUE);
        EasyMock.replay((Object[])new Object[]{l1, l2, l3});
        this.interpolator.addDefaultLookups(Arrays.asList(l1, l2, l3));
        Assert.assertEquals((String)"Wrong variable value", (Object)TEST_VALUE, (Object)this.interpolator.resolve(TEST_NAME));
        EasyMock.verify((Object[])new Object[]{l1, l2, l3});
    }

    @Test
    public void testResolveNoDefault() {
        Assert.assertNull((String)"Variable could be resolved", (Object)this.interpolator.resolve(TEST_NAME));
    }

    @Test
    public void testResolveEmptyPrefix() {
        this.interpolator.registerLookup("", TestConfigurationInterpolator.setUpTestLookup());
        Assert.assertEquals((String)"Wrong variable value", (Object)TEST_VALUE, (Object)this.interpolator.resolve(":varname"));
    }

    @Test
    public void testResolveEmptyVarName() {
        this.interpolator.registerLookup(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup("", TEST_VALUE));
        Assert.assertEquals((String)"Wrong variable value", (Object)TEST_VALUE, (Object)this.interpolator.resolve("prefix:"));
    }

    @Test
    public void testResolveDefaultEmptyVarName() {
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("", TEST_VALUE));
        Assert.assertEquals((String)"Wrong variable value", (Object)TEST_VALUE, (Object)this.interpolator.resolve(""));
    }

    @Test
    public void testResolveNull() {
        Assert.assertNull((String)"Could resolve null variable", (Object)this.interpolator.resolve(null));
    }

    @Test
    public void testResolveDefaultAfterPrefixFails() {
        String varName = "prefix:varname2";
        this.interpolator.registerLookup(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup());
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("prefix:varname2", TEST_VALUE));
        Assert.assertEquals((String)"Variable is not resolved by default lookup", (Object)TEST_VALUE, (Object)this.interpolator.resolve("prefix:varname2"));
    }

    @Test
    public void testRegisterLookups() {
        Lookup l1 = TestConfigurationInterpolator.setUpTestLookup();
        Lookup l2 = TestConfigurationInterpolator.setUpTestLookup("someVar", "someValue");
        HashMap<String, Lookup> lookups = new HashMap<String, Lookup>();
        lookups.put(TEST_PREFIX, l1);
        String prefix2 = "prefix_other";
        lookups.put("prefix_other", l2);
        this.interpolator.registerLookups(lookups);
        Map lookups2 = this.interpolator.getLookups();
        Assert.assertEquals((String)"Wrong number of lookups", (long)2L, (long)lookups2.size());
        Assert.assertEquals((String)"Wrong l1", (Object)l1, lookups2.get(TEST_PREFIX));
        Assert.assertEquals((String)"Wrong l2", (Object)l2, lookups2.get("prefix_other"));
    }

    @Test
    public void testRegisterLookupsNull() {
        this.interpolator.registerLookups(null);
        Assert.assertTrue((String)"Got lookups", (boolean)this.interpolator.getLookups().isEmpty());
    }

    @Test
    public void testGetLookupsModify() {
        Map lookups = this.interpolator.getLookups();
        lookups.put(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup());
        Assert.assertTrue((String)"Map was modified", (boolean)this.interpolator.getLookups().isEmpty());
    }

    @Test
    public void testAddDefaultLookups() {
        ArrayList<Lookup> lookups = new ArrayList<Lookup>();
        lookups.add(TestConfigurationInterpolator.setUpTestLookup());
        lookups.add(TestConfigurationInterpolator.setUpTestLookup("test", "value"));
        this.interpolator.addDefaultLookups(lookups);
        List lookups2 = this.interpolator.getDefaultLookups();
        Assert.assertEquals((String)"Wrong number of default lookups", (long)2L, (long)lookups2.size());
        Assert.assertTrue((String)"Wrong content", (boolean)lookups2.containsAll(lookups));
    }

    @Test
    public void testAddDefaultLookupsNull() {
        this.interpolator.addDefaultLookups(null);
        Assert.assertTrue((String)"Got default lookups", (boolean)this.interpolator.getDefaultLookups().isEmpty());
    }

    @Test
    public void testGetDefaultLookupsModify() {
        List lookups = this.interpolator.getDefaultLookups();
        lookups.add(TestConfigurationInterpolator.setUpTestLookup());
        Assert.assertTrue((String)"List was modified", (boolean)this.interpolator.getDefaultLookups().isEmpty());
    }

    @Test
    public void testRemoveDefaultLookup() {
        ArrayList<Lookup> lookups = new ArrayList<Lookup>();
        lookups.add(TestConfigurationInterpolator.setUpTestLookup());
        lookups.add(TestConfigurationInterpolator.setUpTestLookup("test", "value"));
        this.interpolator.addDefaultLookups(lookups);
        Assert.assertTrue((String)"Wrong result", (boolean)this.interpolator.removeDefaultLookup((Lookup)lookups.get(0)));
        Assert.assertFalse((String)"Lookup still available", (boolean)this.interpolator.getDefaultLookups().contains(lookups.get(0)));
        Assert.assertEquals((String)"Wrong number of default lookups", (long)1L, (long)this.interpolator.getDefaultLookups().size());
    }

    @Test
    public void testRemoveDefaultLookupNonExisting() {
        Assert.assertFalse((String)"Wrong result", (boolean)this.interpolator.removeDefaultLookup(TestConfigurationInterpolator.setUpTestLookup()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPrefixSetModify() {
        this.interpolator.registerLookup(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup());
        Iterator it = this.interpolator.prefixSet().iterator();
        it.next();
        it.remove();
    }

    @Test
    public void testResolveParentVariableFound() {
        ConfigurationInterpolator parent = (ConfigurationInterpolator)EasyMock.createMock(ConfigurationInterpolator.class);
        EasyMock.replay((Object[])new Object[]{parent});
        this.interpolator.setParentInterpolator(parent);
        this.interpolator.registerLookup(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup());
        Assert.assertEquals((String)"Wrong value", (Object)TEST_VALUE, (Object)this.interpolator.resolve("prefix:varname"));
    }

    @Test
    public void testResolveParentVariableNotFound() {
        ConfigurationInterpolator parent = (ConfigurationInterpolator)EasyMock.createMock(ConfigurationInterpolator.class);
        EasyMock.expect((Object)parent.resolve(TEST_NAME)).andReturn((Object)TEST_VALUE);
        EasyMock.replay((Object[])new Object[]{parent});
        this.interpolator.setParentInterpolator(parent);
        Assert.assertEquals((String)"Wrong value", (Object)TEST_VALUE, (Object)this.interpolator.resolve(TEST_NAME));
        EasyMock.verify((Object[])new Object[]{parent});
    }

    @Test
    public void testInterpolateObject() {
        Integer value = 42;
        Assert.assertSame((String)"Value was changed", (Object)value, (Object)this.interpolator.interpolate((Object)value));
    }

    @Test
    public void testInterpolateString() {
        String value = "${prefix:varname}";
        this.interpolator.registerLookup(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup());
        Assert.assertEquals((String)"Wrong result", (Object)TEST_VALUE, (Object)this.interpolator.interpolate((Object)"${prefix:varname}"));
    }

    @Test
    public void testInterpolateStringUnknownVariable() {
        String value = "${unknownVariable}";
        Assert.assertEquals((String)"Wrong result", (Object)"${unknownVariable}", (Object)this.interpolator.interpolate((Object)"${unknownVariable}"));
    }

    @Test
    public void testEnableSubstitutionInVariables() {
        Assert.assertFalse((String)"Variable substitution enabled", (boolean)this.interpolator.isEnableSubstitutionInVariables());
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("java.version", "1.4"));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("jre-1.4", "C:\\java\\1.4"));
        String var = "${jre-${java.version}}";
        Assert.assertEquals((String)"Wrong result (1)", (Object)"${jre-${java.version}}", (Object)this.interpolator.interpolate((Object)"${jre-${java.version}}"));
        this.interpolator.setEnableSubstitutionInVariables(true);
        Assert.assertTrue((String)"Variable substitution not enabled", (boolean)this.interpolator.isEnableSubstitutionInVariables());
        Assert.assertEquals((String)"Wrong result (2)", (Object)"C:\\java\\1.4", (Object)this.interpolator.interpolate((Object)"${jre-${java.version}}"));
    }

    @Test
    public void testInterpolationMultipleVariables() {
        String value = "The ${subject} jumps over ${object}.";
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("subject", "quick brown fox"));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("object", "the lazy dog"));
        Assert.assertEquals((String)"Wrong result", (Object)"The quick brown fox jumps over the lazy dog.", (Object)this.interpolator.interpolate((Object)"The ${subject} jumps over ${object}."));
    }

    @Test
    public void testInterpolationSingleVariable() {
        Integer value = 42;
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup(TEST_NAME, value));
        Assert.assertEquals((String)"Wrong result", (Object)value, (Object)this.interpolator.interpolate((Object)"${varname}"));
    }

    @Test
    public void testInterpolationVariableIncomplete() {
        String value = "${varname";
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup(TEST_NAME, "someValue"));
        Assert.assertEquals((String)"Wrong result", (Object)"${varname", (Object)this.interpolator.interpolate((Object)"${varname"));
    }

    @Test
    public void testInterpolateEmptyVariable() {
        String value = "${}";
        Assert.assertEquals((String)"Wrong result", (Object)"${}", (Object)this.interpolator.interpolate((Object)"${}"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromSpecificationNull() {
        ConfigurationInterpolator.fromSpecification(null);
    }

    @Test
    public void testFromSpecificationInterpolator() {
        ConfigurationInterpolator ci = (ConfigurationInterpolator)EasyMock.createMock(ConfigurationInterpolator.class);
        EasyMock.replay((Object[])new Object[]{ci});
        InterpolatorSpecification spec = new InterpolatorSpecification.Builder().withDefaultLookup((Lookup)EasyMock.createMock(Lookup.class)).withParentInterpolator(this.interpolator).withInterpolator(ci).create();
        Assert.assertSame((String)"Wrong result", (Object)ci, (Object)ConfigurationInterpolator.fromSpecification((InterpolatorSpecification)spec));
    }

    @Test
    public void testFromSpecificationNewInstance() {
        Lookup defLookup = (Lookup)EasyMock.createMock(Lookup.class);
        Lookup preLookup = (Lookup)EasyMock.createMock(Lookup.class);
        EasyMock.replay((Object[])new Object[]{defLookup, preLookup});
        InterpolatorSpecification spec = new InterpolatorSpecification.Builder().withDefaultLookup(defLookup).withPrefixLookup("p", preLookup).withParentInterpolator(this.interpolator).create();
        ConfigurationInterpolator ci = ConfigurationInterpolator.fromSpecification((InterpolatorSpecification)spec);
        Assert.assertEquals((String)"Wrong number of default lookups", (long)1L, (long)ci.getDefaultLookups().size());
        Assert.assertTrue((String)"Wrong default lookup", (boolean)ci.getDefaultLookups().contains(defLookup));
        Assert.assertEquals((String)"Wrong number of prefix lookups", (long)1L, (long)ci.getLookups().size());
        Assert.assertSame((String)"Wrong prefix lookup", (Object)preLookup, ci.getLookups().get("p"));
        Assert.assertSame((String)"Wrong parent", (Object)this.interpolator, (Object)ci.getParentInterpolator());
    }

    @Test
    public void testGetDefaultPrefixLookups() {
        Map lookups = ConfigurationInterpolator.getDefaultPrefixLookups();
        Assert.assertEquals((String)"Wrong number of lookups", (long)DefaultLookups.values().length, (long)lookups.size());
        for (DefaultLookups l : DefaultLookups.values()) {
            Assert.assertSame((String)("Wrong entry for " + l), (Object)l.getLookup(), lookups.get(l.getPrefix()));
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetDefaultPrefixLookupsModify() {
        ConfigurationInterpolator.getDefaultPrefixLookups().put("test", EasyMock.createMock(Lookup.class));
    }

    @Test
    public void testNullSafeLookupExisting() {
        Lookup look = (Lookup)EasyMock.createMock(Lookup.class);
        EasyMock.replay((Object[])new Object[]{look});
        Assert.assertSame((String)"Wrong result", (Object)look, (Object)ConfigurationInterpolator.nullSafeLookup((Lookup)look));
    }

    @Test
    public void testNullSafeLookupNull() {
        Lookup lookup = ConfigurationInterpolator.nullSafeLookup(null);
        Assert.assertNull((String)"Got a lookup result", (Object)lookup.lookup("someVar"));
    }
}

