/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.io.File;
import java.util.Collection;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.CombinedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.ReloadingCombinedConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.reloading.CombinedReloadingController;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.apache.commons.configuration2.reloading.ReloadingControllerSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestReloadingCombinedConfigurationBuilder {
    private ReloadingCombinedConfigurationBuilder builder;

    @Before
    public void setUp() throws Exception {
        this.builder = new ReloadingCombinedConfigurationBuilder();
    }

    @Test
    public void testNoReloadableSources() throws ConfigurationException {
        File testFile = ConfigurationAssert.getTestFile("testDigesterConfiguration.xml");
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setDefinitionBuilder((ConfigurationBuilder)new FileBasedConfigurationBuilder(XMLConfiguration.class)).setDefinitionBuilderParameters((BuilderParameters)new FileBasedBuilderParametersImpl().setFile(testFile))});
        this.builder.getConfiguration();
        CombinedReloadingController rc = (CombinedReloadingController)this.builder.getReloadingController();
        Assert.assertTrue((String)"Got sub reloading controllers", (boolean)rc.getSubControllers().isEmpty());
    }

    @Test
    public void testReloadableDefinitionBuilder() throws ConfigurationException {
        File testFile = ConfigurationAssert.getTestFile("testDigesterConfiguration.xml");
        ReloadingCombinedConfigurationBuilder confBuilder = this.builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(testFile)});
        Assert.assertSame((String)"Wrong configured builder instance", (Object)this.builder, (Object)confBuilder);
        this.builder.getConfiguration();
        CombinedReloadingController rc = (CombinedReloadingController)this.builder.getReloadingController();
        Collection subControllers = rc.getSubControllers();
        Assert.assertEquals((String)"Wrong number of sub controllers", (long)1L, (long)subControllers.size());
        ReloadingController subctrl = ((ReloadingControllerSupport)this.builder.getDefinitionBuilder()).getReloadingController();
        Assert.assertSame((String)"Wrong sub controller", (Object)subctrl, subControllers.iterator().next());
    }

    @Test
    public void testNestedReloadableSources() throws ConfigurationException {
        File testFile = ConfigurationAssert.getTestFile("testCCReloadingNested.xml");
        this.builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(testFile)});
        this.builder.getConfiguration();
        CombinedReloadingController rc = (CombinedReloadingController)this.builder.getReloadingController();
        Collection subControllers = rc.getSubControllers();
        Assert.assertEquals((String)"Wrong number of sub controllers", (long)2L, (long)subControllers.size());
        ReloadingControllerSupport ccBuilder = (ReloadingControllerSupport)this.builder.getNamedBuilder("cc");
        Assert.assertTrue((String)"Sub controller not found", (boolean)subControllers.contains(ccBuilder.getReloadingController()));
        CombinedReloadingController rc2 = (CombinedReloadingController)ccBuilder.getReloadingController();
        Assert.assertEquals((String)"Wrong number of sub controllers (2)", (long)3L, (long)rc2.getSubControllers().size());
    }

    @Test
    public void testInitWithParameters() throws ConfigurationException {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        params.setFile(ConfigurationAssert.getTestFile("testDigesterConfiguration.xml"));
        this.builder = new ReloadingCombinedConfigurationBuilder(params.getParameters());
        CombinedConfiguration cc = this.builder.getConfiguration();
        Assert.assertTrue((String)"Property not found", (boolean)cc.getBoolean("test.boolean"));
    }

    @Test
    public void testInitWithFailOnInitFlag() {
        this.builder = new ReloadingCombinedConfigurationBuilder(null, true);
        Assert.assertTrue((String)"Flag not set", (boolean)this.builder.isAllowFailOnInit());
    }
}

