/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.io.File;
import java.net.URL;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.io.AbsoluteNameLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAbsoluteNameLocationStrategy {
    private FileSystem fileSystem;
    private AbsoluteNameLocationStrategy strategy;

    @Before
    public void setUp() throws Exception {
        this.fileSystem = (FileSystem)EasyMock.createMock(FileSystem.class);
        EasyMock.replay((Object[])new Object[]{this.fileSystem});
        this.strategy = new AbsoluteNameLocationStrategy();
    }

    @Test
    public void testNoFileName() {
        FileLocator locator = FileLocatorUtils.fileLocator().create();
        Assert.assertNull((String)"Got a URL", (Object)this.strategy.locate(this.fileSystem, locator));
    }

    @Test
    public void testNoAbsoluteFileName() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName("test.xml").create();
        Assert.assertNull((String)"Got a URL", (Object)this.strategy.locate(this.fileSystem, locator));
    }

    @Test
    public void testNonExistingAbsoluteFile() {
        File file = ConfigurationAssert.getOutFile("NotExistingFile.tst");
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(file.getAbsolutePath()).create();
        Assert.assertNull((String)"Got a URL", (Object)this.strategy.locate(this.fileSystem, locator));
    }

    @Test
    public void testExistingAbsoluteFile() {
        File file = ConfigurationAssert.getTestFile("test.xml");
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(file.getAbsolutePath()).create();
        URL url = this.strategy.locate(this.fileSystem, locator);
        Assert.assertEquals((String)"Wrong URL", (Object)file.getAbsoluteFile(), (Object)FileLocatorUtils.fileFromURL((URL)url).getAbsoluteFile());
    }
}

