/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.beanutils;

import org.apache.commons.configuration2.beanutils.BeanDeclaration;
import org.apache.commons.configuration2.beanutils.ConstructorArg;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestConstructorArg {
    @Test(expected=NullPointerException.class)
    public void testForBeanDeclarationNull() {
        ConstructorArg.forBeanDeclaration(null);
    }

    @Test
    public void testIsNestedBeanDeclarationTrue() {
        BeanDeclaration decl = (BeanDeclaration)EasyMock.createMock(BeanDeclaration.class);
        EasyMock.replay((Object[])new Object[]{decl});
        ConstructorArg arg = ConstructorArg.forBeanDeclaration((BeanDeclaration)decl);
        Assert.assertTrue((String)"No bean declaration", (boolean)arg.isNestedBeanDeclaration());
    }

    @Test
    public void testIsNestedBeanDeclarationFalse() {
        ConstructorArg arg = ConstructorArg.forValue((Object)"test");
        Assert.assertFalse((String)"A bean declaration", (boolean)arg.isNestedBeanDeclaration());
    }

    @Test
    public void testMatchesNoType() {
        ConstructorArg arg = ConstructorArg.forValue((Object)42);
        Assert.assertTrue((String)"No match (1)", (boolean)arg.matches(String.class));
        Assert.assertTrue((String)"No match (2)", (boolean)arg.matches(this.getClass()));
    }

    @Test
    public void testMatchesWithType() {
        ConstructorArg arg = ConstructorArg.forValue((Object)"42", (String)Integer.TYPE.getName());
        Assert.assertTrue((String)"Wrong result (1)", (boolean)arg.matches(Integer.TYPE));
        Assert.assertFalse((String)"Wrong result (2)", (boolean)arg.matches(Integer.class));
        Assert.assertFalse((String)"Wrong result (3)", (boolean)arg.matches(String.class));
    }

    @Test
    public void testMatchesNull() {
        ConstructorArg arg = ConstructorArg.forValue((Object)0);
        Assert.assertFalse((String)"Wrong result", (boolean)arg.matches(null));
    }
}

