/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.reloading;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.configuration2.reloading.CombinedReloadingController;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestCombinedReloadingController {
    private ReloadingController[] subControllers;

    private void initSubControllers() {
        this.subControllers = new ReloadingController[3];
        for (int i = 0; i < this.subControllers.length; ++i) {
            this.subControllers[i] = (ReloadingController)EasyMock.createMock(ReloadingController.class);
        }
    }

    private void replaySubControllers() {
        EasyMock.replay((Object[])this.subControllers);
    }

    private void verifySubSontrollers() {
        EasyMock.verify((Object[])this.subControllers);
    }

    private CombinedReloadingController setUpController() {
        this.initSubControllers();
        ArrayList<ReloadingController> lstCtrls = new ArrayList<ReloadingController>(Arrays.asList(this.subControllers));
        CombinedReloadingController result = new CombinedReloadingController(lstCtrls);
        lstCtrls.clear();
        return result;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNull() {
        new CombinedReloadingController(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNullEntries() {
        this.initSubControllers();
        ArrayList<ReloadingController> ctrls = new ArrayList<ReloadingController>(Arrays.asList(this.subControllers));
        ctrls.add(null);
        new CombinedReloadingController(ctrls);
    }

    @Test
    public void testCheckForReloadingTrue() {
        CombinedReloadingController ctrl = this.setUpController();
        EasyMock.expect((Object)this.subControllers[0].checkForReloading(null)).andReturn((Object)Boolean.FALSE);
        EasyMock.expect((Object)this.subControllers[1].checkForReloading(null)).andReturn((Object)Boolean.TRUE);
        this.replaySubControllers();
        Assert.assertTrue((String)"Wrong result", (boolean)ctrl.checkForReloading((Object)"someData"));
        this.verifySubSontrollers();
    }

    @Test
    public void testCheckForReloadingFalse() {
        CombinedReloadingController ctrl = this.setUpController();
        for (ReloadingController rc : this.subControllers) {
            EasyMock.expect((Object)rc.checkForReloading(null)).andReturn((Object)Boolean.FALSE);
        }
        this.replaySubControllers();
        Assert.assertFalse((String)"Wrong result", (boolean)ctrl.checkForReloading((Object)"someParam"));
        this.verifySubSontrollers();
    }

    @Test
    public void testResetReloadingState() {
        CombinedReloadingController ctrl = this.setUpController();
        EasyMock.expect((Object)this.subControllers[0].checkForReloading(null)).andReturn((Object)Boolean.TRUE);
        for (ReloadingController rc : this.subControllers) {
            rc.resetReloadingState();
        }
        this.replaySubControllers();
        ctrl.checkForReloading(null);
        ctrl.resetReloadingState();
        this.verifySubSontrollers();
    }

    @Test
    public void testResetInitialReloadingState() {
        CombinedReloadingController ctrl = this.setUpController();
        for (ReloadingController rc : this.subControllers) {
            rc.resetReloadingState();
        }
        this.replaySubControllers();
        ctrl.resetInitialReloadingState();
        this.verifySubSontrollers();
    }

    @Test
    public void testGetSubControllers() {
        CombinedReloadingController ctrl = this.setUpController();
        this.replaySubControllers();
        Collection subs = ctrl.getSubControllers();
        Assert.assertEquals((String)"Wrong number of sub controllers", (long)this.subControllers.length, (long)subs.size());
        Assert.assertTrue((String)"Wrong sub controllers", (boolean)subs.containsAll(Arrays.asList(this.subControllers)));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetSubControllersModify() {
        Collection subs = this.setUpController().getSubControllers();
        subs.clear();
    }
}

