/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.plist;

import java.io.Reader;
import java.util.Calendar;
import java.util.SimpleTimeZone;
import junitx.framework.ArrayAssert;
import org.apache.commons.configuration2.plist.PropertyListParser;
import org.junit.Assert;
import org.junit.Test;

public class TestPropertyListParser {
    private final PropertyListParser parser = new PropertyListParser((Reader)null);

    @Test
    public void testRemoveQuotes() {
        Assert.assertEquals((String)"unquoted string", (Object)"abc", (Object)this.parser.removeQuotes("abc"));
        Assert.assertEquals((String)"quoted string", (Object)"abc", (Object)this.parser.removeQuotes("\"abc\""));
        Assert.assertEquals((String)"empty quotes", (Object)"", (Object)this.parser.removeQuotes("\"\""));
        Assert.assertEquals((String)"empty string", (Object)"", (Object)this.parser.removeQuotes(""));
        Assert.assertEquals((String)"null string", null, (Object)this.parser.removeQuotes(null));
    }

    @Test
    public void testUnescapeQuotes() {
        Assert.assertEquals((String)"non escaped quotes", (Object)"aaa\"bbb\"ccc", (Object)this.parser.unescapeQuotes("aaa\"bbb\"ccc"));
        Assert.assertEquals((String)"escaped quotes", (Object)"aaa\"bbb\"ccc", (Object)this.parser.unescapeQuotes("aaa\\\"bbb\\\"ccc"));
    }

    @Test
    public void testParseDate() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2002);
        calendar.set(2, 2);
        calendar.set(5, 22);
        calendar.set(11, 11);
        calendar.set(12, 30);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.setTimeZone(new SimpleTimeZone(3600000, "Apache/Jakarta"));
        Assert.assertEquals((String)"parsed date", (Object)calendar.getTime(), (Object)this.parser.parseDate("<*D2002-03-22 11:30:00 +0100>"));
    }

    @Test
    public void testFilterData() throws Exception {
        byte[] expected = new byte[]{32, 32};
        ArrayAssert.assertEquals((String)"null string", null, (byte[])this.parser.filterData(null));
        ArrayAssert.assertEquals((String)"data with < >", (byte[])expected, (byte[])this.parser.filterData("<2020>"));
        ArrayAssert.assertEquals((String)"data without < >", (byte[])expected, (byte[])this.parser.filterData("2020"));
        ArrayAssert.assertEquals((String)"data with space", (byte[])expected, (byte[])this.parser.filterData("20 20"));
        ArrayAssert.assertEquals((String)"odd length", (byte[])new byte[]{9, 32}, (byte[])this.parser.filterData("920"));
    }
}

