/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.event;

import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.configuration2.event.ConfigurationErrorEvent;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventType;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurationEventTypes {
    @Test
    public void testFetchSuperEventTypesNull() {
        Set superTypes = EventType.fetchSuperEventTypes(null);
        Assert.assertTrue((String)"Got super types", (boolean)superTypes.isEmpty());
    }

    @Test
    public void testFetchSuperEventTypesForBaseType() {
        Set superTypes = EventType.fetchSuperEventTypes((EventType)Event.ANY);
        Assert.assertEquals((String)"Wrong number of super types", (long)1L, (long)superTypes.size());
        Assert.assertTrue((String)"Wrong super types", (boolean)superTypes.contains(Event.ANY));
    }

    @Test
    public void testFetchSuperEventTypesOfType() {
        Set superTypes = EventType.fetchSuperEventTypes((EventType)ConfigurationEvent.ADD_NODES);
        LinkedList<EventType> expected = new LinkedList<EventType>();
        expected.add(ConfigurationEvent.ADD_NODES);
        expected.add(ConfigurationEvent.ANY_HIERARCHICAL);
        expected.add(ConfigurationEvent.ANY);
        expected.add(Event.ANY);
        Assert.assertEquals((String)"Wrong number of super types", (long)expected.size(), (long)superTypes.size());
        Assert.assertTrue((String)("Wrong super types: " + superTypes), (boolean)superTypes.containsAll(expected));
    }

    @Test
    public void testIsInstanceOfDerivedNull() {
        Assert.assertFalse((String)"Wrong result", (boolean)EventType.isInstanceOf(null, (EventType)Event.ANY));
    }

    @Test
    public void testIsInstanceOfBaseNull() {
        Assert.assertFalse((String)"Wrong result", (boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ANY, null));
    }

    @Test
    public void testIsInstanceOfFalse() {
        Assert.assertFalse((String)"Wrong result", (boolean)EventType.isInstanceOf((EventType)ConfigurationErrorEvent.READ, (EventType)ConfigurationEvent.ANY));
    }

    @Test
    public void testIsInstanceOfTrue() {
        Assert.assertTrue((String)"Wrong result (1)", (boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ADD_NODES, (EventType)ConfigurationEvent.ANY_HIERARCHICAL));
        Assert.assertTrue((String)"Wrong result (2)", (boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ADD_NODES, (EventType)ConfigurationEvent.ANY));
        Assert.assertTrue((String)"Wrong result (3)", (boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ADD_NODES, (EventType)Event.ANY));
        Assert.assertTrue((String)"Wrong result (4)", (boolean)EventType.isInstanceOf((EventType)ConfigurationEvent.ADD_NODES, (EventType)ConfigurationEvent.ADD_NODES));
    }

    @Test
    public void testConfigurationEventType() {
        Assert.assertSame((String)"Wrong super type", (Object)Event.ANY, (Object)ConfigurationEvent.ANY.getSuperType());
    }

    private void checkUpdateEvent(EventType<ConfigurationEvent> eventType) {
        Assert.assertSame((String)("Wrong super type for " + eventType), (Object)ConfigurationEvent.ANY, (Object)eventType.getSuperType());
    }

    @Test
    public void testAddPropertyEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.ADD_PROPERTY);
    }

    @Test
    public void testSetPropertyEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.SET_PROPERTY);
    }

    @Test
    public void testClearPropertyEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.CLEAR_PROPERTY);
    }

    @Test
    public void testClearEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.CLEAR);
    }

    @Test
    public void testHierarchicalEventType() {
        this.checkUpdateEvent((EventType<ConfigurationEvent>)ConfigurationEvent.ANY_HIERARCHICAL);
    }

    private void checkHierarchicalEvent(EventType<ConfigurationEvent> eventType) {
        Assert.assertSame((String)("Wrong super type for " + eventType), (Object)ConfigurationEvent.ANY_HIERARCHICAL, (Object)eventType.getSuperType());
    }

    @Test
    public void testAddNodesEventType() {
        this.checkHierarchicalEvent((EventType<ConfigurationEvent>)ConfigurationEvent.ADD_NODES);
    }

    @Test
    public void testClearTreeEventType() {
        this.checkHierarchicalEvent((EventType<ConfigurationEvent>)ConfigurationEvent.CLEAR_TREE);
    }

    @Test
    public void testSubnodeChangedEventType() {
        this.checkHierarchicalEvent((EventType<ConfigurationEvent>)ConfigurationEvent.SUBNODE_CHANGED);
    }

    @Test
    public void testBaseErrorEventType() {
        Assert.assertEquals((String)"Wrong super type", (Object)Event.ANY, (Object)ConfigurationErrorEvent.ANY.getSuperType());
    }

    private void checkErrorEvent(EventType<ConfigurationErrorEvent> type) {
        Assert.assertSame((String)("Wrong super type for " + type), (Object)ConfigurationErrorEvent.ANY, (Object)type.getSuperType());
    }

    @Test
    public void testReadErrorEventType() {
        this.checkErrorEvent((EventType<ConfigurationErrorEvent>)ConfigurationErrorEvent.READ);
    }

    @Test
    public void testWriteErrorEventType() {
        this.checkErrorEvent((EventType<ConfigurationErrorEvent>)ConfigurationErrorEvent.WRITE);
    }
}

