/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.util.Arrays;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.BaseConfigurationBuilderProvider;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.ConfigurationDeclaration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.junit.Assert;
import org.junit.Test;

public class TestBaseConfigurationBuilderProvider {
    private HierarchicalConfiguration<?> setUpConfig(boolean reload) {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty("[@config-reload]", (Object)reload);
        config.addProperty("[@throwExceptionOnMissing]", (Object)Boolean.TRUE);
        config.addProperty("[@path]", (Object)ConfigurationAssert.getTestFile("test.properties").getAbsolutePath());
        config.addProperty("listDelimiterHandler[@config-class]", (Object)DefaultListDelimiterHandler.class.getName());
        config.addProperty("listDelimiterHandler.config-constrarg[@config-value]", (Object)";");
        return config;
    }

    private ConfigurationDeclaration createDeclaration(HierarchicalConfiguration<?> declConfig) {
        CombinedConfigurationBuilder parentBuilder = new CombinedConfigurationBuilder(){

            protected void initChildBuilderParameters(BuilderParameters params) {
                if (params instanceof BasicBuilderParameters) {
                    ((BasicBuilderParameters)params).setListDelimiterHandler(DisabledListDelimiterHandler.INSTANCE);
                }
            }
        };
        ConfigurationDeclaration decl = new ConfigurationDeclaration(parentBuilder, declConfig){

            protected Object interpolate(Object value) {
                return value;
            }
        };
        return decl;
    }

    private BaseConfigurationBuilderProvider createProvider() {
        return new BaseConfigurationBuilderProvider(FileBasedConfigurationBuilder.class.getName(), ReloadingFileBasedConfigurationBuilder.class.getName(), PropertiesConfiguration.class.getName(), Arrays.asList(FileBasedBuilderParametersImpl.class.getName()));
    }

    private ConfigurationBuilder<? extends Configuration> checkBuilder(boolean reload) throws ConfigurationException {
        HierarchicalConfiguration<?> declConfig = this.setUpConfig(reload);
        ConfigurationDeclaration decl = this.createDeclaration(declConfig);
        ConfigurationBuilder builder = this.createProvider().getConfigurationBuilder(decl);
        Configuration config = (Configuration)builder.getConfiguration();
        Assert.assertEquals((String)"Wrong configuration class", PropertiesConfiguration.class, config.getClass());
        PropertiesConfiguration pconfig = (PropertiesConfiguration)config;
        Assert.assertTrue((String)"Wrong exception flag", (boolean)pconfig.isThrowExceptionOnMissing());
        DefaultListDelimiterHandler listHandler = (DefaultListDelimiterHandler)pconfig.getListDelimiterHandler();
        Assert.assertEquals((String)"Wrong list delimiter", (long)59L, (long)listHandler.getDelimiter());
        Assert.assertTrue((String)"Configuration not loaded", (boolean)pconfig.getBoolean("configuration.loaded"));
        return builder;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNoBuilderClass() {
        new BaseConfigurationBuilderProvider(null, null, PropertiesConfiguration.class.getName(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNoConfigurationClass() {
        new BaseConfigurationBuilderProvider(BasicConfigurationBuilder.class.getName(), null, null, null);
    }

    @Test
    public void testGetBuilderNotReloading() throws ConfigurationException {
        ConfigurationBuilder<? extends Configuration> builder = this.checkBuilder(false);
        Assert.assertEquals((String)"Wrong builder class", FileBasedConfigurationBuilder.class, builder.getClass());
    }

    @Test
    public void testGetBuilderReloading() throws ConfigurationException {
        ConfigurationBuilder<? extends Configuration> builder = this.checkBuilder(true);
        Assert.assertEquals((String)"Wrong builder class", ReloadingFileBasedConfigurationBuilder.class, builder.getClass());
    }

    @Test(expected=ConfigurationException.class)
    public void testGetReloadingBuilderNotSupported() throws ConfigurationException {
        BaseConfigurationBuilderProvider provider = new BaseConfigurationBuilderProvider(FileBasedConfigurationBuilder.class.getName(), null, PropertiesConfiguration.class.getName(), Arrays.asList(FileBasedBuilderParametersImpl.class.getName()));
        HierarchicalConfiguration<?> declConfig = this.setUpConfig(true);
        ConfigurationDeclaration decl = this.createDeclaration(declConfig);
        provider.getConfigurationBuilder(decl);
    }

    private void checkAllowFailOnInit(boolean expFlag, String ... props) throws ConfigurationException {
        HierarchicalConfiguration<?> declConfig = this.setUpConfig(false);
        for (String key : props) {
            declConfig.addProperty(key, (Object)Boolean.TRUE);
        }
        ConfigurationDeclaration decl = this.createDeclaration(declConfig);
        BasicConfigurationBuilder builder = (BasicConfigurationBuilder)this.createProvider().getConfigurationBuilder(decl);
        Assert.assertEquals((String)"Wrong flag value", (Object)expFlag, (Object)builder.isAllowFailOnInit());
    }

    @Test
    public void testGetBuilderNoFailOnInit() throws ConfigurationException {
        this.checkAllowFailOnInit(false, new String[0]);
    }

    public void testGetBuilderAllowFailOnInitNotOptional() throws ConfigurationException {
        this.checkAllowFailOnInit(false, "[@config-forceCreate]");
    }

    @Test
    public void testGetBuilderAllowFailOnInit() throws ConfigurationException {
        this.checkAllowFailOnInit(true, "[@config-optional]", "[@config-forceCreate]");
    }

    @Test
    public void testInitNoParameterClasses() {
        BaseConfigurationBuilderProvider provider = new BaseConfigurationBuilderProvider(BasicConfigurationBuilder.class.getName(), null, PropertiesConfiguration.class.getName(), null);
        Assert.assertTrue((String)"Got parameter classes", (boolean)provider.getParameterClasses().isEmpty());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetParameterClassesModify() {
        BaseConfigurationBuilderProvider provider = new BaseConfigurationBuilderProvider(BasicConfigurationBuilder.class.getName(), null, PropertiesConfiguration.class.getName(), Arrays.asList(BasicBuilderParameters.class.getName()));
        provider.getParameterClasses().clear();
    }
}

