/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.HashMap;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderEventListenerImpl;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.ReloadingDetectorFactory;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.reloading.FileHandlerReloadingDetector;
import org.apache.commons.configuration2.reloading.ReloadingDetector;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestReloadingFileBasedConfigurationBuilder {
    @Test
    public void testGetConfigurationNoLocation() throws ConfigurationException {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("throwExceptionOnMissing", Boolean.TRUE);
        ReloadingFileBasedConfigurationBuilder builder = new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class, params);
        PropertiesConfiguration conf = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertTrue((String)"Property not set", (boolean)conf.isThrowExceptionOnMissing());
        Assert.assertTrue((String)"Not empty", (boolean)conf.isEmpty());
    }

    @Test
    public void testCreateReloadingDetectorDefaultFactory() throws ConfigurationException {
        ReloadingFileBasedConfigurationBuilder builder = new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class);
        FileHandler handler = new FileHandler();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        long refreshDelay = 60000L;
        params.setReloadingRefreshDelay(Long.valueOf(refreshDelay));
        FileHandlerReloadingDetector detector = (FileHandlerReloadingDetector)builder.createReloadingDetector(handler, params);
        Assert.assertSame((String)"Wrong file handler", (Object)handler, (Object)detector.getFileHandler());
        Assert.assertEquals((String)"Wrong refresh delay", (long)refreshDelay, (long)detector.getRefreshDelay());
    }

    @Test
    public void testCreateReloadingDetectoryCustomFactory() throws ConfigurationException {
        ReloadingDetector detector = (ReloadingDetector)EasyMock.createMock(ReloadingDetector.class);
        ReloadingDetectorFactory factory = (ReloadingDetectorFactory)EasyMock.createMock(ReloadingDetectorFactory.class);
        FileHandler handler = new FileHandler();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        EasyMock.expect((Object)factory.createReloadingDetector(handler, params)).andReturn((Object)detector);
        EasyMock.replay((Object[])new Object[]{detector, factory});
        params.setReloadingDetectorFactory(factory);
        ReloadingFileBasedConfigurationBuilder builder = new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class);
        Assert.assertSame((String)"Wrong detector", (Object)detector, (Object)builder.createReloadingDetector(handler, params));
        EasyMock.verify((Object[])new Object[]{factory});
    }

    @Test
    public void testReloadingDetectorIsReloadingRequired() throws ConfigurationException {
        ReloadingDetector detector = (ReloadingDetector)EasyMock.createMock(ReloadingDetector.class);
        EasyMock.expect((Object)detector.isReloadingRequired()).andReturn((Object)Boolean.TRUE);
        EasyMock.expect((Object)detector.isReloadingRequired()).andReturn((Object)Boolean.FALSE);
        EasyMock.replay((Object[])new Object[]{detector});
        ReloadingFileBasedConfigurationBuilderTestImpl builder = new ReloadingFileBasedConfigurationBuilderTestImpl(detector);
        builder.getConfiguration();
        ReloadingDetector ctrlDetector = builder.getReloadingController().getDetector();
        Assert.assertTrue((String)"Wrong result (1)", (boolean)ctrlDetector.isReloadingRequired());
        Assert.assertFalse((String)"Wrong result (2)", (boolean)ctrlDetector.isReloadingRequired());
        Assert.assertSame((String)"Wrong file handler", (Object)builder.getFileHandler(), (Object)builder.getHandlerForDetector());
        EasyMock.verify((Object[])new Object[]{detector});
    }

    @Test
    public void testReloadingDetectorReloadingPerformed() throws ConfigurationException {
        ReloadingDetector detector = (ReloadingDetector)EasyMock.createMock(ReloadingDetector.class);
        detector.reloadingPerformed();
        EasyMock.replay((Object[])new Object[]{detector});
        ReloadingFileBasedConfigurationBuilderTestImpl builder = new ReloadingFileBasedConfigurationBuilderTestImpl(detector);
        builder.getConfiguration();
        ReloadingDetector ctrlDetector = builder.getReloadingController().getDetector();
        ctrlDetector.reloadingPerformed();
        EasyMock.verify((Object[])new Object[]{detector});
    }

    @Test
    public void testReloadingDetectorNoFileHandler() {
        ReloadingFileBasedConfigurationBuilder builder = new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class);
        ReloadingDetector ctrlDetector = builder.getReloadingController().getDetector();
        ctrlDetector.reloadingPerformed();
        Assert.assertFalse((String)"Wrong result", (boolean)ctrlDetector.isReloadingRequired());
    }

    @Test
    public void testResetReloadingStateInGetConfiguration() throws ConfigurationException {
        ReloadingDetector detector = (ReloadingDetector)EasyMock.createMock(ReloadingDetector.class);
        EasyMock.expect((Object)detector.isReloadingRequired()).andReturn((Object)Boolean.TRUE);
        detector.reloadingPerformed();
        EasyMock.replay((Object[])new Object[]{detector});
        ReloadingFileBasedConfigurationBuilderTestImpl builder = new ReloadingFileBasedConfigurationBuilderTestImpl(detector);
        PropertiesConfiguration config1 = (PropertiesConfiguration)builder.getConfiguration();
        builder.getReloadingController().checkForReloading(null);
        PropertiesConfiguration config2 = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertNotSame((String)"No new configuration instance", (Object)config1, (Object)config2);
        Assert.assertFalse((String)"Still in reloading state", (boolean)builder.getReloadingController().isInReloadingState());
        EasyMock.verify((Object[])new Object[]{detector});
    }

    @Test
    public void testReloadingControllerEvents() throws ConfigurationException {
        ReloadingDetector detector = (ReloadingDetector)EasyMock.createMock(ReloadingDetector.class);
        EasyMock.expect((Object)detector.isReloadingRequired()).andReturn((Object)Boolean.TRUE);
        ReloadingFileBasedConfigurationBuilderTestImpl builder = new ReloadingFileBasedConfigurationBuilderTestImpl(detector);
        EasyMock.replay((Object[])new Object[]{detector});
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        builder.addEventListener(ConfigurationBuilderEvent.RESET, listener);
        builder.getConfiguration();
        builder.getReloadingController().checkForReloading(null);
        listener.nextEvent(ConfigurationBuilderEvent.RESET);
        listener.assertNoMoreEvents();
        EasyMock.verify((Object[])new Object[]{detector});
    }

    @Test
    public void testInitAllowFailOnInitFlag() {
        ReloadingFileBasedConfigurationBuilder builder = new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class, null, true);
        Assert.assertTrue((String)"Flag not set", (boolean)builder.isAllowFailOnInit());
    }

    private static class ReloadingFileBasedConfigurationBuilderTestImpl
    extends ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration> {
        private final ReloadingDetector mockDetector;
        private FileHandler handlerForDetector;

        public ReloadingFileBasedConfigurationBuilderTestImpl(ReloadingDetector detector) {
            super(PropertiesConfiguration.class);
            this.mockDetector = detector;
        }

        public FileHandler getHandlerForDetector() {
            return this.handlerForDetector;
        }

        protected ReloadingDetector createReloadingDetector(FileHandler handler, FileBasedBuilderParametersImpl fbparams) {
            this.handlerForDetector = handler;
            return this.mockDetector;
        }
    }
}

