/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderEventListenerImpl;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.ReloadingBuilderSupportListener;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventType;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.apache.commons.configuration2.reloading.ReloadingDetector;
import org.apache.commons.configuration2.reloading.ReloadingEvent;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestReloadingBuilderSupportListener {
    @Test
    public void testResetBuilderOnReloadingEvent() {
        ReloadingDetector detector = (ReloadingDetector)EasyMock.createMock(ReloadingDetector.class);
        EasyMock.expect((Object)detector.isReloadingRequired()).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{detector});
        ReloadingController controller = new ReloadingController(detector);
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        BuilderEventListenerImpl builderListener = new BuilderEventListenerImpl();
        builder.addEventListener(ConfigurationBuilderEvent.ANY, (EventListener)builderListener);
        ReloadingBuilderSupportListener listener = ReloadingBuilderSupportListener.connect((BasicConfigurationBuilder)builder, (ReloadingController)controller);
        Assert.assertNotNull((String)"No listener returned", (Object)listener);
        controller.checkForReloading(null);
        builderListener.nextEvent(ConfigurationBuilderEvent.RESET);
        builderListener.assertNoMoreEvents();
    }

    @Test
    public void testResetReloadingStateOnResultCreation() throws ConfigurationException {
        ReloadingController controller = (ReloadingController)EasyMock.createMock(ReloadingController.class);
        controller.addEventListener((EventType)EasyMock.eq((Object)ReloadingEvent.ANY), (EventListener)EasyMock.anyObject(EventListener.class));
        controller.resetReloadingState();
        EasyMock.replay((Object[])new Object[]{controller});
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        ReloadingBuilderSupportListener listener = ReloadingBuilderSupportListener.connect((BasicConfigurationBuilder)builder, (ReloadingController)controller);
        Assert.assertNotNull((String)"No listener returned", (Object)listener);
        builder.getConfiguration();
        EasyMock.verify((Object[])new Object[]{controller});
    }
}

