/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.beanutils;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.beanutils.BeanCreationContext;
import org.apache.commons.configuration2.beanutils.BeanCreationTestBean;
import org.apache.commons.configuration2.beanutils.BeanCreationTestCtorBean;
import org.apache.commons.configuration2.beanutils.BeanDeclaration;
import org.apache.commons.configuration2.beanutils.BeanDeclarationTestImpl;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.beanutils.ConstructorArg;
import org.apache.commons.configuration2.beanutils.DefaultBeanFactory;
import org.apache.commons.configuration2.convert.ConversionHandler;
import org.apache.commons.configuration2.convert.DefaultConversionHandler;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultBeanFactory {
    private static final String TEST_STRING = "testString";
    private static final int TEST_INT = 42;
    private DefaultBeanFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new DefaultBeanFactory();
    }

    private static BeanCreationContext createBcc(final Class<?> cls, final BeanDeclaration decl) {
        return new BeanCreationContext(){
            private final BeanHelper beanHelper = new BeanHelper();

            public void initBean(Object bean, BeanDeclaration data) {
                this.beanHelper.initBean(bean, data);
            }

            public Object getParameter() {
                return null;
            }

            public BeanDeclaration getBeanDeclaration() {
                return decl;
            }

            public Class<?> getBeanClass() {
                return cls;
            }

            public Object createBean(BeanDeclaration data) {
                return this.beanHelper.createBean(data);
            }
        };
    }

    @Test
    public void testGetDefaultBeanClass() {
        Assert.assertNull((String)"Default class is not null", (Object)this.factory.getDefaultBeanClass());
    }

    @Test
    public void testDefaultConversionHandler() {
        Assert.assertSame((String)"Wrong default conversion handler", (Object)DefaultConversionHandler.INSTANCE, (Object)this.factory.getConversionHandler());
    }

    @Test
    public void testInitWithConversionHandler() {
        ConversionHandler handler = (ConversionHandler)EasyMock.createMock(ConversionHandler.class);
        EasyMock.replay((Object[])new Object[]{handler});
        this.factory = new DefaultBeanFactory(handler);
        Assert.assertSame((String)"Wrong conversion handler", (Object)handler, (Object)this.factory.getConversionHandler());
    }

    @Test
    public void testCreateBean() throws Exception {
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("throwExceptionOnMissing", Boolean.TRUE);
        decl.setBeanProperties(props);
        Object bean = this.factory.createBean(TestDefaultBeanFactory.createBcc(PropertiesConfiguration.class, decl));
        Assert.assertNotNull((String)"New bean is null", (Object)bean);
        Assert.assertEquals((String)"Bean is of wrong class", PropertiesConfiguration.class, bean.getClass());
        PropertiesConfiguration config = (PropertiesConfiguration)bean;
        Assert.assertTrue((String)"Bean was not initialized", (boolean)config.isThrowExceptionOnMissing());
    }

    @Test
    public void testCreateBeanConstructor() throws Exception {
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        ArrayList<ConstructorArg> args = new ArrayList<ConstructorArg>();
        args.add(ConstructorArg.forValue((Object)"test"));
        args.add(ConstructorArg.forValue((Object)"42"));
        decl.setConstructorArgs(args);
        BeanCreationTestCtorBean bean = (BeanCreationTestCtorBean)this.factory.createBean(TestDefaultBeanFactory.createBcc(BeanCreationTestCtorBean.class, decl));
        Assert.assertEquals((String)"Wrong string property", (Object)"test", (Object)bean.getStringValue());
        Assert.assertEquals((String)"Wrong int property", (long)42L, (long)bean.getIntValue());
    }

    @Test
    public void testCreateBeanConstructorNestedBean() throws Exception {
        BeanDeclarationTestImpl declNested = new BeanDeclarationTestImpl();
        ArrayList<ConstructorArg> args = new ArrayList<ConstructorArg>();
        args.add(ConstructorArg.forValue((Object)"test", (String)String.class.getName()));
        declNested.setConstructorArgs(args);
        declNested.setBeanClassName(BeanCreationTestCtorBean.class.getName());
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        decl.setConstructorArgs(Collections.singleton(ConstructorArg.forBeanDeclaration((BeanDeclaration)declNested, (String)BeanCreationTestBean.class.getName())));
        BeanCreationTestCtorBean bean = (BeanCreationTestCtorBean)this.factory.createBean(TestDefaultBeanFactory.createBcc(BeanCreationTestCtorBean.class, decl));
        Assert.assertNotNull((String)"Buddy bean was not set", (Object)bean.getBuddy());
        Assert.assertEquals((String)"Wrong property of buddy bean", (Object)"test", (Object)bean.getBuddy().getStringValue());
    }

    @Test
    public void testFindMatchingConstructorNoArgs() {
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        Constructor ctor = DefaultBeanFactory.findMatchingConstructor(BeanCreationTestBean.class, (BeanDeclaration)decl);
        Assert.assertEquals((String)"Not the standard constructor", (long)0L, (long)ctor.getParameterTypes().length);
    }

    @Test
    public void testFindMatchingConstructorArgCount() {
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        ArrayList<ConstructorArg> args = new ArrayList<ConstructorArg>();
        args.add(ConstructorArg.forValue((Object)TEST_STRING));
        args.add(ConstructorArg.forValue((Object)String.valueOf(42)));
        decl.setConstructorArgs(args);
        Constructor ctor = DefaultBeanFactory.findMatchingConstructor(BeanCreationTestCtorBean.class, (BeanDeclaration)decl);
        Class<?>[] paramTypes = ctor.getParameterTypes();
        Assert.assertEquals((String)"Wrong number of parameters", (long)2L, (long)paramTypes.length);
        Assert.assertEquals((String)"Wrong parameter type 1", String.class, paramTypes[0]);
        Assert.assertEquals((String)"Wrong parameter type 2", Integer.TYPE, paramTypes[1]);
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testFindMatchingConstructorAmbiguous() {
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        ArrayList<ConstructorArg> args = new ArrayList<ConstructorArg>();
        args.add(ConstructorArg.forValue((Object)TEST_STRING));
        decl.setConstructorArgs(args);
        DefaultBeanFactory.findMatchingConstructor(BeanCreationTestCtorBean.class, (BeanDeclaration)decl);
    }

    @Test
    public void testFindMatchingConstructorExplicitType() {
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        ArrayList<ConstructorArg> args = new ArrayList<ConstructorArg>();
        args.add(ConstructorArg.forBeanDeclaration((BeanDeclaration)TestDefaultBeanFactory.setUpBeanDeclaration(), (String)BeanCreationTestBean.class.getName()));
        decl.setConstructorArgs(args);
        Constructor ctor = DefaultBeanFactory.findMatchingConstructor(BeanCreationTestCtorBean.class, (BeanDeclaration)decl);
        Class<?>[] paramTypes = ctor.getParameterTypes();
        Assert.assertEquals((String)"Wrong number of parameters", (long)1L, (long)paramTypes.length);
        Assert.assertEquals((String)"Wrong parameter type", BeanCreationTestBean.class, paramTypes[0]);
    }

    private static BeanDeclarationTestImpl setUpBeanDeclaration() {
        BeanDeclarationTestImpl data = new BeanDeclarationTestImpl();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("stringValue", TEST_STRING);
        properties.put("intValue", String.valueOf(42));
        data.setBeanProperties(properties);
        BeanDeclarationTestImpl buddyData = new BeanDeclarationTestImpl();
        HashMap<String, Object> properties2 = new HashMap<String, Object>();
        properties2.put("stringValue", "Another test string");
        properties2.put("intValue", new Integer(100));
        buddyData.setBeanProperties(properties2);
        buddyData.setBeanClassName(BeanCreationTestBean.class.getName());
        HashMap<String, Object> nested = new HashMap<String, Object>();
        nested.put("buddy", buddyData);
        data.setNestedBeanDeclarations(nested);
        return data;
    }

    @Test
    public void testFindMatchingConstructorNoMatch() {
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        ArrayList<ConstructorArg> args = new ArrayList<ConstructorArg>();
        args.add(ConstructorArg.forValue((Object)TEST_STRING, (String)this.getClass().getName()));
        decl.setConstructorArgs(args);
        try {
            DefaultBeanFactory.findMatchingConstructor(BeanCreationTestCtorBean.class, (BeanDeclaration)decl);
            Assert.fail((String)"No exception thrown!");
        }
        catch (ConfigurationRuntimeException crex) {
            String msg = crex.getMessage();
            Assert.assertTrue((String)("Bean class not found:" + msg), (msg.indexOf(BeanCreationTestCtorBean.class.getName()) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Parameter value not found: " + msg), (msg.indexOf(TEST_STRING) > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("Parameter type not found: " + msg), (msg.indexOf("(" + this.getClass().getName() + ')') > 0 ? 1 : 0) != 0);
        }
    }
}

