/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestSystemConfiguration {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testSystemConfiguration() {
        Properties props = System.getProperties();
        props.put("test.number", "123");
        SystemConfiguration conf = new SystemConfiguration();
        Assert.assertEquals((String)"number", (long)123L, (long)conf.getInt("test.number"));
    }

    @Test
    public void testSetSystemProperties() {
        PropertiesConfiguration props = new PropertiesConfiguration();
        props.addProperty("test.name", (Object)"Apache");
        SystemConfiguration.setSystemProperties((Configuration)props);
        Assert.assertEquals((String)"System Properties", (Object)"Apache", (Object)System.getProperty("test.name"));
    }

    @Test
    public void testSetSystemPropertiesFromPropertiesFile() throws ConfigurationException, IOException {
        File file = this.folder.newFile("sys.properties");
        PropertiesConfiguration pconfig = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)pconfig);
        pconfig.addProperty("fromFile", (Object)Boolean.TRUE);
        handler.setFile(file);
        handler.save();
        SystemConfiguration.setSystemProperties((String)handler.getBasePath(), (String)handler.getFileName());
        SystemConfiguration sconf = new SystemConfiguration();
        Assert.assertTrue((String)"Property from file not found", (boolean)sconf.getBoolean("fromFile"));
    }

    @Test
    public void testChangeSystemProperties() {
        String testProperty = "someTest";
        SystemConfiguration config = new SystemConfiguration();
        config.setProperty(testProperty, (Object)"true");
        Assert.assertEquals((String)"System property not changed", (Object)"true", (Object)System.getProperty(testProperty));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendWhileConcurrentAccess() throws InterruptedException {
        final AtomicBoolean stop = new AtomicBoolean();
        final String property = SystemConfiguration.class.getName() + ".testProperty";
        Thread t = new Thread(){

            @Override
            public void run() {
                boolean setValue = true;
                while (!stop.get()) {
                    if (setValue) {
                        System.setProperty(property, "true");
                    } else {
                        System.clearProperty(property);
                    }
                    setValue = !setValue;
                }
            }
        };
        try {
            t.start();
            SystemConfiguration config = new SystemConfiguration();
            PropertiesConfiguration props = new PropertiesConfiguration();
            props.append((Configuration)config);
            stop.set(true);
            t.join();
            Iterator keys = config.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (property.equals(key)) continue;
                Assert.assertEquals((String)("Wrong value for " + key), (Object)config.getString(key), (Object)props.getString(key));
            }
        }
        finally {
            System.clearProperty(property);
        }
    }
}

