/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.mojos;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Deprecated
@Mojo(name="compress-site", defaultPhase=LifecyclePhase.POST_SITE, threadSafe=true, aggregator=true)
public class CommonsSiteCompressionMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/commons-release-plugin", property="commons.outputDirectory")
    private File workingDirectory;
    @Parameter(defaultValue="${project.build.directory}/site", property="commons.siteOutputDirectory")
    private File siteDirectory;
    @Parameter(defaultValue="", property="commons.distSvnStagingUrl")
    private String distSvnStagingUrl;
    @Parameter(defaultValue="false", property="commons.release.isDistModule")
    private Boolean isDistModule;
    private List<File> filesToCompress;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isDistModule.booleanValue()) {
            this.getLog().info((CharSequence)"This module is marked as a non distribution or assembly module, and the plugin will not run.");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.distSvnStagingUrl)) {
            this.getLog().warn((CharSequence)"commons.distSvnStagingUrl is not set, the commons-release-plugin will not run.");
            return;
        }
        if (!this.siteDirectory.exists()) {
            this.getLog().error((CharSequence)"\"mvn site\" was not run before this goal, or a siteDirectory did not exist.");
            throw new MojoFailureException("\"mvn site\" was not run before this goal, or a siteDirectory did not exist.");
        }
        if (!this.workingDirectory.exists()) {
            this.getLog().info((CharSequence)"Current project contains no distributions. Not executing.");
            return;
        }
        try {
            this.filesToCompress = new ArrayList<File>();
            this.getAllSiteFiles(this.siteDirectory, this.filesToCompress);
            this.writeZipFile(this.workingDirectory, this.siteDirectory, this.filesToCompress);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Failed to create ./target/commons-release-plugin/site.zip: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Failed to create ./target/commons-release-plugin/site.zip: " + e.getMessage(), (Exception)e);
        }
    }

    private void getAllSiteFiles(File siteDirectory, List<File> filesToCompress) {
        File[] files;
        for (File file : files = siteDirectory.listFiles()) {
            filesToCompress.add(file);
            if (!file.isDirectory()) continue;
            this.getAllSiteFiles(file, filesToCompress);
        }
    }

    private void writeZipFile(File outputDirectory, File directoryToZip, List<File> fileList) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(outputDirectory.getAbsolutePath() + "/site.zip");
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (File file : fileList) {
                if (file.isDirectory()) continue;
                this.addToZip(directoryToZip, file, zos);
            }
        }
    }

    private void addToZip(File directoryToZip, File file, ZipOutputStream zos) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            String zipFilePath = file.getCanonicalPath().substring(directoryToZip.getCanonicalPath().length() + 1, file.getCanonicalPath().length());
            ZipEntry zipEntry = new ZipEntry(zipFilePath);
            zos.putNextEntry(zipEntry);
            IOUtils.copy((InputStream)fis, (OutputStream)zos);
        }
    }
}

